/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.message.EnvelopeBuilder;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.HandlerFactory;
import org.apache.axis.message.IDResolver;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeserializationContextImpl
extends DefaultHandler
implements DeserializationContext {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$encoding$DeserializationContextImpl == null ? (class$org$apache$axis$encoding$DeserializationContextImpl = DeserializationContextImpl.class$("org.apache.axis.encoding.DeserializationContextImpl")) : class$org$apache$axis$encoding$DeserializationContextImpl).getName());
    private NSStack namespaces = new NSStack();
    private Locator locator;
    private Stack handlerStack = new Stack();
    private SAX2EventRecorder recorder = new SAX2EventRecorder();
    private SOAPEnvelope envelope;
    private HashMap idMap;
    private LocalIDResolver localIDs;
    private HashMap fixups;
    static final SOAPHandler nullHandler = new SOAPHandler();
    protected MessageContext msgContext;
    protected HandlerFactory initialFactory;
    private boolean doneParsing = false;
    protected InputSource inputSource = null;
    private MessageElement curElement;
    protected int startOfMappingsPos = -1;
    static /* synthetic */ Class class$org$apache$axis$encoding$DeserializationContextImpl;

    public DeserializationContextImpl(MessageContext messageContext, EnvelopeBuilder envelopeBuilder) {
        this.msgContext = messageContext;
        this.envelope = envelopeBuilder.getEnvelope();
        this.envelope.setRecorder(this.recorder);
        this.pushElementHandler(new EnvelopeHandler(envelopeBuilder));
    }

    public DeserializationContextImpl(InputSource inputSource, MessageContext messageContext, String string) {
        EnvelopeBuilder envelopeBuilder = new EnvelopeBuilder(string);
        this.msgContext = messageContext;
        this.envelope = envelopeBuilder.getEnvelope();
        this.envelope.setRecorder(this.recorder);
        this.pushElementHandler(new EnvelopeHandler(envelopeBuilder));
        this.inputSource = inputSource;
    }

    public DeserializationContextImpl(InputSource inputSource, MessageContext messageContext, String string, SOAPEnvelope sOAPEnvelope) {
        EnvelopeBuilder envelopeBuilder = new EnvelopeBuilder(sOAPEnvelope, string);
        this.msgContext = messageContext;
        this.envelope = envelopeBuilder.getEnvelope();
        this.envelope.setRecorder(this.recorder);
        this.pushElementHandler(new EnvelopeHandler(envelopeBuilder));
        this.inputSource = inputSource;
    }

    public void parse() throws SAXException {
        if (this.inputSource != null) {
            SAXParser sAXParser = XMLUtils.getSAXParser();
            try {
                sAXParser.parse(this.inputSource, (DefaultHandler)this);
                XMLUtils.releaseSAXParser(sAXParser);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.inputSource = null;
        }
    }

    public MessageElement getCurElement() {
        return this.curElement;
    }

    public void setCurElement(MessageElement messageElement) {
        this.curElement = messageElement;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder sAX2EventRecorder) {
        this.recorder = sAX2EventRecorder;
    }

    public ArrayList getCurrentNSMappings() {
        return (ArrayList)this.namespaces.peek().clone();
    }

    public String getNamespaceURI(String string) {
        if (this.curElement != null) {
            return this.curElement.getNamespaceURI(string);
        }
        return this.namespaces.getNamespaceURI(string);
    }

    public QName getQNameFromString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        String string2 = this.getNamespaceURI(string.substring(0, n));
        if (string2 == null) {
            return null;
        }
        return new QName(string2, string.substring(n + 1));
    }

    public QName getTypeFromAttributes(String string, String string2, Attributes attributes) {
        Object object;
        Object object2 = null;
        if (object2 == null) {
            object = new QName(string, string2);
            if ("http://schemas.xmlsoap.org/soap/encoding/".equals("http://www.w3.org/2001/06/soap-encoding") && Constants.isSOAP_ENC(string)) {
                object2 = object;
            } else if (((QName)object).equals(Constants.SOAP_ARRAY)) {
                object2 = Constants.SOAP_ARRAY;
            } else if (((QName)object).equals(Constants.SOAP_STRING)) {
                object2 = Constants.SOAP_STRING;
            } else if (((QName)object).equals(Constants.SOAP_BOOLEAN)) {
                object2 = Constants.SOAP_BOOLEAN;
            } else if (((QName)object).equals(Constants.SOAP_DOUBLE)) {
                object2 = Constants.SOAP_DOUBLE;
            } else if (((QName)object).equals(Constants.SOAP_FLOAT)) {
                object2 = Constants.SOAP_FLOAT;
            } else if (((QName)object).equals(Constants.SOAP_INT)) {
                object2 = Constants.SOAP_INT;
            } else if (((QName)object).equals(Constants.SOAP_LONG)) {
                object2 = Constants.SOAP_LONG;
            } else if (((QName)object).equals(Constants.SOAP_SHORT)) {
                object2 = Constants.SOAP_SHORT;
            } else if (((QName)object).equals(Constants.SOAP_BYTE)) {
                object2 = Constants.SOAP_BYTE;
            }
        }
        if (object2 != null) {
            return object2;
        }
        object = Constants.getValue(attributes, "http://www.w3.org/2001/XMLSchema-instance", "type");
        if (object != null) {
            return this.getQNameFromString((String)object);
        }
        return null;
    }

    public boolean isNil(Attributes attributes) {
        if (attributes == null) {
            return false;
        }
        String string = Constants.getValue(attributes, "http://www.w3.org/2001/XMLSchema-instance", "nil");
        return string != null && string.equals("true");
    }

    public final Deserializer getDeserializerForType(QName qName) {
        DeserializerFactory deserializerFactory = null;
        Deserializer deserializer = null;
        try {
            deserializerFactory = (DeserializerFactory)this.getTypeMapping().getDeserializer(qName);
        }
        catch (JAXRPCException jAXRPCException) {
            log.error((Object)JavaUtils.getMessage("noFactory00", qName.toString()));
        }
        if (deserializerFactory != null) {
            try {
                deserializer = (Deserializer)deserializerFactory.getDeserializerAs("Axis SAX Mechanism");
            }
            catch (JAXRPCException jAXRPCException) {
                log.error((Object)JavaUtils.getMessage("noDeser00", qName.toString()));
            }
        }
        return deserializer;
    }

    public TypeMapping getTypeMapping() {
        TypeMappingRegistry typeMappingRegistry = this.msgContext.getTypeMappingRegistry();
        return (TypeMapping)typeMappingRegistry.getTypeMapping(this.msgContext.getEncodingStyle());
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.msgContext.getTypeMappingRegistry();
    }

    public MessageElement getElementByID(String string) {
        Object object;
        IDResolver iDResolver;
        if (this.idMap != null && (iDResolver = (IDResolver)this.idMap.get(string)) != null && (object = iDResolver.getReferencedObject(string)) instanceof MessageElement) {
            return (MessageElement)object;
        }
        return null;
    }

    public Object getObjectByRef(String string) {
        Object object = null;
        if (string != null) {
            Object object2;
            if (this.idMap != null && (object2 = (IDResolver)this.idMap.get(string)) != null) {
                object = object2.getReferencedObject(string);
            }
            if (null == object && !string.startsWith("#")) {
                object2 = null;
                object2 = this.msgContext.getCurrentMessage();
                if (null != object2) {
                    Attachments attachments = null;
                    attachments = ((Message)object2).getAttachments();
                    if (null != attachments) {
                        try {
                            object = attachments.getAttachmentByReference(string);
                        }
                        catch (AxisFault axisFault) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return object;
    }

    public void addObjectById(String string, Object object) {
        String string2 = "#" + string;
        if (this.idMap == null || string2 == null) {
            return;
        }
        IDResolver iDResolver = (IDResolver)this.idMap.get(string2);
        if (iDResolver == null) {
            return;
        }
        iDResolver.addReferencedObject(string2, object);
    }

    public void registerFixup(String string, Deserializer deserializer) {
        Deserializer deserializer2;
        if (this.fixups == null) {
            this.fixups = new HashMap();
        }
        if ((deserializer2 = this.fixups.put(string, deserializer)) != null && deserializer2 != deserializer) {
            deserializer.copyValueTargets(deserializer2);
        }
    }

    public void registerElementByID(String string, MessageElement messageElement) {
        Deserializer deserializer;
        if (this.localIDs == null) {
            this.localIDs = new LocalIDResolver();
        }
        String string2 = "#" + string;
        this.localIDs.addReferencedObject(string2, messageElement);
        this.registerResolverForID(string2, this.localIDs);
        if (this.fixups != null && (deserializer = (Deserializer)this.fixups.get(string2)) != null) {
            messageElement.setFixupDeserializer(deserializer);
        }
    }

    public void registerResolverForID(String string, IDResolver iDResolver) {
        if (string == null || iDResolver == null) {
            return;
        }
        if (this.idMap == null) {
            this.idMap = new HashMap();
        }
        this.idMap.put(string, iDResolver);
    }

    public int getCurrentRecordPos() {
        if (this.recorder == null) {
            return -1;
        }
        return this.recorder.getLength() - 1;
    }

    public int getStartOfMappingsPos() {
        if (this.startOfMappingsPos == -1) {
            return this.getCurrentRecordPos() + 1;
        }
        return this.startOfMappingsPos;
    }

    public void pushNewElement(MessageElement messageElement) {
        if (this.recorder != null) {
            this.recorder.newElement(messageElement);
        }
        messageElement.setParent(this.curElement);
        this.curElement = messageElement;
    }

    public SOAPHandler getTopHandler() {
        try {
            return (SOAPHandler)this.handlerStack.peek();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void pushElementHandler(SOAPHandler sOAPHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("pushHandler00", "" + sOAPHandler));
        }
        this.handlerStack.push(sOAPHandler);
    }

    public void replaceElementHandler(SOAPHandler sOAPHandler) {
        this.handlerStack.pop();
        this.handlerStack.push(sOAPHandler);
    }

    public SOAPHandler popElementHandler() {
        if (!this.handlerStack.empty()) {
            SOAPHandler sOAPHandler = this.getTopHandler();
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("popHandler00", "" + sOAPHandler));
            }
            this.handlerStack.pop();
            return sOAPHandler;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("popHandler00", "(null)"));
        }
        return null;
    }

    public void startDocument() throws SAXException {
        if (this.recorder != null) {
            this.recorder.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("endDoc00"));
        }
        if (this.recorder != null) {
            this.recorder.endDocument();
        }
        this.doneParsing = true;
    }

    public boolean isDoneParsing() {
        return this.doneParsing;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        SOAPHandler sOAPHandler;
        if (this.recorder != null) {
            this.recorder.startPrefixMapping(string, string2);
        }
        if (this.startOfMappingsPos == -1) {
            this.startOfMappingsPos = this.getCurrentRecordPos();
        }
        if (string != null) {
            this.namespaces.add(string2, string);
        } else {
            this.namespaces.add(string2, "");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("startPrefix00", string, string2));
        }
        if ((sOAPHandler = this.getTopHandler()) != null) {
            sOAPHandler.startPrefixMapping(string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        SOAPHandler sOAPHandler;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("endPrefix00", string));
        }
        if (this.recorder != null) {
            this.recorder.endPrefixMapping(string);
        }
        if ((sOAPHandler = this.getTopHandler()) != null) {
            sOAPHandler.endPrefixMapping(string);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.recorder != null) {
            this.recorder.setDocumentLocator(locator);
        }
        this.locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.recorder != null) {
            this.recorder.characters(cArray, n, n2);
        }
        if (this.getTopHandler() != null) {
            this.getTopHandler().characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.recorder != null) {
            this.recorder.ignorableWhitespace(cArray, n, n2);
        }
        if (this.getTopHandler() != null) {
            this.getTopHandler().ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        throw new SAXException(JavaUtils.getMessage("noInstructions00"));
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.recorder != null) {
            this.recorder.skippedEntity(string);
        }
        this.getTopHandler().skippedEntity(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        SOAPHandler sOAPHandler = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("startElem00", "['" + string + "' " + string2 + "]"));
        }
        String string4 = "";
        int n = string3.indexOf(":");
        if (n > 0) {
            string4 = string3.substring(0, n);
        }
        if (!this.handlerStack.isEmpty()) {
            sOAPHandler = this.getTopHandler().onStartChild(string, string2, string4, attributes, this);
        }
        if (sOAPHandler == null) {
            sOAPHandler = new SOAPHandler();
        }
        this.pushElementHandler(sOAPHandler);
        sOAPHandler.startElement(string, string2, string3, attributes, this);
        if (this.recorder != null) {
            this.recorder.startElement(string, string2, string3, attributes);
            if (!this.doneParsing) {
                this.curElement.setContentsIndex(this.recorder.getLength());
            }
        }
        this.namespaces.push();
        this.startOfMappingsPos = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("endElem00", "['" + string + "' " + string2 + "]"));
        }
        if (this.recorder != null) {
            this.recorder.endElement(string, string2, string3);
        }
        try {
            SOAPHandler sOAPHandler = this.popElementHandler();
            sOAPHandler.endElement(string, string2, this);
            if (!this.handlerStack.isEmpty()) {
                this.getTopHandler().onEndChild(string, string2, this);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("endDoc01"));
            }
            Object var6_5 = null;
            if (this.curElement != null) {
                this.curElement = this.curElement.getParent();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.curElement != null) {
                this.curElement = this.curElement.getParent();
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class LocalIDResolver
    implements IDResolver {
        HashMap idMap = null;

        private LocalIDResolver() {
        }

        public void addReferencedObject(String string, Object object) {
            if (this.idMap == null) {
                this.idMap = new HashMap();
            }
            this.idMap.put(string, object);
        }

        public Object getReferencedObject(String string) {
            if (this.idMap == null || string == null) {
                return null;
            }
            return this.idMap.get(string);
        }
    }
}

