/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.deployment.DeploymentException;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.JavaUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDUndeployment
extends WSDDElement
implements WSDDTypeMappingContainer {
    private Vector handlers = new Vector();
    private Vector chains = new Vector();
    private Vector services = new Vector();
    private Vector transports = new Vector();
    private Vector typeMappings = new Vector();

    public void addHandler(QName qName) {
        this.handlers.add(qName);
    }

    public void addChain(QName qName) {
        this.chains.add(qName);
    }

    public void addTransport(QName qName) {
        this.transports.add(qName);
    }

    public void addService(QName qName) {
        this.services.add(qName);
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        this.typeMappings.add(wSDDTypeMapping);
    }

    public WSDDUndeployment() {
    }

    private QName getQName(Element element) throws WSDDException {
        String string = element.getAttribute("name");
        if (string == null || "".equals(string)) {
            throw new WSDDException(JavaUtils.getMessage("badNameAttr00"));
        }
        return new QName("", string);
    }

    public WSDDUndeployment(Element element) throws WSDDException {
        super(element);
        Element[] elementArray = this.getChildElements(element, "handler");
        int n = 0;
        while (n < elementArray.length) {
            this.addHandler(this.getQName(elementArray[n]));
            ++n;
        }
        elementArray = this.getChildElements(element, "chain");
        n = 0;
        while (n < elementArray.length) {
            this.addChain(this.getQName(elementArray[n]));
            ++n;
        }
        elementArray = this.getChildElements(element, "transport");
        n = 0;
        while (n < elementArray.length) {
            this.addTransport(this.getQName(elementArray[n]));
            ++n;
        }
        elementArray = this.getChildElements(element, "service");
        n = 0;
        while (n < elementArray.length) {
            this.addService(this.getQName(elementArray[n]));
            ++n;
        }
    }

    protected QName getElementName() {
        return WSDDConstants.UNDEPLOY_QNAME;
    }

    public void undeployFromRegistry(WSDDDeployment wSDDDeployment) throws DeploymentException {
        QName qName;
        int n = 0;
        while (n < this.handlers.size()) {
            qName = (QName)this.handlers.get(n);
            wSDDDeployment.undeployHandler(qName);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.chains.size()) {
            qName = (QName)this.chains.get(n2);
            wSDDDeployment.undeployHandler(qName);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.transports.size()) {
            qName = (QName)this.transports.get(n3);
            wSDDDeployment.undeployTransport(qName);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.services.size()) {
            qName = (QName)this.services.get(n4);
            wSDDDeployment.undeployService(qName);
            ++n4;
        }
    }

    private void writeElement(SerializationContext serializationContext, QName qName, QName qName2) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.qName2String(qName2));
        serializationContext.startElement(qName, attributesImpl);
        serializationContext.endElement();
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        QName qName;
        serializationContext.registerPrefixForURI("", "http://xml.apache.org/axis/wsdd/");
        serializationContext.startElement(WSDDConstants.UNDEPLOY_QNAME, null);
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            qName = (QName)iterator.next();
            this.writeElement(serializationContext, WSDDConstants.HANDLER_QNAME, qName);
        }
        iterator = this.chains.iterator();
        while (iterator.hasNext()) {
            qName = (QName)iterator.next();
            this.writeElement(serializationContext, WSDDConstants.CHAIN_QNAME, qName);
        }
        iterator = this.services.iterator();
        while (iterator.hasNext()) {
            qName = (QName)iterator.next();
            this.writeElement(serializationContext, WSDDConstants.SERVICE_QNAME, qName);
        }
        iterator = this.transports.iterator();
        while (iterator.hasNext()) {
            qName = (QName)iterator.next();
            this.writeElement(serializationContext, WSDDConstants.TRANSPORT_QNAME, qName);
        }
        iterator = this.typeMappings.iterator();
        while (iterator.hasNext()) {
            WSDDTypeMapping wSDDTypeMapping = (WSDDTypeMapping)iterator.next();
            wSDDTypeMapping.writeToContext(serializationContext);
        }
        serializationContext.endElement();
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] wSDDTypeMappingArray = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.toArray(wSDDTypeMappingArray);
        return wSDDTypeMappingArray;
    }
}

