/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.deployment.wsdd.WSDDDeployableItem;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDFaultFlow;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;

public abstract class WSDDTargetedChain
extends WSDDDeployableItem {
    private WSDDRequestFlow requestFlow;
    private WSDDResponseFlow responseFlow;
    private QName pivotQName;

    protected WSDDTargetedChain() {
    }

    protected WSDDTargetedChain(Element element) throws WSDDException {
        super(element);
        String string;
        Element element2;
        Element element3 = this.getChildElement(element, "requestFlow");
        if (element3 != null) {
            this.requestFlow = new WSDDRequestFlow(element3);
        }
        if ((element2 = this.getChildElement(element, "responseFlow")) != null) {
            this.responseFlow = new WSDDResponseFlow(element2);
        }
        if ((string = element.getAttribute("pivot")) != null && !string.equals("")) {
            this.pivotQName = XMLUtils.getQNameFromString(string, element);
        }
    }

    public WSDDRequestFlow getRequestFlow() {
        return this.requestFlow;
    }

    public void setRequestFlow(WSDDRequestFlow wSDDRequestFlow) {
        this.requestFlow = wSDDRequestFlow;
    }

    public WSDDResponseFlow getResponseFlow() {
        return this.responseFlow;
    }

    public void setResponseFlow(WSDDResponseFlow wSDDResponseFlow) {
        this.responseFlow = wSDDResponseFlow;
    }

    public WSDDFaultFlow[] getFaultFlows() {
        return null;
    }

    public WSDDFaultFlow getFaultFlow(QName qName) {
        WSDDFaultFlow[] wSDDFaultFlowArray = this.getFaultFlows();
        int n = 0;
        while (n < wSDDFaultFlowArray.length) {
            if (wSDDFaultFlowArray[n].getQName().equals(qName)) {
                return wSDDFaultFlowArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setType(String string) throws WSDDException {
        throw new WSDDException(this.getElementName().getLocalPart() + " disallows setting of Type");
    }

    public QName getPivotQName() {
        return this.pivotQName;
    }

    public void setPivotQName(QName qName) {
        this.pivotQName = qName;
    }

    public Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        Handler handler = null;
        WSDDRequestFlow wSDDRequestFlow = this.getRequestFlow();
        if (wSDDRequestFlow != null) {
            handler = wSDDRequestFlow.getInstance(engineConfiguration);
        }
        Handler handler2 = null;
        if (this.pivotQName != null) {
            if ("http://xml.apache.org/axis/wsdd/providers/java".equals(this.pivotQName.getNamespaceURI())) {
                try {
                    handler2 = (Handler)Class.forName(this.pivotQName.getLocalPart()).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new ConfigurationException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ConfigurationException(illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ConfigurationException(classNotFoundException);
                }
            } else {
                handler2 = engineConfiguration.getHandler(this.pivotQName);
            }
        }
        Handler handler3 = null;
        WSDDResponseFlow wSDDResponseFlow = this.getResponseFlow();
        if (wSDDResponseFlow != null) {
            handler3 = wSDDResponseFlow.getInstance(engineConfiguration);
        }
        return new SimpleTargetedChain(handler, handler2, handler3);
    }

    public final void writeFlowsToContext(SerializationContext serializationContext) throws IOException {
        if (this.requestFlow != null) {
            this.requestFlow.writeToContext(serializationContext);
        }
        if (this.responseFlow != null) {
            this.responseFlow.writeToContext(serializationContext);
        }
    }

    public void deployToRegistry(WSDDDeployment wSDDDeployment) {
        if (this.requestFlow != null) {
            this.requestFlow.deployToRegistry(wSDDDeployment);
        }
        if (this.responseFlow != null) {
            this.responseFlow.deployToRegistry(wSDDDeployment);
        }
    }
}

