/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.FaultableHandler;
import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDBeanMapping;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDFaultFlow;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.deployment.wsdd.WSDDTargetedChain;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDService
extends WSDDTargetedChain
implements WSDDTypeMappingContainer {
    public static final QName elMapQName = new QName("", "elementMapping");
    public TypeMappingRegistry tmr = null;
    private Vector faultFlows = new Vector();
    private Vector typeMappings = new Vector();
    private Vector namespaces = new Vector();
    private HashMap qName2MethodMap = null;
    private String descriptionURL;
    private int style = 0;
    private SOAPService cachedService = null;
    private QName providerQName;

    public WSDDService() {
    }

    public WSDDService(Element element) throws WSDDException {
        super(element);
        String string;
        String string2;
        Object object;
        Object object2;
        Element[] elementArray = this.getChildElements(element, "typeMapping");
        int n = 0;
        while (n < elementArray.length) {
            object2 = new WSDDTypeMapping(elementArray[n]);
            this.typeMappings.add(object2);
            ++n;
        }
        object2 = this.getChildElements(element, "beanMapping");
        int n2 = 0;
        while (n2 < ((Element[])object2).length) {
            object = new WSDDBeanMapping(object2[n2]);
            this.typeMappings.add(object);
            ++n2;
        }
        object = this.getChildElements(element, "namespace");
        int n3 = 0;
        while (n3 < ((Element[])object).length) {
            string2 = XMLUtils.getChildCharacterData(object[n3]);
            this.namespaces.add(string2);
            ++n3;
        }
        string2 = element.getAttribute("provider");
        if (string2 != null && !string2.equals("")) {
            this.providerQName = XMLUtils.getQNameFromString(string2, element);
        }
        if ((string = element.getAttribute("style")) != null && string.equals("document")) {
            this.style = 1;
            Element[] elementArray2 = this.getChildElements(element, "elementMapping");
            if (elementArray2.length > 0 && this.qName2MethodMap == null) {
                this.qName2MethodMap = new HashMap();
            }
            int n4 = 0;
            while (n4 < elementArray2.length) {
                Element element2 = elementArray2[n4];
                String string3 = element2.getAttribute("element");
                QName qName = XMLUtils.getQNameFromString(string3, element2);
                String string4 = element2.getAttribute("method");
                this.qName2MethodMap.put(qName, string4);
                ++n4;
            }
        }
    }

    public void addTypeMapping(WSDDTypeMapping wSDDTypeMapping) {
        this.typeMappings.add(wSDDTypeMapping);
    }

    protected QName getElementName() {
        return WSDDConstants.SERVICE_QNAME;
    }

    public String getServiceDescriptionURL() {
        return this.descriptionURL;
    }

    public void setServiceDescriptionURL(String string) {
        this.descriptionURL = string;
    }

    public QName getProviderQName() {
        return this.providerQName;
    }

    public void setProviderQName(QName qName) {
        this.providerQName = qName;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public WSDDFaultFlow[] getFaultFlows() {
        WSDDFaultFlow[] wSDDFaultFlowArray = new WSDDFaultFlow[this.faultFlows.size()];
        this.faultFlows.toArray(wSDDFaultFlowArray);
        return wSDDFaultFlowArray;
    }

    public Vector getNamespaces() {
        return this.namespaces;
    }

    public WSDDFaultFlow getFaultFlow(QName qName) {
        WSDDFaultFlow[] wSDDFaultFlowArray = this.getFaultFlows();
        int n = 0;
        while (n < wSDDFaultFlowArray.length) {
            if (wSDDFaultFlowArray[n].getQName().equals(qName)) {
                return wSDDFaultFlowArray[n];
            }
            ++n;
        }
        return null;
    }

    public Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        if (this.cachedService != null) {
            return this.cachedService;
        }
        Handler handler = null;
        WSDDRequestFlow wSDDRequestFlow = this.getRequestFlow();
        if (wSDDRequestFlow != null) {
            handler = wSDDRequestFlow.getInstance(engineConfiguration);
        }
        Handler handler2 = null;
        if (this.providerQName != null) {
            try {
                handler2 = WSDDProvider.getInstance(this.providerQName, this, engineConfiguration);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
            if (handler2 == null) {
                throw new WSDDException(JavaUtils.getMessage("couldntConstructProvider00"));
            }
        }
        Handler handler3 = null;
        WSDDResponseFlow wSDDResponseFlow = this.getResponseFlow();
        if (wSDDResponseFlow != null) {
            handler3 = wSDDResponseFlow.getInstance(engineConfiguration);
        }
        SOAPService sOAPService = new SOAPService(handler, handler2, handler3);
        sOAPService.setStyle(this.style);
        if (this.getQName() != null) {
            sOAPService.setName(this.getQName().getLocalPart());
        }
        sOAPService.setOptions(this.getParametersTable());
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        int n = 0;
        while (n < this.typeMappings.size()) {
            this.deployTypeMapping((WSDDTypeMapping)this.typeMappings.get(n));
            ++n;
        }
        sOAPService.setTypeMappingRegistry(this.tmr);
        this.tmr.delegate(engineConfiguration.getTypeMappingRegistry());
        WSDDFaultFlow[] wSDDFaultFlowArray = this.getFaultFlows();
        if (wSDDFaultFlowArray != null && wSDDFaultFlowArray.length > 0) {
            FaultableHandler faultableHandler = new FaultableHandler(sOAPService);
            int n2 = 0;
            while (n2 < wSDDFaultFlowArray.length) {
                WSDDFaultFlow wSDDFaultFlow = wSDDFaultFlowArray[n2];
                Handler handler4 = wSDDFaultFlow.getInstance(engineConfiguration);
                faultableHandler.setOption("fault-" + wSDDFaultFlow.getQName().getLocalPart(), handler4);
                ++n2;
            }
        }
        sOAPService.setElementMap(this.qName2MethodMap);
        this.cachedService = sOAPService;
        return sOAPService;
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        if (!this.typeMappings.contains(wSDDTypeMapping)) {
            this.typeMappings.add(wSDDTypeMapping);
        }
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        try {
            String string = wSDDTypeMapping.getEncodingStyle();
            if (string == null) {
                string = this.style == 0 ? "http://schemas.xmlsoap.org/soap/encoding/" : "";
            }
            TypeMapping typeMapping = (TypeMapping)this.tmr.getTypeMapping(string);
            TypeMapping typeMapping2 = (TypeMapping)this.tmr.getDefaultTypeMapping();
            if (typeMapping == null || typeMapping == typeMapping2) {
                typeMapping = (TypeMapping)this.tmr.createTypeMapping();
                typeMapping.setSupportedNamespaces(new String[]{string});
                this.tmr.register(string, typeMapping);
            }
            SerializerFactory serializerFactory = null;
            DeserializerFactory deserializerFactory = null;
            if (wSDDTypeMapping.getSerializerName() != null && !wSDDTypeMapping.getSerializerName().equals("")) {
                serializerFactory = BaseSerializerFactory.createFactory(wSDDTypeMapping.getSerializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
            }
            if (wSDDTypeMapping.getDeserializerName() != null && !wSDDTypeMapping.getDeserializerName().equals("")) {
                deserializerFactory = BaseDeserializerFactory.createFactory(wSDDTypeMapping.getDeserializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
            }
            typeMapping.register(wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), serializerFactory, deserializerFactory);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WSDDException(classNotFoundException);
        }
        catch (Exception exception) {
            throw new WSDDException(exception);
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        Set set;
        AttributesImpl attributesImpl = new AttributesImpl();
        QName qName = this.getQName();
        if (qName != null) {
            attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.qName2String(qName));
        }
        if (this.providerQName != null) {
            attributesImpl.addAttribute("", "provider", "provider", "CDATA", serializationContext.qName2String(this.providerQName));
        }
        if (this.style == 1) {
            attributesImpl.addAttribute("", "style", "style", "CDATA", "document");
        }
        serializationContext.startElement(WSDDConstants.SERVICE_QNAME, attributesImpl);
        this.writeFlowsToContext(serializationContext);
        this.writeParamsToContext(serializationContext);
        if (this.style == 1 && this.qName2MethodMap != null && (set = this.qName2MethodMap.keySet()) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                QName qName2 = (QName)iterator.next();
                String string = (String)this.qName2MethodMap.get(qName2);
                String string2 = serializationContext.qName2String(qName2);
                attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute("", "method", "method", "CDATA", string);
                attributesImpl.addAttribute("", "element", "element", "CDATA", string2);
                serializationContext.startElement(elMapQName, attributesImpl);
                serializationContext.endElement();
            }
        }
        int n = 0;
        while (n < this.typeMappings.size()) {
            ((WSDDTypeMapping)this.typeMappings.elementAt(n)).writeToContext(serializationContext);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.namespaces.size()) {
            serializationContext.startElement(new QName("", "namespace"), null);
            serializationContext.writeString((String)this.namespaces.get(n2));
            serializationContext.endElement();
            ++n2;
        }
        serializationContext.endElement();
    }

    public void setCachedService(SOAPService sOAPService) {
        this.cachedService = sOAPService;
    }

    public void deployToRegistry(WSDDDeployment wSDDDeployment) {
        wSDDDeployment.addService(this);
        wSDDDeployment.registerNamespaceForService(this.getQName().getLocalPart(), this);
        int n = 0;
        while (n < this.namespaces.size()) {
            String string = (String)this.namespaces.elementAt(n);
            wSDDDeployment.registerNamespaceForService(string, this);
            ++n;
        }
        super.deployToRegistry(wSDDDeployment);
    }

    public void removeNamespaceMappings(WSDDDeployment wSDDDeployment) {
        int n = 0;
        while (n < this.namespaces.size()) {
            String string = (String)this.namespaces.elementAt(n);
            wSDDDeployment.removeNamespaceMapping(string);
            ++n;
        }
    }
}

