/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDDocumentation;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.JavaUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class WSDDElement
implements Serializable {
    private WSDDDocumentation documentation = null;
    private String name;

    public WSDDElement() {
    }

    public WSDDElement(Element element) throws WSDDException {
        this.validateCandidateElement(element);
    }

    protected abstract QName getElementName();

    private void validateCandidateElement(Element element) throws WSDDException {
        QName qName = this.getElementName();
        if (null == element || null == element.getNamespaceURI() || null == element.getLocalName() || !element.getNamespaceURI().equals(qName.getNamespaceURI()) || !element.getLocalName().equals(qName.getLocalPart())) {
            throw new WSDDException(JavaUtils.getMessage("invalidWSDD00", element.getLocalName(), qName.getLocalPart()));
        }
    }

    public Element getChildElement(Element element, String string) {
        Element[] elementArray = this.getChildElements(element, string);
        if (elementArray.length == 0) {
            return null;
        }
        return elementArray[0];
    }

    public Element[] getChildElements(Element element, String string) {
        Object object;
        NodeList nodeList = element.getChildNodes();
        Vector<Element> vector = new Vector<Element>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            object = nodeList.item(n);
            if (object instanceof Element && (element2 = (Element)object).getLocalName().equals(string)) {
                vector.add(element2);
            }
            ++n;
        }
        object = new Element[vector.size()];
        vector.toArray((T[])object);
        return object;
    }

    public WSDDDocumentation getDocumentation() {
        return this.documentation;
    }

    public abstract void writeToContext(SerializationContext var1) throws IOException;
}

