/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.axis.deployment.DeploymentException;
import org.apache.axis.deployment.DeploymentRegistry;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDUndeployment;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDDDocument {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$deployment$wsdd$WSDDDocument == null ? (class$org$apache$axis$deployment$wsdd$WSDDDocument = WSDDDocument.class$("org.apache.axis.deployment.wsdd.WSDDDocument")) : class$org$apache$axis$deployment$wsdd$WSDDDocument).getName());
    private Document doc;
    private WSDDDeployment deployment;
    private WSDDUndeployment undeployment;
    static /* synthetic */ Class class$org$apache$axis$deployment$wsdd$WSDDDocument;

    public WSDDDocument() {
    }

    public WSDDDocument(Document document) throws WSDDException {
        this.doc = document;
        Element element = document.getDocumentElement();
        if ("undeployment".equals(element.getLocalName())) {
            this.undeployment = new WSDDUndeployment(element);
        } else {
            this.deployment = new WSDDDeployment(element);
        }
    }

    public WSDDDocument(Element element) throws WSDDException {
        this.doc = element.getOwnerDocument();
        if ("undeployment".equals(element.getLocalName())) {
            this.undeployment = new WSDDUndeployment(element);
        } else {
            this.deployment = new WSDDDeployment(element);
        }
    }

    public WSDDDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new WSDDDeployment();
        }
        return this.deployment;
    }

    public Document getDOMDocument() throws DeploymentException {
        StringWriter stringWriter = new StringWriter();
        SerializationContextImpl serializationContextImpl = new SerializationContextImpl(stringWriter, null);
        serializationContextImpl.setPretty(true);
        try {
            this.deployment.writeToContext(serializationContextImpl);
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
        }
        try {
            stringWriter.close();
            return XMLUtils.newDocument(new InputSource(new StringReader(stringWriter.getBuffer().toString())));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        this.getDeployment().writeToContext(serializationContext);
    }

    public void setDocument(Document document) {
        this.doc = document;
        this.deployment = null;
    }

    public void deploy(WSDDDeployment wSDDDeployment) throws DeploymentException {
        if (this.deployment != null) {
            this.deployment.deployToRegistry(wSDDDeployment);
        }
        if (this.undeployment != null) {
            this.undeployment.undeployFromRegistry(wSDDDeployment);
        }
    }

    public void undeploy(DeploymentRegistry deploymentRegistry) throws DeploymentException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

