/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.DeployableItem;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public abstract class WSDDDeployableItem
extends WSDDElement
implements DeployableItem {
    public static final int SCOPE_PER_ACCESS = 0;
    public static final int SCOPE_PER_REQUEST = 1;
    public static final int SCOPE_SINGLETON = 2;
    public static String[] scopeStrings = new String[]{"per-access", "per-request", "singleton"};
    LockableHashtable parameters;
    QName qname;
    QName type;
    int scope = 2;
    Handler singletonInstance = null;

    public WSDDDeployableItem() {
    }

    public WSDDDeployableItem(Element element) throws WSDDException {
        super(element);
        String string;
        String string2;
        String string3 = element.getAttribute("name");
        if (string3 != null && !string3.equals("")) {
            this.qname = new QName("", string3);
        }
        if ((string2 = element.getAttribute("type")) != null && !string2.equals("")) {
            this.type = XMLUtils.getQNameFromString(string2, element);
        }
        if ((string = element.getAttribute("scope")) != null) {
            int n = 0;
            while (n < scopeStrings.length) {
                if (string.equals(scopeStrings[n])) {
                    this.scope = n;
                    break;
                }
                ++n;
            }
        }
        if (this.parameters == null) {
            this.parameters = new LockableHashtable();
        }
        Element[] elementArray = this.getChildElements(element, "parameter");
        int n = 0;
        while (n < elementArray.length) {
            Element element2 = elementArray[n];
            String string4 = element2.getAttribute("name");
            String string5 = element2.getAttribute("value");
            String string6 = element2.getAttribute("locked");
            this.parameters.put(string4, string5, string6 != null && string6.equalsIgnoreCase("true"));
            ++n;
        }
    }

    public void setName(String string) {
        this.qname = new QName(null, string);
    }

    public void setQName(QName qName) {
        this.qname = qName;
    }

    public QName getQName() {
        return this.qname;
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName qName) {
        this.type = qName;
    }

    public void setParameter(String string, String string2) {
        if (this.parameters == null) {
            this.parameters = new LockableHashtable();
        }
        this.parameters.put(string, string2);
    }

    public String getParameter(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.parameters.get(string);
    }

    public LockableHashtable getParametersTable() {
        return this.parameters;
    }

    public void setOptionsHashtable(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        this.parameters = new LockableHashtable((Map)hashtable);
    }

    public void writeParamsToContext(SerializationContext serializationContext) throws IOException {
        if (this.parameters == null) {
            return;
        }
        Set set = this.parameters.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "name", "name", "CDATA", string);
            attributesImpl.addAttribute("", "value", "value", "CDATA", this.parameters.get(string).toString());
            if (this.parameters.isKeyLocked(string)) {
                attributesImpl.addAttribute("", "locked", "locked", "CDATA", "true");
            }
            serializationContext.startElement(WSDDConstants.PARAM_QNAME, attributesImpl);
            serializationContext.endElement();
        }
    }

    public void removeParameter(String string) {
        this.parameters.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Handler getInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        if (this.scope == 2) {
            WSDDDeployableItem wSDDDeployableItem = this;
            synchronized (wSDDDeployableItem) {
                if (this.singletonInstance == null) {
                    this.singletonInstance = this.makeNewInstance(engineConfiguration);
                }
            }
            return this.singletonInstance;
        }
        return this.makeNewInstance(engineConfiguration);
    }

    protected Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        Class clazz = null;
        Handler handler = null;
        try {
            clazz = this.getJavaClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException(classNotFoundException);
        }
        if (clazz != null) {
            try {
                handler = (Handler)this.createInstance(clazz);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
            if (handler != null) {
                if (this.qname != null) {
                    handler.setName(this.qname.getLocalPart());
                }
                handler.setOptions(this.getParametersTable());
            }
        } else {
            handler = engineConfiguration.getHandler(this.getType());
        }
        return handler;
    }

    Object createInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public Class getJavaClass() throws ClassNotFoundException {
        QName qName = this.getType();
        if (qName != null && "http://xml.apache.org/axis/wsdd/providers/java".equals(qName.getNamespaceURI())) {
            return Class.forName(qName.getLocalPart());
        }
        return null;
    }
}

