/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.JavaUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDChain
extends WSDDHandler {
    private Vector handlers = new Vector();

    public WSDDChain() {
    }

    public WSDDChain(Element element) throws WSDDException {
        super(element);
        WSDDHandler wSDDHandler;
        int n;
        if (this.type != null) {
            return;
        }
        Element[] elementArray = this.getChildElements(element, "handler");
        if (elementArray.length != 0) {
            n = 0;
            while (n < elementArray.length) {
                wSDDHandler = new WSDDHandler(elementArray[n]);
                this.addHandler(wSDDHandler);
                ++n;
            }
        }
        if ((elementArray = this.getChildElements(element, "chain")).length != 0) {
            n = 0;
            while (n < elementArray.length) {
                wSDDHandler = new WSDDChain(elementArray[n]);
                this.addHandler(wSDDHandler);
                ++n;
            }
        }
        if (this.handlers.isEmpty()) {
            throw new WSDDException(JavaUtils.getMessage("noHandlersInChain00", this.getElementName().getLocalPart(), this.getQName().toString()));
        }
    }

    protected QName getElementName() {
        return WSDDConstants.CHAIN_QNAME;
    }

    public void addHandler(WSDDHandler wSDDHandler) {
        this.handlers.add(wSDDHandler);
    }

    public Vector getHandlers() {
        return this.handlers;
    }

    public void removeHandler(WSDDHandler wSDDHandler) {
        this.handlers.remove(wSDDHandler);
    }

    public Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        SimpleChain simpleChain = new SimpleChain();
        int n = 0;
        while (n < this.handlers.size()) {
            WSDDHandler wSDDHandler = (WSDDHandler)this.handlers.get(n);
            simpleChain.addHandler(wSDDHandler.getInstance(engineConfiguration));
            ++n;
        }
        return simpleChain;
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        QName qName = this.getQName();
        if (qName != null) {
            attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.qName2String(qName));
        }
        if (this.getType() != null) {
            attributesImpl.addAttribute("", "type", "type", "CDATA", serializationContext.qName2String(this.getType()));
        }
        serializationContext.startElement(this.getElementName(), attributesImpl);
        int n = 0;
        while (n < this.handlers.size()) {
            WSDDHandler wSDDHandler = (WSDDHandler)this.handlers.get(n);
            wSDDHandler.writeToContext(serializationContext);
            ++n;
        }
        serializationContext.endElement();
    }

    public void deployToRegistry(WSDDDeployment wSDDDeployment) {
        if (this.getQName() != null) {
            wSDDDeployment.addHandler(this);
        }
        int n = 0;
        while (n < this.handlers.size()) {
            WSDDHandler wSDDHandler = (WSDDHandler)this.handlers.get(n);
            if (wSDDHandler.getQName() != null) {
                wSDDHandler.deployToRegistry(wSDDDeployment);
            }
            ++n;
        }
    }
}

