/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.v2dd;

import java.io.Serializable;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.DeployableItem;
import org.apache.axis.deployment.DeploymentException;
import org.apache.axis.deployment.DeploymentRegistry;
import org.apache.axis.deployment.v2dd.V2DDProvider;
import org.apache.axis.deployment.v2dd.V2DDService;
import org.apache.axis.deployment.v2dd.providers.V2DDComProvider;
import org.apache.axis.deployment.v2dd.providers.V2DDScriptProvider;
import org.apache.axis.providers.BSFProvider;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.providers.ComProvider;
import org.apache.axis.providers.java.RPCProvider;

public class V2DDDeployableItem
implements DeployableItem,
Serializable {
    V2DDService service;
    QName qname;

    public V2DDDeployableItem(V2DDService v2DDService) {
        this.service = v2DDService;
    }

    public QName getQName() {
        if (this.qname == null) {
            this.qname = new QName(null, this.service.getID());
        }
        return this.qname;
    }

    public Handler getInstance(EngineConfiguration engineConfiguration) {
        try {
            V2DDProvider v2DDProvider = this.service.getProvider();
            String[] stringArray = v2DDProvider.getMethods();
            BasicProvider basicProvider = null;
            if (v2DDProvider instanceof V2DDComProvider) {
                basicProvider = new ComProvider();
            }
            if (v2DDProvider instanceof V2DDScriptProvider) {
                basicProvider = new BSFProvider();
            }
            if (basicProvider == null) {
                basicProvider = new RPCProvider();
            }
            basicProvider.setOptions(v2DDProvider.getOptionsTable());
            v2DDProvider.newInstance(basicProvider);
            int n = 0;
            while (n < stringArray.length) {
                basicProvider.addOperation(stringArray[n], new QName("http://xml.apache.org/xml-soap/deployment", stringArray[n]));
                ++n;
            }
            return basicProvider;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void deployToRegistry(DeploymentRegistry deploymentRegistry) throws DeploymentException {
    }
}

