/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Hashtable;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class FileProvider
implements EngineConfiguration {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$configuration$FileProvider == null ? (class$org$apache$axis$configuration$FileProvider = FileProvider.class$("org.apache.axis.configuration.FileProvider")) : class$org$apache$axis$configuration$FileProvider).getName());
    protected String sep = System.getProperty("file.separator");
    protected WSDDDeployment deployment = null;
    private static final String CURRENT_DIR = ".";
    protected String filename;
    protected File configFile = null;
    protected InputStream myInputStream = null;
    protected boolean readOnly = true;
    boolean searchClasspath = true;
    static /* synthetic */ Class class$org$apache$axis$configuration$FileProvider;

    public FileProvider(String string) {
        this.filename = string;
        this.configFile = new File(string);
        this.check();
    }

    public FileProvider(String string, String string2) throws ConfigurationException {
        this.filename = string2;
        File file = new File(string);
        if (!file.isDirectory() || !file.canRead()) {
            throw new ConfigurationException(JavaUtils.getMessage("invalidConfigFilePath", string));
        }
        this.configFile = new File(string, string2);
        this.check();
    }

    private void check() {
        this.readOnly = this.configFile.canRead() & !this.configFile.canWrite();
        if (this.readOnly) {
            log.info((Object)JavaUtils.getMessage("readOnlyConfigFile"));
        }
    }

    public FileProvider(InputStream inputStream) {
        this.myInputStream = inputStream;
    }

    public WSDDDeployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(WSDDDeployment wSDDDeployment) {
        this.deployment = wSDDDeployment;
    }

    public void setSearchClasspath(boolean bl) {
        this.searchClasspath = bl;
    }

    public void configureEngine(AxisEngine axisEngine) throws ConfigurationException {
        try {
            block6: {
                if (this.myInputStream == null) {
                    try {
                        this.myInputStream = new FileInputStream(this.configFile);
                    }
                    catch (Exception exception) {
                        if (!this.searchClasspath) break block6;
                        this.myInputStream = axisEngine.getClass().getResourceAsStream(this.filename);
                    }
                }
            }
            if (this.myInputStream == null) {
                throw new ConfigurationException("No engine configuration file - aborting!");
            }
            WSDDDocument wSDDDocument = new WSDDDocument(XMLUtils.newDocument(this.myInputStream));
            this.deployment = wSDDDocument.getDeployment();
            this.deployment.configureEngine(axisEngine);
            axisEngine.refreshGlobalOptions();
            this.myInputStream = null;
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
    }

    public void writeEngineConfig(AxisEngine axisEngine) throws ConfigurationException {
        if (!this.readOnly) {
            try {
                Document document = Admin.listConfig(axisEngine);
                StringWriter stringWriter = new StringWriter();
                XMLUtils.DocumentToWriter(document, stringWriter);
                stringWriter.close();
                FileOutputStream fileOutputStream = new FileOutputStream(this.configFile);
                fileOutputStream.write(stringWriter.getBuffer().toString().getBytes());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
    }

    public Handler getHandler(QName qName) throws ConfigurationException {
        return this.deployment.getHandler(qName);
    }

    public SOAPService getService(QName qName) throws ConfigurationException {
        return this.deployment.getService(qName);
    }

    public SOAPService getServiceByNamespaceURI(String string) throws ConfigurationException {
        return this.deployment.getServiceByNamespaceURI(string);
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        return this.deployment.getTransport(qName);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        return this.deployment.getTypeMappingRegistry();
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        return this.deployment.getGlobalRequest();
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        return this.deployment.getGlobalResponse();
    }

    public Hashtable getGlobalOptions() throws ConfigurationException {
        WSDDGlobalConfiguration wSDDGlobalConfiguration = this.deployment.getGlobalConfiguration();
        if (wSDDGlobalConfiguration != null) {
            return wSDDGlobalConfiguration.getParametersTable();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

