/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.attachments.AttachmentUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MimeUtils {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$attachments$MimeUtils == null ? (class$org$apache$axis$attachments$MimeUtils = MimeUtils.class$("org.apache.axis.attachments.MimeUtils")) : class$org$apache$axis$attachments$MimeUtils).getName());
    public static String[] filter = new String[]{"Message-ID", "Mime-Version", "Content-Type"};
    static String thisHost = null;
    private static int count = (int)(Math.random() * 100.0);
    static /* synthetic */ Class class$org$apache$axis$attachments$MimeUtils;
    static /* synthetic */ Class class$org$apache$axis$Message;

    public static long getContentLength(Multipart multipart) throws MessagingException, IOException {
        String string;
        int n = multipart.getCount();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            string = (MimeBodyPart)multipart.getBodyPart(n2);
            l += MimeUtils.getContentLength((MimeBodyPart)string);
            ++n2;
        }
        string = multipart.getContentType();
        ContentType contentType = new ContentType(string);
        String string2 = contentType.getParameter("boundary");
        int n3 = string2.length() + 4;
        return l + (long)(n3 * (n + 1)) + (long)(2 * n) + 4L;
    }

    protected static long getContentLength(MimeBodyPart mimeBodyPart) {
        long l = -1L;
        long l2 = -1L;
        try {
            l = MimeUtils.getHeaderLength(mimeBodyPart);
            DataHandler dataHandler = mimeBodyPart.getDataHandler();
            DataSource dataSource = dataHandler.getDataSource();
            if (dataSource instanceof FileDataSource) {
                FileDataSource fileDataSource = (FileDataSource)dataSource;
                File file = fileDataSource.getFile();
                if (!file.exists()) {
                    throw new RuntimeException("File for dataHandler does not exist" + file.getAbsolutePath());
                }
                l2 = file.length();
            } else {
                l2 = mimeBodyPart.getSize();
                if (-1L == l2) {
                    int n;
                    l2 = 0L;
                    InputStream inputStream = dataSource.getInputStream();
                    byte[] byArray = new byte[65536];
                    do {
                        if ((n = inputStream.read(byArray)) <= 0) continue;
                        l2 += (long)n;
                    } while (n > -1);
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
        }
        return l2 + l;
    }

    private static long getHeaderLength(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        Object object;
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart(new InternetHeaders(), new byte[0]);
        Enumeration enumeration = mimeBodyPart.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            object = (Header)enumeration.nextElement();
            mimeBodyPart2.addHeader(object.getName(), object.getValue());
        }
        object = new ByteArrayOutputStream(16384);
        mimeBodyPart2.writeTo((OutputStream)object);
        ((ByteArrayOutputStream)object).close();
        return ((ByteArrayOutputStream)object).size();
    }

    public static void writeToMultiPartStream(OutputStream outputStream, MimeMultipart mimeMultipart) {
        try {
            Properties properties = System.getProperties();
            properties.put("mail.smtp.host", "localhost");
            Session session = Session.getInstance((Properties)properties, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setContent((Multipart)mimeMultipart);
            mimeMessage.saveChanges();
            mimeMessage.writeTo(outputStream, filter);
        }
        catch (MessagingException messagingException) {
            log.error((Object)JavaUtils.getMessage("javaxMailMessagingException00"), (Throwable)messagingException);
        }
        catch (IOException iOException) {
            log.error((Object)JavaUtils.getMessage("javaIOException00"), (Throwable)iOException);
        }
    }

    public static String getContentType(MimeMultipart mimeMultipart) {
        String string = mimeMultipart.getContentType();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || 0 >= string2.length()) continue;
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (c != ' ' && c != '\t') break;
                ++n;
            }
            if (n > 1) {
                string2 = string2.substring(n - 1);
            }
            if (string2.length() <= 0) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static MimeMultipart createMP(String string, Collection collection) throws AxisFault {
        MimeMultipart mimeMultipart = null;
        try {
            String string2 = MimeUtils.getNewContentIdValue();
            if (string2.startsWith("cid:")) {
                string2 = string2.substring(4);
            }
            mimeMultipart = new MimeMultipart("related; type=\"text/xml\"; start=\"<" + string2 + ">\"");
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(string);
            mimeBodyPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
            mimeBodyPart.setHeader("Content-ID", "<" + string2 + ">");
            mimeBodyPart.setHeader("Content-Transfer-Encoding", "binary");
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                DataHandler dataHandler = AttachmentUtils.getActiviationDataHandler(part);
                String string3 = part.getContentId();
                if (string3.startsWith("cid:")) {
                    string3 = string3.substring(4);
                }
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDataHandler(dataHandler);
                String string4 = dataHandler.getContentType();
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = "application/octet-stream";
                }
                mimeBodyPart.setHeader("Content-Type", string4);
                mimeBodyPart.setHeader("Content-ID", "<" + string3 + ">");
                mimeBodyPart.setHeader("Content-Transfer-Encoding", "binary");
                Iterator iterator2 = part.getNonMatchingMimeHeaders(new String[]{"Content-Type", "Content-ID", "Content-Transfer-Encoding"});
                while (iterator2.hasNext()) {
                    String string5 = (String)iterator2.next();
                    mimeBodyPart.setHeader(string5, part.getMimeHeader(string5));
                }
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
        }
        catch (MessagingException messagingException) {
            log.error((Object)JavaUtils.getMessage("javaxMailMessagingException00"), (Throwable)messagingException);
        }
        return mimeMultipart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNewContentIdValue() {
        int n;
        Class clazz = class$org$apache$axis$Message == null ? (class$org$apache$axis$Message = MimeUtils.class$("org.apache.axis.Message")) : class$org$apache$axis$Message;
        synchronized (clazz) {
            n = ++count;
        }
        if (null == thisHost) {
            try {
                thisHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                log.error((Object)JavaUtils.getMessage("javaNetUnknownHostException00"), (Throwable)unknownHostException);
                thisHost = "localhost";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cid:").append(n).append(stringBuffer.hashCode()).append('.').append(System.currentTimeMillis()).append(".AXIS@").append(thisHost);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

