/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BoundaryDelimitedStream
extends FilterInputStream {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$attachments$BoundaryDelimitedStream == null ? (class$org$apache$axis$attachments$BoundaryDelimitedStream = BoundaryDelimitedStream.class$("org.apache.axis.attachments.BoundaryDelimitedStream")) : class$org$apache$axis$attachments$BoundaryDelimitedStream).getName());
    protected byte[] boundary = null;
    int boundaryLen = 0;
    int boundaryBufLen = 0;
    InputStream is = null;
    boolean closed = true;
    boolean eos = false;
    boolean theEnd = false;
    int readbufsz = 0;
    byte[] readbuf = null;
    int readBufPos = 0;
    int readBufEnd = 0;
    protected static final int BOUNDARY_NOT_FOUND = Integer.MAX_VALUE;
    int boundaryPos = Integer.MAX_VALUE;
    static int streamCount = 0;
    protected int streamNo = -1;
    static boolean isDebugEnabled = false;
    private int[] skip = null;
    static /* synthetic */ Class class$org$apache$axis$attachments$BoundaryDelimitedStream;

    protected static synchronized int newStreamNo() {
        log.debug((Object)("New boundary stream no:" + (streamCount + 1)));
        return ++streamCount;
    }

    public synchronized BoundaryDelimitedStream getNextStream() {
        return this.getNextStream(this.readbufsz);
    }

    protected synchronized BoundaryDelimitedStream getNextStream(int n) {
        BoundaryDelimitedStream boundaryDelimitedStream = null;
        if (!this.theEnd) {
            boundaryDelimitedStream = new BoundaryDelimitedStream(this, n);
        }
        return boundaryDelimitedStream;
    }

    protected BoundaryDelimitedStream(BoundaryDelimitedStream boundaryDelimitedStream, int n) {
        super(boundaryDelimitedStream.is);
        this.streamNo = BoundaryDelimitedStream.newStreamNo();
        this.boundary = boundaryDelimitedStream.boundary;
        this.boundaryLen = boundaryDelimitedStream.boundaryLen;
        this.boundaryBufLen = boundaryDelimitedStream.boundaryBufLen;
        this.skip = boundaryDelimitedStream.skip;
        this.is = boundaryDelimitedStream.is;
        this.closed = false;
        this.eos = false;
        n = boundaryDelimitedStream.readbufsz;
        this.readbuf = boundaryDelimitedStream.readbuf;
        this.readBufPos = boundaryDelimitedStream.readBufPos + this.boundaryBufLen;
        this.readBufEnd = boundaryDelimitedStream.readBufEnd;
        this.boundaryPos = this.boundaryPosition(this.readbuf, this.readBufPos, this.readBufEnd - 1);
        boundaryDelimitedStream.theEnd = this.theEnd;
    }

    BoundaryDelimitedStream(InputStream inputStream, byte[] byArray, int n) throws AxisFault {
        super(inputStream);
        isDebugEnabled = log.isDebugEnabled();
        this.streamNo = BoundaryDelimitedStream.newStreamNo();
        this.closed = false;
        this.is = inputStream;
        this.boundary = byArray;
        this.boundaryLen = byArray.length;
        this.boundaryBufLen = this.boundaryLen + 2;
        this.readbufsz = Math.max(this.boundaryBufLen * 2, n);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
        if (this.eos) {
            return -1;
        }
        if (this.readbuf == null) {
            this.readbuf = new byte[Math.max(n2, this.readbufsz)];
            this.readBufEnd = this.is.read(this.readbuf);
            if (this.readBufEnd < 0) {
                throw new IOException("End of stream encountered before final boundary marker.");
            }
            this.readBufPos = 0;
            this.boundaryPos = this.boundaryPosition(this.readbuf, 0, this.readBufEnd);
        }
        int n3 = 0;
        do {
            int n4 = Math.min(this.readBufEnd - this.readBufPos - this.boundaryBufLen, n2 - n3);
            if ((n4 = Math.min(n4, this.boundaryPos - this.readBufPos)) > 0) {
                System.arraycopy(this.readbuf, this.readBufPos, byArray, n + n3, n4);
                n3 += n4;
                this.readBufPos += n4;
            }
            if (this.readBufPos == this.boundaryPos) {
                this.eos = true;
                log.debug((Object)("Boundary stream no:" + this.streamNo + " is at end of stream"));
                continue;
            }
            if (n3 >= n2) continue;
            byte[] byArray2 = this.readbuf;
            if (this.readbuf.length < n2) {
                byArray2 = new byte[n2];
            }
            int n5 = this.readBufEnd - this.readBufPos;
            System.arraycopy(this.readbuf, this.readBufPos, byArray2, 0, n5);
            int n6 = this.is.read(byArray2, n5, byArray2.length - n5);
            if (n6 < 0) {
                throw new IOException("End of stream encountered before final boundary marker.");
            }
            this.readBufEnd = n6 + n5;
            this.readbuf = byArray2;
            this.readBufPos = 0;
            if (Integer.MAX_VALUE != this.boundaryPos) {
                this.boundaryPos -= n5;
                continue;
            }
            this.boundaryPos = this.boundaryPosition(this.readbuf, this.readBufPos, this.readBufEnd - 1);
        } while (!this.eos && n3 < n2);
        if (log.isDebugEnabled() && n3 > 0) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n, byArray3, 0, n3);
            log.debug((Object)("Read " + n3 + " from BoundaryDelimitedStream:" + this.streamNo + "\"" + new String(byArray3) + "\""));
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n < 0) {
            return -1;
        }
        return byArray[0];
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        log.debug((Object)("Boundary stream no:" + this.streamNo + " is closed"));
        this.closed = true;
        if (!this.eos) {
            byte[] byArray = new byte[16384];
            int n = 0;
            while ((n = this.read(byArray)) > -1) {
            }
        }
    }

    int boundaryPosition(byte[] byArray, int n, int n2) {
        int n3 = this.boundarySearch(byArray, n, n2);
        if (Integer.MAX_VALUE != n3) {
            if (byArray[n3 + this.boundaryLen] == 45 && byArray[n3 + this.boundaryLen + 1] == 45) {
                this.theEnd = true;
            } else if (byArray[n3 + this.boundaryLen] != 13 || byArray[n3 + this.boundaryLen + 1] != 10) {
                n3 = Integer.MAX_VALUE;
            }
        }
        return n3;
    }

    private int boundarySearch(byte[] byArray, int n, int n2) {
        int n3;
        if (null == this.skip) {
            this.skip = new int[256];
            Arrays.fill(this.skip, this.boundaryLen);
            n3 = 0;
            while (n3 < this.boundaryLen - 1) {
                this.skip[this.boundary[n3]] = this.boundaryLen - n3 - 1;
                ++n3;
            }
        }
        n3 = n + this.boundaryLen - 1;
        while (n3 <= n2) {
            int n4 = this.boundaryLen - 1;
            int n5 = n3;
            while (n4 >= 0 && byArray[n5] == this.boundary[n4]) {
                --n5;
                --n4;
            }
            if (n4 == -1) {
                return n5 + 1;
            }
            n3 += this.skip[byArray[n3] & 0xFF];
        }
        return Integer.MAX_VALUE;
    }

    public static void printarry(byte[] byArray, int n, int n2) {
        if (log.isDebugEnabled()) {
            byte[] byArray2 = new byte[n2 - n];
            System.arraycopy(byArray, n, byArray2, 0, n2 - n);
            log.debug((Object)("\"" + new String(byArray2) + "\""));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

