/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Message {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$Message == null ? (class$org$apache$axis$Message = Message.class$("org.apache.axis.Message")) : class$org$apache$axis$Message).getName());
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    public static final String MIME_APPLICATION_DIME = "application/dime";
    public static final String DEFAULT_ATTACHMNET_IMPL = "org.apache.axis.attachments.AttachmentsImpl";
    private static String mAttachmentsImplClassName = "org.apache.axis.attachments.AttachmentsImpl";
    public static final String MIME_UNKNOWN = "  ";
    private String messageType;
    private SOAPPart mSOAPPart;
    private Attachments mAttachments = null;
    private MessageContext msgContext;
    private static Class attachImpl = null;
    private static boolean checkForAttchmentSupport = true;
    private static boolean attachmentSupportEnabled = false;
    static /* synthetic */ Class class$org$apache$axis$Message;

    public static String getAttachmentImplClassName() {
        return mAttachmentsImplClassName;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
    }

    public Message(Object object, boolean bl) {
        this(object, bl, null, null);
    }

    public Message(Object object, boolean bl, String string, String string2) {
        this.setup(object, bl, string, string2);
    }

    public Message(Object object) {
        this.setup(object, false, null, null);
    }

    public boolean isAttachmentSupportEnabled() {
        if (checkForAttchmentSupport) {
            checkForAttchmentSupport = false;
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                AxisEngine axisEngine;
                String string = DEFAULT_ATTACHMNET_IMPL;
                MessageContext messageContext = this.getMessageContext();
                if (null != messageContext && null != (axisEngine = messageContext.getAxisEngine())) {
                    string = (String)axisEngine.getOption("attachments.implementation");
                }
                if (null == string) {
                    string = DEFAULT_ATTACHMNET_IMPL;
                }
                clazz2 = Class.forName("javax.activation.DataHandler");
                clazz = Class.forName("javax.mail.internet.MimeMultipart");
                attachImpl = Class.forName(string);
                attachmentSupportEnabled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        log.debug((Object)("Attachment support is enabled" + attachmentSupportEnabled));
        return attachmentSupportEnabled;
    }

    private void setup(Object object, boolean bl, String string, String string2) {
        if (this.isAttachmentSupportEnabled()) {
            Constructor<?> constructor = attachImpl.getConstructors()[0];
            try {
                this.mAttachments = (Attachments)constructor.newInstance(object, string, string2);
                this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
            }
            catch (InvocationTargetException invocationTargetException) {
                log.fatal((Object)JavaUtils.getMessage("invocationTargetException00"), (Throwable)invocationTargetException);
                throw new RuntimeException(invocationTargetException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                log.fatal((Object)JavaUtils.getMessage("instantiationException00"), (Throwable)instantiationException);
                throw new RuntimeException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                log.fatal((Object)JavaUtils.getMessage("illegalAccessException00"), (Throwable)illegalAccessException);
                throw new RuntimeException(illegalAccessException.getMessage());
            }
        }
        if (null == this.mSOAPPart) {
            this.mSOAPPart = new SOAPPart(this, object, bl);
        } else {
            this.mSOAPPart.setMessage(this);
        }
        if (this.mAttachments != null) {
            this.mAttachments.setRootPart(this.mSOAPPart);
        }
    }

    public SOAPPart getSOAPPart() {
        return this.mSOAPPart;
    }

    public SOAPEnvelope getSOAPEnvelope() throws AxisFault {
        return this.mSOAPPart.getAsSOAPEnvelope();
    }

    public Attachments getAttachments() {
        return this.mAttachments;
    }

    public String getContentType() throws AxisFault {
        this.mSOAPPart.getAsBytes();
        String string = "text/xml; charset=utf-8";
        if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            string = this.mAttachments.getContentType();
        }
        return string;
    }

    public int getContentLength() throws AxisFault {
        int n = this.mSOAPPart.getAsBytes().length;
        if (this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount()) {
            n = this.mAttachments.getContentLength();
        }
        return n;
    }

    public void writeContentToStream(OutputStream outputStream) {
        if (this.mAttachments == null || 0 == this.mAttachments.getAttachmentCount()) {
            try {
                outputStream.write(this.mSOAPPart.getAsBytes());
            }
            catch (IOException iOException) {
                log.error((Object)JavaUtils.getMessage("javaIOException00"), (Throwable)iOException);
            }
        } else {
            try {
                this.mAttachments.writeContentToStream(outputStream);
            }
            catch (Exception exception) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

