/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.InternalException;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.session.Session;
import org.apache.axis.session.SimpleSession;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AxisEngine
extends BasicHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis$AxisEngine == null ? (class$org$apache$axis$AxisEngine = AxisEngine.class$("org.apache.axis.AxisEngine")) : class$org$apache$axis$AxisEngine).getName());
    public static final String PROP_XML_DECL = "sendXMLDeclaration";
    public static final String PROP_DEBUG_LEVEL = "debugLevel";
    public static final String PROP_DEBUG_FILE = "debugFile";
    public static final String PROP_DOMULTIREFS = "sendMultiRefs";
    public static final String PROP_PASSWORD = "adminPassword";
    public static final String PROP_SYNC_CONFIG = "syncConfiguration";
    public static final String PROP_SEND_XSI = "sendXsiTypes";
    public static final String PROP_ATTACHMENT_DIR = "attachments.Directory";
    public static final String PROP_ATTACHMENT_IMPLEMENTATION = "attachments.implementation";
    public static final String PROP_ATTACHMENT_CLEANUP = "attachment.DirectoryCleanUp";
    public static final String DEFAULT_ATTACHMENT_IMPL = "org.apache.axis.attachments.AttachmentsImpl";
    private static final String DEFAULT_ADMIN_PASSWORD = "admin";
    protected EngineConfiguration config;
    protected boolean _hasSafePassword = false;
    protected boolean shouldSaveConfig = false;
    protected ClassCache classCache = new ClassCache();
    private Session session = new SimpleSession();
    private ArrayList actorURIs = new ArrayList();
    private static ThreadLocal currentMessageContext = new ThreadLocal();
    private static final String[] BOOLEAN_OPTIONS = new String[]{"sendMultiRefs", "sendXsiTypes", "sendXMLDeclaration"};
    static /* synthetic */ Class class$org$apache$axis$AxisEngine;

    protected static void setCurrentMessageContext(MessageContext messageContext) {
        currentMessageContext.set(messageContext);
    }

    public static MessageContext getCurrentMessageContext() {
        return (MessageContext)currentMessageContext.get();
    }

    private AxisEngine() {
    }

    public AxisEngine(EngineConfiguration engineConfiguration) {
        this.config = engineConfiguration;
        this.init();
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "AxisEngine::init"));
        }
        try {
            this.config.configureEngine(this);
        }
        catch (Exception exception) {
            throw new InternalException(exception);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "AxisEngine::init"));
        }
        String string = null;
        try {
            string = System.getProperty("axis.attachments.implementation");
            if (null != string) {
                this.setOption(PROP_ATTACHMENT_IMPLEMENTATION, string);
            }
        }
        catch (Throwable throwable) {
            string = null;
        }
        if (string == null && (string = (String)this.getOption(PROP_ATTACHMENT_IMPLEMENTATION)) == null) {
            this.setOption(PROP_ATTACHMENT_IMPLEMENTATION, DEFAULT_ATTACHMENT_IMPL);
        }
    }

    public void saveConfiguration() {
        if (!this.shouldSaveConfig) {
            return;
        }
        try {
            this.config.writeEngineConfig(this);
        }
        catch (Exception exception) {
            log.error((Object)JavaUtils.getMessage("saveConfigFail00"), (Throwable)exception);
        }
    }

    public EngineConfiguration getConfig() {
        return this.config;
    }

    public boolean hasSafePassword() {
        return this._hasSafePassword;
    }

    public void setAdminPassword(String string) {
        this.setOption(PROP_PASSWORD, string);
        this._hasSafePassword = true;
        this.saveConfiguration();
    }

    public void setShouldSaveConfig(boolean bl) {
        this.shouldSaveConfig = bl;
    }

    public Handler getHandler(String string) throws AxisFault {
        try {
            return this.config.getHandler(new QName(null, string));
        }
        catch (ConfigurationException configurationException) {
            throw new AxisFault(configurationException);
        }
    }

    public SOAPService getService(String string) throws AxisFault {
        try {
            return this.config.getService(new QName(null, string));
        }
        catch (ConfigurationException configurationException) {
            throw new AxisFault(configurationException);
        }
    }

    public Handler getTransport(String string) throws AxisFault {
        try {
            return this.config.getTransport(new QName(null, string));
        }
        catch (ConfigurationException configurationException) {
            throw new AxisFault(configurationException);
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        TypeMappingRegistry typeMappingRegistry = null;
        try {
            typeMappingRegistry = this.config.getTypeMappingRegistry();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)JavaUtils.getMessage("axisConfigurationException00"), (Throwable)configurationException);
        }
        return typeMappingRegistry;
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        return this.config.getGlobalRequest();
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        return this.config.getGlobalResponse();
    }

    public ArrayList getActorURIs() {
        return this.actorURIs;
    }

    public void addActorURI(String string) {
        this.actorURIs.add(string);
    }

    public void removeActorURI(String string) {
        this.actorURIs.remove(string);
    }

    public abstract AxisEngine getClientEngine();

    /*
     * Exception decompiling
     */
    private void normaliseOptions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void refreshGlobalOptions() throws ConfigurationException {
        Hashtable hashtable = this.config.getGlobalOptions();
        if (hashtable != null) {
            this.setOptions(hashtable);
        }
        this.normaliseOptions();
    }

    public Session getApplicationSession() {
        return this.session;
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

