/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.hsqldb.Channel;
import org.hsqldb.Database;
import org.hsqldb.Result;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcDatabaseMetaData;
import org.hsqldb.jdbcPreparedStatement;
import org.hsqldb.jdbcResultSet;
import org.hsqldb.jdbcStatement;

public class jdbcConnection
implements Connection {
    private boolean bClosed;
    private boolean bAutoCommit;
    private String sDatabaseName;
    private static final int HTTP = 0;
    private static final int STANDALONE = 1;
    private static final int INTERNAL = 2;
    private static final int HSQL = 3;
    private int iType;
    private Database dDatabase;
    private Channel cChannel;
    Socket sSocket;
    DataOutputStream dOutput;
    DataInputStream dInput;
    public static final int DEFAULT_HSQL_PORT = 9001;
    private static Hashtable tDatabase = new Hashtable();
    private static Hashtable iUsageCount = new Hashtable();
    private String sConnect;
    private String sUser;
    private String sPassword;
    static final String ENCODING = "8859_1";

    public Statement createStatement() {
        if (this.bClosed) {
            return null;
        }
        return new jdbcStatement(this);
    }

    public PreparedStatement prepareStatement(String string) {
        if (this.bClosed) {
            return null;
        }
        return new jdbcPreparedStatement(this, string);
    }

    public CallableStatement prepareCall(String string) {
        if (this.bClosed) {
            return null;
        }
        return new jdbcPreparedStatement(this, string);
    }

    public String nativeSQL(String string) {
        if (string.indexOf(123) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        break;
                    }
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (c != '{') break;
                    cArray[n3] = 32;
                    bl = true;
                    String string2 = string.substring(n3 + 1).toUpperCase();
                    if (string2.startsWith("?=")) {
                        n3 += 2;
                    } else if (string2.startsWith("CALL")) {
                        n3 += 4;
                    } else if (string2.startsWith("ESCAPE")) {
                        n3 += 6;
                    }
                    n = 3;
                    break;
                }
                case 1: 
                case 5: {
                    if (c != '\'') break;
                    --n;
                    break;
                }
                case 2: 
                case 6: {
                    if (c != '\"') break;
                    n -= 2;
                    break;
                }
                case 3: {
                    if (c == ' ') {
                        n = 4;
                        break;
                    }
                    cArray[n3] = 32;
                    bl = true;
                    break;
                }
                case 4: {
                    if (c == '\'') {
                        n = 5;
                        break;
                    }
                    if (c == '\"') {
                        n = 6;
                        break;
                    }
                    if (c != '}') break;
                    cArray[n3] = 32;
                    bl = true;
                    n = 0;
                }
            }
            ++n3;
        }
        if (bl) {
            string = new String(cArray);
        }
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.bAutoCommit = bl;
        this.execute("SET AUTOCOMMIT " + (this.bAutoCommit ? "TRUE" : "FALSE"));
    }

    public boolean getAutoCommit() {
        return this.bAutoCommit;
    }

    public void commit() throws SQLException {
        this.execute("COMMIT");
    }

    public void rollback() throws SQLException {
        this.execute("ROLLBACK");
    }

    public void close() throws SQLException {
        if (this.bClosed) {
            return;
        }
        if (this.iType == 1 || this.iType == 2) {
            this.closeStandalone();
        } else {
            this.execute("DISCONNECT");
        }
        this.bClosed = true;
    }

    public boolean isClosed() {
        return this.bClosed;
    }

    public DatabaseMetaData getMetaData() {
        return new jdbcDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.execute("SET READONLY " + (bl ? "TRUE" : "FALSE"));
    }

    public boolean isReadOnly() throws SQLException {
        String string = "SELECT * FROM SYSTEM_CONNECTIONINFO WHERE KEY='READONLY'";
        jdbcResultSet jdbcResultSet2 = this.execute(string);
        jdbcResultSet2.next();
        return jdbcResultSet2.getString(2).equals("TRUE");
    }

    public void setCatalog(String string) {
    }

    public String getCatalog() {
        return null;
    }

    public void setTransactionIsolation(int n) {
    }

    public int getTransactionIsolation() {
        return 1;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement();
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string);
    }

    public Map getTypeMap() throws SQLException {
        return new HashMap(0);
    }

    public void setTypeMap(Map map) throws SQLException {
        throw Trace.error(19);
    }

    jdbcConnection(String string, String string2, String string3) throws SQLException {
        this.bAutoCommit = true;
        this.sDatabaseName = string;
        if (string.toUpperCase().startsWith("HTTP://")) {
            this.iType = 0;
            this.openHTTP(string2, string3);
        } else if (string.toUpperCase().startsWith("HSQL://")) {
            this.iType = 3;
            this.openHSQL(string2, string3);
        } else {
            this.iType = 1;
            this.openStandalone(string2, string3);
        }
    }

    jdbcConnection(Channel channel) throws SQLException {
        this.iType = 2;
        this.cChannel = channel;
        this.dDatabase = channel.getDatabase();
    }

    jdbcResultSet execute(String string) throws SQLException {
        Trace.check(!this.bClosed, 1);
        if (this.iType == 0) {
            return this.executeHTTP(string);
        }
        if (this.iType == 3) {
            return this.executeHSQL(string);
        }
        return this.executeStandalone(string);
    }

    boolean usesLocalFiles() {
        return this.iType != 0;
    }

    String getName() {
        return this.sDatabaseName;
    }

    private void openHTTP(String string, String string2) throws SQLException {
        this.sConnect = this.sDatabaseName;
        this.sUser = string;
        this.sPassword = string2;
        this.executeHTTP(" ");
    }

    private synchronized jdbcResultSet executeHTTP(String string) throws SQLException {
        byte[] byArray;
        try {
            URL uRL = new URL(this.sConnect);
            String string2 = StringConverter.unicodeToHexString(this.sUser);
            string2 = string2 + "+" + StringConverter.unicodeToHexString(this.sPassword);
            string2 = string2 + "+" + StringConverter.unicodeToHexString(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            OutputStream outputStream = uRLConnection.getOutputStream();
            outputStream.write(string2.getBytes(ENCODING));
            outputStream.close();
            uRLConnection.connect();
            InputStream inputStream = (InputStream)uRLConnection.getContent();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n = uRLConnection.getContentLength();
            byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = bufferedInputStream.read();
                byArray[n2] = (byte)n3;
                ++n2;
            }
        }
        catch (Exception exception) {
            throw Trace.error(2, exception.getMessage());
        }
        return new jdbcResultSet(new Result(byArray));
    }

    private void openHSQL(String string, String string2) throws SQLException {
        this.sConnect = this.sDatabaseName.substring(7);
        this.sUser = string;
        this.sPassword = string2;
        this.reconnectHSQL();
        this.sUser = string;
        this.sPassword = string2;
        this.reconnectHSQL();
    }

    private void reconnectHSQL() throws SQLException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.sConnect, ":");
            String string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            int n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 9001;
            this.sSocket = new Socket(string, n);
            this.sSocket.setTcpNoDelay(true);
            this.dOutput = new DataOutputStream(new BufferedOutputStream(this.sSocket.getOutputStream()));
            this.dInput = new DataInputStream(new BufferedInputStream(this.sSocket.getInputStream()));
            this.dOutput.writeUTF(this.sUser);
            this.dOutput.writeUTF(this.sPassword);
            this.dOutput.flush();
        }
        catch (Exception exception) {
            throw Trace.error(2, exception.getMessage());
        }
    }

    private synchronized jdbcResultSet executeHSQL(String string) throws SQLException {
        byte[] byArray;
        try {
            int n;
            this.dOutput.writeUTF(string);
            this.dOutput.flush();
            int n2 = this.dInput.readInt();
            byArray = new byte[n2];
            int n3 = 0;
            while ((n = this.dInput.read(byArray, n3, n2)) != n2) {
                n2 -= n;
                n3 += n;
            }
        }
        catch (Exception exception) {
            throw Trace.error(2, exception.getMessage());
        }
        return new jdbcResultSet(new Result(byArray));
    }

    private synchronized void openStandalone(String string, String string2) throws SQLException {
        int n;
        this.dDatabase = (Database)tDatabase.get(this.sDatabaseName);
        if (this.dDatabase == null) {
            this.dDatabase = new Database(this.sDatabaseName);
            tDatabase.put(this.sDatabaseName, this.dDatabase);
            n = 1;
        } else {
            n = 1 + (Integer)iUsageCount.get(this.sDatabaseName);
        }
        iUsageCount.put(this.sDatabaseName, new Integer(n));
        this.cChannel = this.dDatabase.connect(string, string2);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private synchronized void closeStandalone() throws SQLException {
        Integer n = (Integer)iUsageCount.get(this.sDatabaseName);
        if (n == null) {
            return;
        }
        int n2 = n - 1;
        if (n2 == 0) {
            iUsageCount.remove(this.sDatabaseName);
            tDatabase.remove(this.sDatabaseName);
            if (!this.dDatabase.isShutdown()) {
                this.execute("SHUTDOWN");
            }
            this.dDatabase = null;
            this.cChannel = null;
        } else {
            iUsageCount.put(this.sDatabaseName, new Integer(n2));
            this.execute("DISCONNECT");
        }
    }

    private jdbcResultSet executeStandalone(String string) throws SQLException {
        return new jdbcResultSet(this.dDatabase.execute(string, this.cChannel));
    }
}

