/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public class DateTool {
    private static final Locale LOCALE_US = Locale.US;
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String asctimePattern = "EEE MMM d HH:mm:ss yyyy";
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final DateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", LOCALE_US);
    private static final DateFormat oldCookieFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", LOCALE_US);
    private static final DateFormat rfc1036Format = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", LOCALE_US);
    private static final DateFormat asctimeFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", LOCALE_US);
    private static StringManager sm;

    static long parseDate(MessageBytes value) {
        return DateTool.parseDate(value.toString());
    }

    public static String format1123(Date d) {
        return rfc1123Format.format(d);
    }

    public static void formatOldCookie(Date d, StringBuffer sb, FieldPosition fp) {
        oldCookieFormat.format(d, sb, fp);
    }

    public static String formatOldCookie(Date d) {
        return oldCookieFormat.format(d);
    }

    public static long parseDate(String dateString) {
        Date date = null;
        try {
            date = rfc1123Format.parse(dateString);
            return date.getTime();
        }
        catch (ParseException e) {
        }
        catch (StringIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            date = rfc1036Format.parse(dateString);
            return date.getTime();
        }
        catch (ParseException e) {
        }
        catch (StringIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            date = asctimeFormat.parse(dateString);
            return date.getTime();
        }
        catch (ParseException pe) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        String msg = sm.getString("httpDate.pe", dateString);
        throw new IllegalArgumentException(msg);
    }

    static {
        rfc1123Format.setTimeZone(GMT_ZONE);
        oldCookieFormat.setTimeZone(GMT_ZONE);
        rfc1036Format.setTimeZone(GMT_ZONE);
        asctimeFormat.setTimeZone(GMT_ZONE);
        sm = StringManager.getManager("org.apache.tomcat.util.buf.res");
    }
}

