/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.print;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.DefaultSVGContext;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.LengthKey;
import org.apache.batik.transcoder.keys.Rectangle2DKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PrintTranscoder
extends XMLAbstractTranscoder
implements Printable {
    public static final String KEY_AOI_STR = "aoi";
    public static final String KEY_HEIGHT_STR = "height";
    public static final String KEY_LANGUAGE_STR = "language";
    public static final String KEY_MARGIN_BOTTOM_STR = "marginBottom";
    public static final String KEY_MARGIN_LEFT_STR = "marginLeft";
    public static final String KEY_MARGIN_RIGHT_STR = "marginRight";
    public static final String KEY_MARGIN_TOP_STR = "marginTop";
    public static final String KEY_PAGE_HEIGHT_STR = "pageHeight";
    public static final String KEY_PAGE_ORIENTATION_STR = "pageOrientation";
    public static final String KEY_PAGE_WIDTH_STR = "pageWidth";
    public static final String KEY_PIXEL_TO_MM_STR = "pixelToMm";
    public static final String KEY_SCALE_TO_PAGE_STR = "scaleToPage";
    public static final String KEY_SHOW_PAGE_DIALOG_STR = "showPageDialog";
    public static final String KEY_SHOW_PRINTER_DIALOG_STR = "showPrinterDialog";
    public static final String KEY_USER_STYLESHEET_URI_STR = "userStylesheet";
    public static final String KEY_WIDTH_STR = "width";
    public static final String KEY_XML_PARSER_CLASSNAME_STR = "xmlParserClassName";
    public static final String VALUE_MEDIA_PRINT = "print";
    public static final String VALUE_PAGE_ORIENTATION_LANDSCAPE = "landscape";
    public static final String VALUE_PAGE_ORIENTATION_PORTRAIT = "portrait";
    public static final String VALUE_PAGE_ORIENTATION_REVERSE_LANDSCAPE = "reverseLandscape";
    private Vector inputs = new Vector();
    private Vector printedInputs = null;
    private GraphicsNode root;
    private int curIndex = -1;
    private Rectangle2D curAOI;
    private AffineTransform curTxf;
    private UserAgent userAgent = new PrintTranscoderUserAgent();
    public static final TranscodingHints.Key KEY_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_AOI = new Rectangle2DKey();
    public static final TranscodingHints.Key KEY_LANGUAGE = new StringKey();
    public static final TranscodingHints.Key KEY_MEDIA = new StringKey();
    public static final TranscodingHints.Key KEY_USER_STYLESHEET_URI = new StringKey();
    public static final TranscodingHints.Key KEY_PIXEL_TO_MM = new FloatKey();
    public static final TranscodingHints.Key KEY_SHOW_PAGE_DIALOG = new BooleanKey();
    public static final TranscodingHints.Key KEY_SHOW_PRINTER_DIALOG = new BooleanKey();
    protected static final Set FEATURES = new HashSet();
    public static final TranscodingHints.Key KEY_PAGE_WIDTH;
    public static final TranscodingHints.Key KEY_PAGE_HEIGHT;
    public static final TranscodingHints.Key KEY_MARGIN_TOP;
    public static final TranscodingHints.Key KEY_MARGIN_RIGHT;
    public static final TranscodingHints.Key KEY_MARGIN_BOTTOM;
    public static final TranscodingHints.Key KEY_MARGIN_LEFT;
    public static final TranscodingHints.Key KEY_PAGE_ORIENTATION;
    public static final TranscodingHints.Key KEY_SCALE_TO_PAGE;
    public static final String USAGE = "java org.apache.batik.transcoder.print.PrintTranscoder <svgFileToPrint>";

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        return new SAXSVGDocumentFactory(string);
    }

    public PrintTranscoder() {
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, "http://www.w3.org/2000/svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, "svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, ExtensibleSVGDOMImplementation.getDOMImplementation());
        this.hints.put(KEY_MEDIA, VALUE_MEDIA_PRINT);
    }

    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) {
        if (transcoderInput != null) {
            this.inputs.addElement(transcoderInput);
        }
    }

    public void print() throws PrinterException {
        Object object;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Object object2 = printerJob.defaultPage();
        Paper paper = ((PageFormat)object2).getPaper();
        Float f = (Float)this.hints.get(KEY_PAGE_WIDTH);
        Float f2 = (Float)this.hints.get(KEY_PAGE_HEIGHT);
        if (f != null) {
            paper.setSize(f.floatValue(), paper.getHeight());
        }
        if (f2 != null) {
            paper.setSize(paper.getWidth(), f2.floatValue());
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = (float)paper.getWidth();
        float f6 = (float)paper.getHeight();
        Float f7 = (Float)this.hints.get(KEY_MARGIN_LEFT);
        Float f8 = (Float)this.hints.get(KEY_MARGIN_TOP);
        Float f9 = (Float)this.hints.get(KEY_MARGIN_RIGHT);
        Float f10 = (Float)this.hints.get(KEY_MARGIN_BOTTOM);
        if (f7 != null) {
            f3 = f7.floatValue();
            f5 -= f7.floatValue();
        }
        if (f8 != null) {
            f4 = f8.floatValue();
            f6 -= f8.floatValue();
        }
        if (f9 != null) {
            f5 -= f9.floatValue();
        }
        if (f10 != null) {
            f6 -= f10.floatValue();
        }
        paper.setImageableArea(f3, f4, f5, f6);
        String string = (String)this.hints.get(KEY_PAGE_ORIENTATION);
        if (VALUE_PAGE_ORIENTATION_PORTRAIT.equalsIgnoreCase(string)) {
            ((PageFormat)object2).setOrientation(1);
        } else if (VALUE_PAGE_ORIENTATION_LANDSCAPE.equalsIgnoreCase(string)) {
            ((PageFormat)object2).setOrientation(0);
        } else if (VALUE_PAGE_ORIENTATION_REVERSE_LANDSCAPE.equalsIgnoreCase(string)) {
            ((PageFormat)object2).setOrientation(2);
        }
        ((PageFormat)object2).setPaper(paper);
        object2 = printerJob.validatePage((PageFormat)object2);
        Boolean bl = (Boolean)this.hints.get(KEY_SHOW_PAGE_DIALOG);
        if (bl != null && bl.booleanValue()) {
            object = printerJob.pageDialog((PageFormat)object2);
            if (object == object2) {
                return;
            }
            object2 = object;
        }
        if ((object = (Boolean)this.hints.get(KEY_SHOW_PRINTER_DIALOG)) != null && ((Boolean)object).booleanValue() && !printerJob.printDialog()) {
            return;
        }
        printerJob.setPrintable(this, (PageFormat)object2);
        printerJob.print();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            this.printedInputs = (Vector)this.inputs.clone();
        }
        if (n >= this.printedInputs.size()) {
            this.curIndex = -1;
            System.out.println("Done");
            return 1;
        }
        if (this.curIndex != n) {
            try {
                super.transcode((TranscoderInput)this.printedInputs.elementAt(n), null);
                this.curIndex = n;
            }
            catch (TranscoderException transcoderException) {
                this.drawError(graphics, transcoderException);
                return 0;
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, RenderingHintsKeyExt.VALUE_TRANSCODING_PRINTING);
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D = this.curAOI;
        double d = pageFormat.getImageableWidth() / rectangle2D.getWidth();
        double d2 = pageFormat.getImageableHeight() / rectangle2D.getHeight();
        double d3 = d < d2 ? d : d2;
        Boolean bl = (Boolean)this.hints.get(KEY_SCALE_TO_PAGE);
        if (bl != null && !bl.booleanValue()) {
            d3 = 1.0;
        }
        double d4 = (pageFormat.getImageableWidth() - rectangle2D.getWidth() * d3) / 2.0;
        double d5 = (pageFormat.getImageableHeight() - rectangle2D.getHeight() * d3) / 2.0;
        graphics2D.translate(pageFormat.getImageableX() + d4, pageFormat.getImageableY() + d5);
        graphics2D.scale(d3, d3);
        graphics2D.transform(this.curTxf);
        graphics2D.clip(this.curAOI);
        try {
            this.root.paint(graphics2D);
        }
        catch (Exception exception) {
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            this.drawError(graphics, exception);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        return 0;
    }

    private void drawError(Graphics graphics, Exception exception) {
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        AffineTransform affineTransform;
        float f;
        float f2;
        GraphicsNode graphicsNode;
        if (!(document instanceof SVGOMDocument)) {
            throw new TranscoderException("");
        }
        SVGDocument sVGDocument = (SVGDocument)document;
        SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
        DefaultSVGContext defaultSVGContext = new DefaultSVGContext();
        defaultSVGContext.setPixelToMM(this.userAgent.getPixelToMM());
        ((SVGOMDocument)document).setSVGContext(defaultSVGContext);
        GVTBuilder gVTBuilder = new GVTBuilder();
        BridgeContext bridgeContext = new BridgeContext(this.userAgent);
        try {
            graphicsNode = gVTBuilder.build(bridgeContext, sVGDocument);
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException(bridgeException);
        }
        float f3 = (float)bridgeContext.getDocumentSize().getWidth();
        float f4 = (float)bridgeContext.getDocumentSize().getHeight();
        bridgeContext = null;
        gVTBuilder = null;
        float f5 = -1.0f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            f5 = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        float f6 = -1.0f;
        if (this.hints.containsKey(KEY_HEIGHT)) {
            f6 = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        if (f5 > 0.0f && f6 > 0.0f) {
            f2 = f5;
            f = f6;
        } else if (f6 > 0.0f) {
            f2 = f3 * f6 / f4;
            f = f6;
        } else if (f5 > 0.0f) {
            f2 = f5;
            f = f4 * f5 / f3;
        } else {
            f2 = f3;
            f = f4;
        }
        String string2 = null;
        try {
            string2 = new URL(string).getRef();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            affineTransform = ViewBox.getViewTransform(string2, sVGSVGElement, f2, f);
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException(bridgeException);
        }
        if (affineTransform.isIdentity() && (f2 != f3 || f != f4)) {
            float f7 = Math.max(f3, f4);
            float f8 = Math.max(f2, f);
            float f9 = f8 / f7;
            affineTransform = AffineTransform.getScaleInstance(f9, f9);
        }
        if (this.hints.containsKey(KEY_AOI)) {
            Rectangle2D rectangle2D = (Rectangle2D)this.hints.get(KEY_AOI);
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
            AffineTransform affineTransform2 = new AffineTransform();
            double d = (double)f2 / rectangle2D.getWidth();
            double d2 = (double)f / rectangle2D.getHeight();
            affineTransform2.scale(d, d2);
            double d3 = -rectangle2D.getX();
            double d4 = -rectangle2D.getY();
            affineTransform2.translate(d3, d4);
            affineTransform.preConcatenate(affineTransform2);
            this.curAOI = rectangle2D;
        } else {
            this.curAOI = new Rectangle2D.Float(0.0f, 0.0f, f2, f);
        }
        this.curTxf = affineTransform;
        this.root = graphicsNode;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println(USAGE);
            System.exit(0);
        }
        PrintTranscoder printTranscoder = new PrintTranscoder();
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_LANGUAGE_STR, KEY_LANGUAGE);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_USER_STYLESHEET_URI_STR, KEY_USER_STYLESHEET_URI);
        PrintTranscoder.setTranscoderStringHint(printTranscoder, KEY_XML_PARSER_CLASSNAME_STR, XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
        PrintTranscoder.setTranscoderBooleanHint(printTranscoder, KEY_SCALE_TO_PAGE_STR, KEY_SCALE_TO_PAGE);
        PrintTranscoder.setTranscoderRectangleHint(printTranscoder, KEY_AOI_STR, KEY_AOI);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_WIDTH_STR, KEY_WIDTH);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_HEIGHT_STR, KEY_HEIGHT);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_PIXEL_TO_MM_STR, KEY_PIXEL_TO_MM);
        PrintTranscoder.setTranscoderStringHint(printTranscoder, KEY_PAGE_ORIENTATION_STR, KEY_PAGE_ORIENTATION);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_PAGE_WIDTH_STR, KEY_PAGE_WIDTH);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_PAGE_HEIGHT_STR, KEY_PAGE_HEIGHT);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_MARGIN_TOP_STR, KEY_MARGIN_TOP);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_MARGIN_RIGHT_STR, KEY_MARGIN_RIGHT);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_MARGIN_BOTTOM_STR, KEY_MARGIN_BOTTOM);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_MARGIN_LEFT_STR, KEY_MARGIN_LEFT);
        PrintTranscoder.setTranscoderBooleanHint(printTranscoder, KEY_SHOW_PAGE_DIALOG_STR, KEY_SHOW_PAGE_DIALOG);
        PrintTranscoder.setTranscoderBooleanHint(printTranscoder, KEY_SHOW_PRINTER_DIALOG_STR, KEY_SHOW_PRINTER_DIALOG);
        int n = 0;
        while (n < stringArray.length) {
            printTranscoder.transcode(new TranscoderInput(new File(stringArray[n]).toURL().toString()), null);
            ++n;
        }
        printTranscoder.print();
    }

    public static void setTranscoderFloatHint(Transcoder transcoder, String string, TranscodingHints.Key key) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                Float f = new Float(Float.parseFloat(string2));
                transcoder.addTranscodingHint(key, f);
            }
            catch (NumberFormatException numberFormatException) {
                PrintTranscoder.handleValueError(string, string2);
            }
        }
    }

    public static void setTranscoderRectangleHint(Transcoder transcoder, String string, TranscodingHints.Key key) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
            if (stringTokenizer.countTokens() != 4) {
                PrintTranscoder.handleValueError(string, string2);
            }
            try {
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                Rectangle2D.Float float_ = new Rectangle2D.Float(Float.parseFloat(string3), Float.parseFloat(string4), Float.parseFloat(string5), Float.parseFloat(string6));
                transcoder.addTranscodingHint(key, float_);
            }
            catch (NumberFormatException numberFormatException) {
                PrintTranscoder.handleValueError(string, string2);
            }
        }
    }

    public static void setTranscoderBooleanHint(Transcoder transcoder, String string, TranscodingHints.Key key) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            Boolean bl = new Boolean("true".equalsIgnoreCase(string2));
            transcoder.addTranscodingHint(key, bl);
        }
    }

    public static void setTranscoderStringHint(Transcoder transcoder, String string, TranscodingHints.Key key) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            transcoder.addTranscodingHint(key, string2);
        }
    }

    public static void handleValueError(String string, String string2) {
        System.err.println("Invalid " + string + " value : " + string2);
        System.exit(1);
    }

    static {
        FEATURES.add("org.w3c.svg");
        FEATURES.add("org.w3c.svg.lang");
        FEATURES.add("org.w3c.svg.static");
        KEY_PAGE_WIDTH = new LengthKey();
        KEY_PAGE_HEIGHT = new LengthKey();
        KEY_MARGIN_TOP = new LengthKey();
        KEY_MARGIN_RIGHT = new LengthKey();
        KEY_MARGIN_BOTTOM = new LengthKey();
        KEY_MARGIN_LEFT = new LengthKey();
        KEY_PAGE_ORIENTATION = new StringKey();
        KEY_SCALE_TO_PAGE = new BooleanKey();
    }

    protected class PrintTranscoderUserAgent
    implements UserAgent {
        protected Set extensions = new HashSet();

        protected PrintTranscoderUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return new Dimension(400, 400);
        }

        public void displayError(String string) {
            try {
                PrintTranscoder.this.handler.error(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception exception) {
            try {
                PrintTranscoder.this.handler.error(new TranscoderException(exception));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String string) {
            try {
                PrintTranscoder.this.handler.warning(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public float getPixelToMM() {
            if (PrintTranscoder.this.hints.containsKey(KEY_PIXEL_TO_MM)) {
                return ((Float)PrintTranscoder.this.hints.get(KEY_PIXEL_TO_MM)).floatValue();
            }
            return 0.26458332f;
        }

        public String getLanguages() {
            if (PrintTranscoder.this.hints.containsKey(KEY_LANGUAGE)) {
                return (String)PrintTranscoder.this.hints.get(KEY_LANGUAGE);
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            return (String)PrintTranscoder.this.hints.get(KEY_USER_STYLESHEET_URI);
        }

        public String getXMLParserClassName() {
            if (PrintTranscoder.this.hints.containsKey(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME)) {
                return (String)PrintTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            return (Boolean)PrintTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING);
        }

        public String getMedia() {
            return (String)PrintTranscoder.this.hints.get(KEY_MEDIA);
        }

        public EventDispatcher getEventDispatcher() {
            return null;
        }

        public void openLink(SVGAElement sVGAElement) {
        }

        public void setSVGCursor(Cursor cursor) {
        }

        public void runThread(Thread thread) {
        }

        public AffineTransform getTransform() {
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return new Point();
        }

        public boolean hasFeature(String string) {
            return FEATURES.contains(string);
        }

        public boolean supportExtension(String string) {
            return this.extensions.contains(string);
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
            Iterator iterator = bridgeExtension.getImplementedExtensions();
            while (iterator.hasNext()) {
                this.extensions.add(iterator.next());
            }
        }

        public void handleElement(Element element, Object object) {
        }
    }
}

