/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageEncoder;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;

public class TIFFTranscoder
extends ImageTranscoder {
    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if (outputStream == null) {
            throw new TranscoderException(Messages.formatMessage("tiff.badoutput", null));
        }
        TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        int n4 = dataBufferInt.getOffset();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n5 = n4;
        int n6 = n3 - n;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n2) {
            int n13 = 0;
            while (n13 < n) {
                n11 = nArray[n5];
                n7 = n11 >> 24 & 0xFF;
                n8 = n11 >> 16 & 0xFF;
                n9 = n11 >> 8 & 0xFF;
                n10 = n11 & 0xFF;
                n8 = (255 * (255 - n7) + n7 * n8) / 255;
                n9 = (255 * (255 - n7) + n7 * n9) / 255;
                n10 = (255 * (255 - n7) + n7 * n10) / 255;
                nArray[n5++] = n7 << 24 & 0xFF000000 | n8 << 16 & 0xFF0000 | n9 << 8 & 0xFF00 | n10 & 0xFF;
                ++n13;
            }
            n5 += n6;
            ++n12;
        }
        try {
            TIFFImageEncoder tIFFImageEncoder = new TIFFImageEncoder(outputStream, tIFFEncodeParam);
            int n14 = singlePixelPackedSampleModel.getNumBands();
            int[] nArray2 = new int[n14];
            int n15 = 0;
            while (n15 < n14) {
                nArray2[n15] = n15;
                ++n15;
            }
            PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n, n2, n14, n * n14, nArray2);
            FormatRed formatRed = new FormatRed(GraphicsUtil.wrap(bufferedImage), pixelInterleavedSampleModel);
            tIFFImageEncoder.encode(formatRed);
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

