/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.apache.batik.svggen.SVGLine;
import org.w3c.dom.Element;

public class SVGRectangle
extends SVGGraphicObjectConverter {
    private SVGLine svgLine;

    public SVGRectangle(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
        this.svgLine = new SVGLine(sVGGeneratorContext);
    }

    public Element toSVG(Rectangle2D rectangle2D) {
        return this.toSVG((RectangularShape)rectangle2D);
    }

    public Element toSVG(RoundRectangle2D roundRectangle2D) {
        Element element = this.toSVG((RectangularShape)roundRectangle2D);
        if (element != null && element.getTagName() == "rect") {
            element.setAttributeNS(null, "rx", SVGGraphicObjectConverter.doubleString(Math.abs(roundRectangle2D.getArcWidth() / 2.0)));
            element.setAttributeNS(null, "ry", SVGGraphicObjectConverter.doubleString(Math.abs(roundRectangle2D.getArcHeight() / 2.0)));
        }
        return element;
    }

    private Element toSVG(RectangularShape rectangularShape) {
        if (rectangularShape.getWidth() > 0.0 && rectangularShape.getHeight() > 0.0) {
            Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "rect");
            element.setAttributeNS(null, "x", SVGGraphicObjectConverter.doubleString(rectangularShape.getX()));
            element.setAttributeNS(null, "y", SVGGraphicObjectConverter.doubleString(rectangularShape.getY()));
            element.setAttributeNS(null, "width", SVGGraphicObjectConverter.doubleString(rectangularShape.getWidth()));
            element.setAttributeNS(null, "height", SVGGraphicObjectConverter.doubleString(rectangularShape.getHeight()));
            return element;
        }
        if (rectangularShape.getWidth() == 0.0 && rectangularShape.getHeight() > 0.0) {
            Line2D.Double double_ = new Line2D.Double(rectangularShape.getX(), rectangularShape.getY(), rectangularShape.getX(), rectangularShape.getY() + rectangularShape.getHeight());
            return this.svgLine.toSVG(double_);
        }
        if (rectangularShape.getWidth() > 0.0 && rectangularShape.getHeight() == 0.0) {
            Line2D.Double double_ = new Line2D.Double(rectangularShape.getX(), rectangularShape.getY(), rectangularShape.getX() + rectangularShape.getWidth(), rectangularShape.getY());
            return this.svgLine.toSVG(double_);
        }
        return null;
    }
}

