/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGPaintDescriptor;

public class SVGColor
extends AbstractSVGConverter {
    public static final Color aqua = new Color(0, 255, 255);
    public static final Color black = Color.black;
    public static final Color blue = Color.blue;
    public static final Color fuchsia = new Color(255, 0, 255);
    public static final Color gray = new Color(128, 128, 128);
    public static final Color green = new Color(0, 128, 0);
    public static final Color lime = new Color(0, 255, 0);
    public static final Color maroon = new Color(128, 0, 0);
    public static final Color navy = new Color(0, 0, 128);
    public static final Color olive = new Color(128, 128, 0);
    public static final Color purple = new Color(128, 0, 128);
    public static final Color red = new Color(255, 0, 0);
    public static final Color silver = new Color(192, 192, 192);
    public static final Color teal = new Color(0, 128, 128);
    public static final Color white = Color.white;
    public static final Color yellow = Color.yellow;
    private static Map colorMap = new HashMap();

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Paint paint = graphicContext.getPaint();
        return SVGColor.toSVG((Color)paint);
    }

    public static SVGPaintDescriptor toSVG(Color color) {
        String string = (String)colorMap.get(color);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer("rgb(");
            stringBuffer.append(color.getRed());
            stringBuffer.append(",");
            stringBuffer.append(color.getGreen());
            stringBuffer.append(",");
            stringBuffer.append(color.getBlue());
            stringBuffer.append(")");
            string = stringBuffer.toString();
        }
        int n = color.getAlpha();
        float f = (float)color.getAlpha() / 255.0f;
        String string2 = AbstractSVGConverter.doubleString(f);
        return new SVGPaintDescriptor(string, string2);
    }

    static {
        colorMap.put(black, "black");
        colorMap.put(silver, "silver");
        colorMap.put(gray, "gray");
        colorMap.put(white, "white");
        colorMap.put(maroon, "maroon");
        colorMap.put(red, "red");
        colorMap.put(purple, "purple");
        colorMap.put(fuchsia, "fuchsia");
        colorMap.put(green, "green");
        colorMap.put(lime, "lime");
        colorMap.put(olive, "olive");
        colorMap.put(yellow, "yellow");
        colorMap.put(navy, "navy");
        colorMap.put(blue, "blue");
        colorMap.put(teal, "teal");
        colorMap.put(aqua, "aqua");
    }
}

