/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.DefaultCachedImageHandler;
import org.apache.batik.svggen.ImageCacher;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.util.Base64EncoderStream;
import org.w3c.dom.Element;

public class CachedImageHandlerBase64Encoder
extends DefaultCachedImageHandler {
    public CachedImageHandlerBase64Encoder() {
        this.setImageCacher(new ImageCacher.Embedded());
    }

    public Element createElement(SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "use");
        return element;
    }

    public String getRefPrefix() {
        return "";
    }

    protected AffineTransform handleTransform(Element element, double d, double d2, double d3, double d4, double d5, double d6) {
        AffineTransform affineTransform = null;
        double d7 = d5 / d3;
        double d8 = d6 / d4;
        if (d7 != 1.0 || d8 != 1.0) {
            affineTransform = AffineTransform.getScaleInstance(d7, d8);
        }
        element.setAttributeNS(null, "x", AbstractSVGConverter.doubleString(d));
        element.setAttributeNS(null, "y", AbstractSVGConverter.doubleString(d2));
        return affineTransform;
    }

    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        Base64EncoderStream base64EncoderStream = new Base64EncoderStream(outputStream);
        PNGImageEncoder pNGImageEncoder = new PNGImageEncoder((OutputStream)base64EncoderStream, null);
        pNGImageEncoder.encode(bufferedImage);
        base64EncoderStream.close();
    }

    public int getBufferedImageType() {
        return 2;
    }
}

