/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;

public class Glyph {
    private String unicode;
    private Vector names;
    private String orientation;
    private String arabicForm;
    private String lang;
    private Point2D horizOrigin;
    private Point2D vertOrigin;
    private float horizAdvX;
    private float vertAdvY;
    private int glyphCode;
    private AffineTransform transform;
    private Point2D position;
    private GVTGlyphMetrics metrics;
    private float kernScale;
    private Shape outline;
    private Paint fillPaint;
    private Paint strokePaint;
    private Stroke stroke;
    private Shape dShape;
    private GraphicsNode glyphChildrenNode;

    public Glyph(String string, Vector vector, String string2, String string3, String string4, Point2D point2D, Point2D point2D2, float f, float f2, int n, float f3, Paint paint, Paint paint2, Stroke stroke, Shape shape, GraphicsNode graphicsNode) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (point2D == null) {
            throw new IllegalArgumentException();
        }
        if (point2D2 == null) {
            throw new IllegalArgumentException();
        }
        this.unicode = string;
        this.names = vector;
        this.orientation = string2;
        this.arabicForm = string3;
        this.lang = string4;
        this.horizOrigin = point2D;
        this.vertOrigin = point2D2;
        this.horizAdvX = f;
        this.vertAdvY = f2;
        if (this.unicode != null && this.unicode.length() > 0 && ArabicTextHandler.arabicCharTransparent(this.unicode.charAt(0))) {
            this.horizAdvX = 0.0f;
            this.vertAdvY = 0.0f;
        }
        this.kernScale = f3;
        this.glyphCode = n;
        this.position = new Point2D.Float(0.0f, 0.0f);
        this.outline = null;
        this.fillPaint = paint;
        this.strokePaint = paint2;
        this.stroke = stroke;
        this.dShape = shape;
        this.glyphChildrenNode = graphicsNode;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public Vector getNames() {
        return this.names;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public String getArabicForm() {
        return this.arabicForm;
    }

    public String getLang() {
        return this.lang;
    }

    public Point2D getHorizOrigin() {
        return this.horizOrigin;
    }

    public Point2D getVertOrigin() {
        return this.vertOrigin;
    }

    public float getHorizAdvX() {
        return this.horizAdvX;
    }

    public float getVertAdvY() {
        return this.vertAdvY;
    }

    public int getGlyphCode() {
        return this.glyphCode;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
        this.outline = null;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(Point2D point2D) {
        this.position = point2D;
        this.outline = null;
    }

    public GVTGlyphMetrics getGlyphMetrics() {
        if (this.metrics == null) {
            this.metrics = new GVTGlyphMetrics(this.getHorizAdvX(), this.getVertAdvY(), this.getBounds(), 3);
        }
        return this.metrics;
    }

    public GVTGlyphMetrics getGlyphMetrics(float f, float f2) {
        return new GVTGlyphMetrics(this.getHorizAdvX() - f * this.kernScale, this.getVertAdvY() - f2 * this.kernScale, this.getBounds(), 3);
    }

    public Rectangle2D getBounds() {
        if (this.dShape != null && this.glyphChildrenNode == null) {
            return this.dShape.getBounds2D();
        }
        if (this.glyphChildrenNode != null && this.dShape == null) {
            return this.glyphChildrenNode.getOutline().getBounds2D();
        }
        if (this.dShape != null && this.glyphChildrenNode != null) {
            Rectangle2D rectangle2D = this.dShape.getBounds2D();
            Rectangle2D rectangle2D2 = this.glyphChildrenNode.getOutline().getBounds2D();
            return rectangle2D.createUnion(rectangle2D2);
        }
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public Shape getOutline() {
        if (this.outline == null) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.position.getX(), this.position.getY());
            if (this.transform != null) {
                affineTransform.concatenate(this.transform);
            }
            Shape shape = null;
            if (this.glyphChildrenNode != null) {
                shape = this.glyphChildrenNode.getOutline();
            }
            GeneralPath generalPath = null;
            if (this.dShape != null && shape != null) {
                generalPath = new GeneralPath(this.dShape);
                generalPath.append(shape, false);
            } else {
                generalPath = this.dShape != null && shape == null ? new GeneralPath(this.dShape) : (this.dShape == null && shape != null ? new GeneralPath(shape) : new GeneralPath());
            }
            this.outline = affineTransform.createTransformedShape(generalPath);
        }
        return this.outline;
    }

    public void draw(Graphics2D graphics2D) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.position.getX(), this.position.getY());
        if (this.transform != null) {
            affineTransform.concatenate(this.transform);
        }
        if (this.dShape != null) {
            Shape shape = affineTransform.createTransformedShape(this.dShape);
            if (this.fillPaint != null) {
                graphics2D.setPaint(this.fillPaint);
                graphics2D.fill(shape);
            }
            if (this.stroke != null && this.strokePaint != null) {
                graphics2D.setStroke(this.stroke);
                graphics2D.setPaint(this.strokePaint);
                graphics2D.draw(shape);
            }
        }
        if (this.glyphChildrenNode != null) {
            this.glyphChildrenNode.setTransform(affineTransform);
            this.glyphChildrenNode.paint(graphics2D);
        }
    }
}

