/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.event;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeFocusListener;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;

public class AWTEventDispatcher
implements EventDispatcher,
MouseListener,
MouseMotionListener,
KeyListener {
    protected GraphicsNode root;
    protected AffineTransform baseTransform;
    protected EventListenerList glisteners;
    protected GraphicsNode lastHit;
    protected GraphicsNode dummyNode = new TextNode();
    protected GraphicsNode currentKeyEventTarget;
    private int nodeIncrementEventID = 401;
    private int nodeIncrementEventCode = 9;
    private int nodeIncrementEventModifiers = 0;
    private int nodeDecrementEventID = 401;
    private int nodeDecrementEventCode = 9;
    private int nodeDecrementEventModifiers = 1;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeMouseListener;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeKeyListener;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeFocusListener;

    public void setRootNode(GraphicsNode graphicsNode) {
        this.root = graphicsNode;
    }

    public GraphicsNode getRootNode() {
        return this.root;
    }

    public void setBaseTransform(AffineTransform affineTransform) {
        this.baseTransform = affineTransform;
    }

    public AffineTransform getBaseTransform() {
        return new AffineTransform(this.baseTransform);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void addGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, graphicsNodeMouseListener);
    }

    public void removeGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, graphicsNodeMouseListener);
        }
    }

    public void addGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, graphicsNodeKeyListener);
    }

    public void removeGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, graphicsNodeKeyListener);
        }
    }

    public void addGraphicsNodeFocusListener(GraphicsNodeFocusListener graphicsNodeFocusListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeFocusListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeFocusListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeFocusListener")) : class$org$apache$batik$gvt$event$GraphicsNodeFocusListener, graphicsNodeFocusListener);
    }

    public void removeGraphicsNodeFocusListener(GraphicsNodeFocusListener graphicsNodeFocusListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeFocusListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeFocusListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeFocusListener")) : class$org$apache$batik$gvt$event$GraphicsNodeFocusListener, graphicsNodeFocusListener);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        Object object = Array.newInstance(clazz, this.glisteners.getListenerCount(clazz));
        Object[] objectArray = this.glisteners.getListenerList();
        int n = 0;
        int n2 = 0;
        while (n < objectArray.length - 1) {
            if (objectArray[n].equals(clazz)) {
                Array.set(object, n2, objectArray[n + 1]);
                ++n2;
            }
            n += 2;
        }
        return (EventListener[])object;
    }

    public void dispatchEvent(EventObject eventObject) {
        if (this.root == null) {
            return;
        }
        if (eventObject instanceof MouseEvent) {
            this.dispatchMouseEvent((MouseEvent)eventObject);
        } else if (eventObject instanceof KeyEvent) {
            InputEvent inputEvent = (InputEvent)eventObject;
            if (this.isNodeIncrementEvent(inputEvent)) {
                this.incrementKeyTarget();
            } else if (this.isNodeDecrementEvent(inputEvent)) {
                this.decrementKeyTarget();
            } else {
                this.dispatchKeyEvent((KeyEvent)eventObject);
            }
        }
    }

    protected void dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.currentKeyEventTarget != null) {
            this.currentKeyEventTarget.processKeyEvent(new GraphicsNodeKeyEvent(this.currentKeyEventTarget, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
        }
    }

    protected void dispatchMouseEvent(MouseEvent mouseEvent) {
        GraphicsNodeMouseEvent graphicsNodeMouseEvent;
        Point2D point2D = new Point2D.Float(mouseEvent.getX(), mouseEvent.getY());
        if (this.baseTransform != null) {
            point2D = this.baseTransform.transform(point2D, null);
        }
        GraphicsNode graphicsNode = this.root.nodeHitAt(point2D);
        GraphicsNode graphicsNode2 = null;
        if (this.isModalEvent(mouseEvent, graphicsNode) && this.lastHit != null) {
            graphicsNode2 = graphicsNode;
            graphicsNode = this.lastHit;
        }
        if (this.lastHit != graphicsNode) {
            if (this.lastHit != null) {
                graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(this.lastHit, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), (float)point2D.getX(), (float)point2D.getY(), mouseEvent.getClickCount(), graphicsNode);
                this.processMouseEvent(graphicsNodeMouseEvent);
                this.lastHit.processMouseEvent(graphicsNodeMouseEvent);
            }
            if (graphicsNode != null) {
                graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(graphicsNode, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), (float)point2D.getX(), (float)point2D.getY(), mouseEvent.getClickCount(), this.lastHit);
                this.processMouseEvent(graphicsNodeMouseEvent);
                graphicsNode.processMouseEvent(graphicsNodeMouseEvent);
            }
        }
        if (graphicsNode != null) {
            graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(graphicsNode, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (float)point2D.getX(), (float)point2D.getY(), mouseEvent.getClickCount(), graphicsNode2);
            graphicsNode.processMouseEvent(graphicsNodeMouseEvent);
            this.processMouseEvent(graphicsNodeMouseEvent);
        } else if (graphicsNode == null && mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 1) {
            graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(this.dummyNode, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (float)point2D.getX(), (float)point2D.getY(), mouseEvent.getClickCount(), graphicsNode2);
            this.processMouseEvent(graphicsNodeMouseEvent);
        }
        this.lastHit = graphicsNode;
    }

    protected boolean isModalEvent(MouseEvent mouseEvent, GraphicsNode graphicsNode) {
        int n = mouseEvent.getID();
        return n == 502 || n != 501 && (mouseEvent.getModifiers() & 0x10) != 0;
    }

    protected void processMouseEvent(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        if (this.glisteners != null) {
            GraphicsNodeMouseListener[] graphicsNodeMouseListenerArray = (GraphicsNodeMouseListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener);
            switch (graphicsNodeMouseEvent.getID()) {
                case 503: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseMoved(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 506: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseDragged(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 504: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseEntered(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 505: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseExited(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 500: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseClicked(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 501: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mousePressed(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 502: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseReleased(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new Error("Unknown Mouse Event type: " + graphicsNodeMouseEvent.getID());
                }
            }
        }
    }

    private void incrementKeyTarget() {
        throw new Error("Increment not implemented.");
    }

    private void decrementKeyTarget() {
        throw new Error("Decrement not implemented.");
    }

    public void setNodeIncrementEvent(InputEvent inputEvent) {
        this.nodeIncrementEventID = inputEvent.getID();
        if (inputEvent instanceof KeyEvent) {
            this.nodeIncrementEventCode = ((KeyEvent)inputEvent).getKeyCode();
        }
        this.nodeIncrementEventModifiers = inputEvent.getModifiers();
    }

    public void setNodeDecrementEvent(InputEvent inputEvent) {
        this.nodeDecrementEventID = inputEvent.getID();
        if (inputEvent instanceof KeyEvent) {
            this.nodeDecrementEventCode = ((KeyEvent)inputEvent).getKeyCode();
        }
        this.nodeDecrementEventModifiers = inputEvent.getModifiers();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isNodeIncrementEvent(InputEvent inputEvent) {
        boolean bl;
        if (inputEvent.getID() != this.nodeIncrementEventID) return false;
        if (inputEvent instanceof KeyEvent) {
            if (((KeyEvent)inputEvent).getKeyCode() != this.nodeIncrementEventCode) return false;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        if ((inputEvent.getModifiers() & this.nodeIncrementEventModifiers) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isNodeDecrementEvent(InputEvent inputEvent) {
        boolean bl;
        if (inputEvent.getID() != this.nodeDecrementEventID) return false;
        if (inputEvent instanceof KeyEvent) {
            if (((KeyEvent)inputEvent).getKeyCode() != this.nodeDecrementEventCode) return false;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        if ((inputEvent.getModifiers() & this.nodeDecrementEventModifiers) == 0) return false;
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

