/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.AbstractGraphicsNode;

public class RasterImageNode
extends AbstractGraphicsNode {
    protected Filter image;
    protected Rectangle2D imageBounds;
    protected AffineTransform img2usr;
    protected AffineTransform usr2img;
    protected boolean calcAffine = true;

    public void setImage(Filter filter) {
        this.invalidateGeometryCache();
        this.image = filter;
        this.calcAffine = true;
    }

    public Filter getImage() {
        return this.image;
    }

    public void setImageBounds(Rectangle2D rectangle2D) {
        this.invalidateGeometryCache();
        this.imageBounds = rectangle2D;
        this.calcAffine = true;
    }

    public Rectangle2D getImageBounds() {
        return (Rectangle2D)this.imageBounds.clone();
    }

    protected void updateAffine() {
        float f = this.image.getMinX();
        float f2 = this.image.getMinY();
        float f3 = (float)(this.imageBounds.getWidth() / (double)this.image.getWidth());
        float f4 = (float)(this.imageBounds.getHeight() / (double)this.image.getHeight());
        float f5 = (float)this.imageBounds.getX();
        float f6 = (float)this.imageBounds.getY();
        this.img2usr = AffineTransform.getTranslateInstance(f5, f6);
        this.img2usr.concatenate(AffineTransform.getScaleInstance(f3, f4));
        this.img2usr.concatenate(AffineTransform.getTranslateInstance(-f, -f2));
        this.usr2img = AffineTransform.getTranslateInstance(f, f2);
        this.usr2img.concatenate(AffineTransform.getScaleInstance(1.0f / f3, 1.0f / f4));
        this.usr2img.concatenate(AffineTransform.getTranslateInstance(-f5, -f6));
        this.calcAffine = false;
    }

    public void primitivePaint(Graphics2D graphics2D) {
        if (this.image == null || this.imageBounds.getWidth() == 0.0 || this.imageBounds.getHeight() == 0.0) {
            return;
        }
        if (this.calcAffine) {
            this.updateAffine();
        }
        GraphicsUtil.drawImage(graphics2D, this.image);
    }

    public Rectangle2D getPrimitiveBounds() {
        return (Rectangle2D)this.imageBounds.clone();
    }

    public Rectangle2D getGeometryBounds() {
        return (Rectangle2D)this.imageBounds.clone();
    }

    public Shape getOutline() {
        return (Rectangle2D)this.imageBounds.clone();
    }
}

