/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.dom.AttrWrapper;
import org.apache.batik.dom.CDATASectionWrapper;
import org.apache.batik.dom.CommentWrapper;
import org.apache.batik.dom.DOMImplementationWrapper;
import org.apache.batik.dom.DocumentFragmentWrapper;
import org.apache.batik.dom.DocumentWrapper;
import org.apache.batik.dom.ElementWrapper;
import org.apache.batik.dom.EntityReferenceWrapper;
import org.apache.batik.dom.NamedNodeMapWrapper;
import org.apache.batik.dom.NodeListWrapper;
import org.apache.batik.dom.NodeWrapper;
import org.apache.batik.dom.ProcessingInstructionWrapper;
import org.apache.batik.dom.TextWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;

public class DocumentWrapper
extends NodeWrapper
implements Document,
DocumentEvent {
    protected Map nodes = new HashMap(11);
    protected DOMImplementationWrapper domImplementationWrapper;

    public DocumentWrapper(DOMImplementationWrapper dOMImplementationWrapper, Document document) {
        super(null, document);
        this.domImplementationWrapper = dOMImplementationWrapper;
    }

    public void nodeWrapperFinalized(NodeWrapper nodeWrapper) {
        this.nodes.remove(nodeWrapper.getNode());
    }

    public DocumentType getDoctype() {
        throw new InternalError("!!! Not Implemented");
    }

    public DOMImplementation getImplementation() {
        return this.domImplementationWrapper;
    }

    public Element getDocumentElement() {
        class Query
        implements Runnable {
            Element result;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper) {
                this.this$0 = documentWrapper;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).getDocumentElement();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return this.createElementWrapper(query.result);
    }

    public Element createElement(String string) throws DOMException {
        class Query
        implements Runnable {
            Element result;
            private final /* synthetic */ String val$tagName;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$tagName = string;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createElement(this.val$tagName);
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        return this.createElementWrapper(query.result);
    }

    public DocumentFragment createDocumentFragment() {
        class Query
        implements Runnable {
            DocumentFragment result;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper) {
                this.this$0 = documentWrapper;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createDocumentFragment();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return this.createDocumentFragmentWrapper(query.result);
    }

    public Text createTextNode(String string) {
        class Query
        implements Runnable {
            Text result;
            private final /* synthetic */ String val$data;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$data = string;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createTextNode(this.val$data);
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        return this.createTextWrapper(query.result);
    }

    public Comment createComment(String string) {
        class Query
        implements Runnable {
            Comment result;
            private final /* synthetic */ String val$data;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$data = string;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createComment(this.val$data);
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        return this.createCommentWrapper(query.result);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        class Query
        implements Runnable {
            CDATASection result;
            private final /* synthetic */ String val$data;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$data = string;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createCDATASection(this.val$data);
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        return this.createCDATASectionWrapper(query.result);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        class Query
        implements Runnable {
            ProcessingInstruction result;
            private final /* synthetic */ String val$target;
            private final /* synthetic */ String val$data;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string, String string2) {
                this.this$0 = documentWrapper;
                this.val$target = string;
                this.val$data = string2;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createProcessingInstruction(this.val$target, this.val$data);
            }
        }
        Query query = new Query(this, string, string2);
        this.invokeAndWait(query);
        return this.createProcessingInstructionWrapper(query.result);
    }

    public Attr createAttribute(String string) throws DOMException {
        class Query
        implements Runnable {
            Attr result;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$name = string;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createAttribute(this.val$name);
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        return this.createAttrWrapper(query.result);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        class Query
        implements Runnable {
            EntityReference result;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$name = string;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createEntityReference(this.val$name);
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        return this.createEntityReferenceWrapper(query.result);
    }

    public NodeList getElementsByTagName(String string) {
        class Query
        implements Runnable {
            NodeList result;
            private final /* synthetic */ String val$tagname;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$tagname = string;
            }

            public void run() {
                this.result = ((Element)this.this$0.node).getElementsByTagName(this.val$tagname);
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        if (query.result == null) {
            return null;
        }
        return this.createNodeListWrapper(query.result);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        class Query
        implements Runnable {
            Node result;
            DOMException exception;
            private final /* synthetic */ Node val$importedNode;
            private final /* synthetic */ boolean val$deep;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, Node node, boolean bl) {
                this.this$0 = documentWrapper;
                this.val$importedNode = node;
                this.val$deep = bl;
            }

            public void run() {
                try {
                    this.result = ((Document)this.this$0.node).importNode(((NodeWrapper)this.val$importedNode).node, this.val$deep);
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Query query = new Query(this, node, bl);
        this.invokeAndWait(query);
        if (query.exception != null) {
            throw query.exception;
        }
        return this.createNodeWrapper(query.result);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        class Query
        implements Runnable {
            Element result;
            private final /* synthetic */ String val$namespaceURI;
            private final /* synthetic */ String val$qualifiedName;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string, String string2) {
                this.this$0 = documentWrapper;
                this.val$namespaceURI = string;
                this.val$qualifiedName = string2;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createElementNS(this.val$namespaceURI, this.val$qualifiedName);
            }
        }
        Query query = new Query(this, string, string2);
        this.invokeAndWait(query);
        return this.createElementWrapper(query.result);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        class Query
        implements Runnable {
            Attr result;
            private final /* synthetic */ String val$namespaceURI;
            private final /* synthetic */ String val$qualifiedName;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string, String string2) {
                this.this$0 = documentWrapper;
                this.val$namespaceURI = string;
                this.val$qualifiedName = string2;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).createAttributeNS(this.val$namespaceURI, this.val$qualifiedName);
            }
        }
        Query query = new Query(this, string, string2);
        this.invokeAndWait(query);
        return this.createAttrWrapper(query.result);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        class Query
        implements Runnable {
            NodeList result;
            private final /* synthetic */ String val$namespaceURI;
            private final /* synthetic */ String val$localName;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string, String string2) {
                this.this$0 = documentWrapper;
                this.val$namespaceURI = string;
                this.val$localName = string2;
            }

            public void run() {
                this.result = ((Element)this.this$0.node).getElementsByTagNameNS(this.val$namespaceURI, this.val$localName);
            }
        }
        Query query = new Query(this, string, string2);
        this.invokeAndWait(query);
        if (query.result == null) {
            return null;
        }
        return this.createNodeListWrapper(query.result);
    }

    public Element getElementById(String string) {
        class Query
        implements Runnable {
            Element result;
            private final /* synthetic */ String val$elementId;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$elementId = string;
            }

            public void run() {
                this.result = ((Document)this.this$0.node).getElementById(this.val$elementId);
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        return this.createElementWrapper(query.result);
    }

    public Event createEvent(String string) throws DOMException {
        class Query
        implements Runnable {
            Event result;
            DOMException exception;
            private final /* synthetic */ String val$eventType;
            private final /* synthetic */ DocumentWrapper this$0;

            Query(DocumentWrapper documentWrapper, String string) {
                this.this$0 = documentWrapper;
                this.val$eventType = string;
            }

            public void run() {
                try {
                    this.result = ((DocumentEvent)((Object)this.this$0.node)).createEvent(this.val$eventType);
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Query query = new Query(this, string);
        this.invokeAndWait(query);
        if (query.exception != null) {
            throw query.exception;
        }
        return this.domImplementationWrapper.createEventWrapper(this, query.result);
    }

    public Event createEventWrapper(Event event) {
        return this.domImplementationWrapper.createEventWrapper(this, event);
    }

    public void invokeAndWait(Runnable runnable) {
        this.domImplementationWrapper.invokeAndWait(runnable);
    }

    public void invokeLater(Runnable runnable) {
        this.domImplementationWrapper.invokeLater(runnable);
    }

    public Node createNodeWrapper(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 2: {
                return this.createAttrWrapper((Attr)node);
            }
            case 8: {
                return this.createCommentWrapper((Comment)node);
            }
            case 4: {
                return this.createCDATASectionWrapper((CDATASection)node);
            }
            case 1: {
                return this.createElementWrapper((Element)node);
            }
            case 5: {
                return this.createEntityReferenceWrapper((EntityReference)node);
            }
            case 11: {
                return this.createDocumentFragmentWrapper((DocumentFragment)node);
            }
            case 7: {
                return this.createProcessingInstructionWrapper((ProcessingInstruction)node);
            }
            case 3: {
                return this.createTextWrapper((Text)node);
            }
        }
        throw new InternalError("!!! To Be Implemented" + node.getNodeType());
    }

    protected Element createElementWrapper(Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = (Element)this.getNode(element);
        if (element2 == null) {
            element2 = new ElementWrapper(this, element);
            this.nodes.put(element, element2);
        }
        return element2;
    }

    protected Attr createAttrWrapper(Attr attr) {
        if (attr == null) {
            return null;
        }
        Attr attr2 = (Attr)this.getNode(attr);
        if (attr2 == null) {
            attr2 = new AttrWrapper(this, attr);
            this.nodes.put(attr, new WeakReference<Attr>(attr2));
        }
        return attr2;
    }

    protected CDATASection createCDATASectionWrapper(CDATASection cDATASection) {
        if (cDATASection == null) {
            return null;
        }
        CDATASection cDATASection2 = (CDATASection)this.getNode(cDATASection);
        if (cDATASection2 == null) {
            cDATASection2 = new CDATASectionWrapper(this, cDATASection);
            this.nodes.put(cDATASection, new WeakReference<CDATASection>(cDATASection2));
        }
        return cDATASection2;
    }

    protected Comment createCommentWrapper(Comment comment) {
        if (comment == null) {
            return null;
        }
        Comment comment2 = (Comment)this.getNode(comment);
        if (comment2 == null) {
            comment2 = new CommentWrapper(this, comment);
            this.nodes.put(comment, new WeakReference<Comment>(comment2));
        }
        return comment2;
    }

    protected EntityReference createEntityReferenceWrapper(EntityReference entityReference) {
        if (entityReference == null) {
            return null;
        }
        EntityReference entityReference2 = (EntityReference)this.getNode(entityReference);
        if (entityReference2 == null) {
            entityReference2 = new EntityReferenceWrapper(this, entityReference);
            this.nodes.put(entityReference, new WeakReference<EntityReference>(entityReference2));
        }
        return entityReference2;
    }

    protected Text createTextWrapper(Text text) {
        if (text == null) {
            return null;
        }
        Text text2 = (Text)this.getNode(text);
        if (text2 == null) {
            text2 = new TextWrapper(this, text);
            this.nodes.put(text, new WeakReference<Text>(text2));
        }
        return text2;
    }

    protected DocumentFragment createDocumentFragmentWrapper(DocumentFragment documentFragment) {
        if (documentFragment == null) {
            return null;
        }
        return new DocumentFragmentWrapper(this, documentFragment);
    }

    protected ProcessingInstruction createProcessingInstructionWrapper(ProcessingInstruction processingInstruction) {
        if (processingInstruction == null) {
            return null;
        }
        ProcessingInstruction processingInstruction2 = (ProcessingInstruction)this.getNode(processingInstruction);
        if (processingInstruction2 == null) {
            processingInstruction2 = new ProcessingInstructionWrapper(this, processingInstruction);
            this.nodes.put(processingInstruction, new WeakReference<ProcessingInstruction>(processingInstruction2));
        }
        return processingInstruction2;
    }

    protected NodeList createNodeListWrapper(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        return new NodeListWrapper(this, nodeList);
    }

    protected NamedNodeMap createNamedNodeMapWrapper(NamedNodeMap namedNodeMap) {
        return new NamedNodeMapWrapper(this, namedNodeMap);
    }

    protected Object getNode(Object object) {
        WeakReference weakReference = (WeakReference)this.nodes.get(object);
        if (weakReference == null) {
            return null;
        }
        return weakReference.get();
    }
}

