/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractText;
import org.apache.batik.dom.ExtendedNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.MutationEvent;

public abstract class AbstractParentNode
extends AbstractNode {
    protected ChildNodes childNodes;

    public NodeList getChildNodes() {
        return this.childNodes == null ? (this.childNodes = new ChildNodes()) : this.childNodes;
    }

    public Node getFirstChild() {
        return this.childNodes == null ? null : this.childNodes.firstChild;
    }

    public Node getLastChild() {
        return this.childNodes == null ? null : this.childNodes.lastChild;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (node2 != null && this.childNodes == null) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(node2.getNodeType()), node2.getNodeName()});
        }
        this.checkAndRemove(node);
        if (node.getNodeType() == 11) {
            Node node3 = node.getFirstChild();
            while (node3 != null) {
                Node node4 = node3.getNextSibling();
                this.insertBefore(node3, node2);
                node3 = node4;
            }
            return node;
        }
        if (this.childNodes == null) {
            this.childNodes = new ChildNodes();
        }
        ExtendedNode extendedNode = this.childNodes.insert((ExtendedNode)node, (ExtendedNode)node2);
        extendedNode.setParentNode(this);
        this.nodeAdded(extendedNode);
        this.fireDOMNodeInsertedEvent(extendedNode);
        this.fireDOMSubtreeModifiedEvent();
        return extendedNode;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.childNodes == null) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(node2.getNodeType()), node2.getNodeName()});
        }
        this.checkAndRemove(node);
        if (node.getNodeType() == 11) {
            Node node3 = node.getLastChild();
            Node node4 = node2.getNextSibling();
            if (node3 != null) {
                this.replaceChild(node3, node2);
                node3 = node3.getPreviousSibling();
            }
            while (node3 != null) {
                this.insertBefore(node3, node4);
                node3 = node3.getPreviousSibling();
            }
            return node;
        }
        this.fireDOMNodeRemovedEvent(node2);
        this.getCurrentDocument().nodeToBeRemoved(node2);
        this.nodeToBeRemoved(node2);
        ExtendedNode extendedNode = (ExtendedNode)node;
        ExtendedNode extendedNode2 = this.childNodes.replace(extendedNode, (ExtendedNode)node2);
        extendedNode.setParentNode(this);
        extendedNode2.setParentNode(null);
        this.nodeAdded(extendedNode);
        this.fireDOMNodeInsertedEvent(extendedNode);
        this.fireDOMSubtreeModifiedEvent();
        return extendedNode;
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.childNodes == null || node.getParentNode() != this) {
            throw this.createDOMException((short)8, "child.missing", new Object[]{new Integer(node.getNodeType()), node.getNodeName()});
        }
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        this.fireDOMNodeRemovedEvent(node);
        this.getCurrentDocument().nodeToBeRemoved(node);
        this.nodeToBeRemoved(node);
        ExtendedNode extendedNode = this.childNodes.remove((ExtendedNode)node);
        extendedNode.setParentNode(null);
        this.fireDOMSubtreeModifiedEvent();
        return extendedNode;
    }

    public Node appendChild(Node node) throws DOMException {
        this.checkAndRemove(node);
        if (node.getNodeType() == 11) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                Node node3 = node2.getNextSibling();
                this.appendChild(node2);
                node2 = node3;
            }
            return node;
        }
        if (this.childNodes == null) {
            this.childNodes = new ChildNodes();
        }
        ExtendedNode extendedNode = this.childNodes.append((ExtendedNode)node);
        extendedNode.setParentNode(this);
        this.nodeAdded(extendedNode);
        this.fireDOMNodeInsertedEvent(extendedNode);
        this.fireDOMSubtreeModifiedEvent();
        return extendedNode;
    }

    public boolean hasChildNodes() {
        return this.childNodes != null && this.childNodes.getLength() != 0;
    }

    public void normalize() {
        Node node = this.getFirstChild();
        if (node != null) {
            node.normalize();
            Node node2 = node.getNextSibling();
            while (node2 != null) {
                if (node.getNodeType() == 3 && node2.getNodeType() == 3) {
                    String string = node.getNodeValue() + node2.getNodeValue();
                    AbstractText abstractText = (AbstractText)node;
                    abstractText.setNodeValue(string);
                    this.removeChild(node2);
                    node2 = node.getNextSibling();
                    continue;
                }
                node2.normalize();
                node = node2;
                node2 = node2.getNextSibling();
            }
        }
    }

    public NodeList getElementsByTagName(String string) {
        if (string == null) {
            return AbstractNode.EMPTY_NODE_LIST;
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        ElementsByTagName elementsByTagName = abstractDocument.getElementsByTagName(this, null, string);
        if (elementsByTagName == null) {
            elementsByTagName = new ElementsByTagName(null, string);
            abstractDocument.putElementsByTagName(this, null, string, elementsByTagName);
        }
        return elementsByTagName;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        if (string2 == null) {
            return AbstractNode.EMPTY_NODE_LIST;
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        ElementsByTagName elementsByTagName = abstractDocument.getElementsByTagName(this, string, string2);
        if (elementsByTagName == null) {
            elementsByTagName = new ElementsByTagName(string, string2);
            abstractDocument.putElementsByTagName(this, string, string2, elementsByTagName);
        }
        return elementsByTagName;
    }

    public void fireDOMNodeInsertedIntoDocumentEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            super.fireDOMNodeInsertedIntoDocumentEvent();
            Node node = this.getFirstChild();
            while (node != null) {
                ((AbstractNode)node).fireDOMNodeInsertedIntoDocumentEvent();
                node = node.getNextSibling();
            }
        }
    }

    public void fireDOMNodeRemovedFromDocumentEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            super.fireDOMNodeRemovedFromDocumentEvent();
            Node node = this.getFirstChild();
            while (node != null) {
                ((AbstractNode)node).fireDOMNodeRemovedFromDocumentEvent();
                node = node.getNextSibling();
            }
        }
    }

    protected void nodeAdded(Node node) {
    }

    protected void nodeToBeRemoved(Node node) {
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        Node node2 = this.getFirstChild();
        while (node2 != null) {
            Node node3 = ((AbstractNode)node2).deepExport(node2.cloneNode(false), abstractDocument);
            node.appendChild(node3);
            node2 = node2.getNextSibling();
        }
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        Node node2 = this.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.cloneNode(true);
            node.appendChild(node3);
            node2 = node2.getNextSibling();
        }
        return node;
    }

    protected void fireDOMSubtreeModifiedEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            AbstractDocument abstractDocument2 = abstractDocument;
            MutationEvent mutationEvent = (MutationEvent)abstractDocument2.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)1);
            this.dispatchEvent(mutationEvent);
        }
    }

    protected void fireDOMNodeInsertedEvent(Node node) {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            AbstractDocument abstractDocument2 = abstractDocument;
            MutationEvent mutationEvent = (MutationEvent)abstractDocument2.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)2);
            AbstractNode abstractNode = (AbstractNode)node;
            abstractNode.dispatchEvent(mutationEvent);
            abstractNode.fireDOMNodeInsertedIntoDocumentEvent();
        }
    }

    protected void fireDOMNodeRemovedEvent(Node node) {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            AbstractDocument abstractDocument2 = abstractDocument;
            MutationEvent mutationEvent = (MutationEvent)abstractDocument2.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)3);
            AbstractNode abstractNode = (AbstractNode)node;
            abstractNode.dispatchEvent(mutationEvent);
            abstractNode.fireDOMNodeRemovedFromDocumentEvent();
        }
    }

    protected void checkAndRemove(Node node) {
        this.checkChildType(node);
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (node.getOwnerDocument() != this.getCurrentDocument()) {
            throw this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        Node node2 = this.getParentNode();
        while (node2 != null) {
            if (node2 == node) {
                throw this.createDOMException((short)4, "add.ancestor", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
            }
            node2 = node2.getParentNode();
        }
        Node node3 = node.getParentNode();
        if (node3 != null) {
            node3.removeChild(node);
        }
    }

    protected class ChildNodes
    implements NodeList,
    Serializable {
        protected ExtendedNode firstChild;
        protected ExtendedNode lastChild;
        protected int children;

        public Node item(int n) {
            if (n < 0 || n >= this.children) {
                return null;
            }
            if (n < this.children >> 1) {
                Node node = this.firstChild;
                int n2 = 0;
                while (n2 < n) {
                    node = node.getNextSibling();
                    ++n2;
                }
                return node;
            }
            Node node = this.lastChild;
            int n3 = this.children - 1;
            while (n3 > n) {
                node = node.getPreviousSibling();
                --n3;
            }
            return node;
        }

        public int getLength() {
            return this.children;
        }

        public ExtendedNode append(ExtendedNode extendedNode) {
            if (this.lastChild == null) {
                this.firstChild = extendedNode;
                this.lastChild = extendedNode;
                ++this.children;
                return extendedNode;
            }
            this.lastChild.setNextSibling(extendedNode);
            extendedNode.setPreviousSibling(this.lastChild);
            this.lastChild = extendedNode;
            ++this.children;
            return extendedNode;
        }

        public ExtendedNode insert(ExtendedNode extendedNode, ExtendedNode extendedNode2) {
            if (extendedNode2 == null) {
                return this.append(extendedNode);
            }
            if (extendedNode2 == this.firstChild) {
                this.firstChild.setPreviousSibling(extendedNode);
                extendedNode.setNextSibling(this.firstChild);
                this.firstChild = extendedNode;
                ++this.children;
                return extendedNode;
            }
            ExtendedNode extendedNode3 = this.firstChild;
            while (extendedNode3 != null) {
                if (extendedNode3 == extendedNode2) {
                    ExtendedNode extendedNode4 = (ExtendedNode)extendedNode2.getPreviousSibling();
                    extendedNode4.setNextSibling(extendedNode);
                    extendedNode2.setPreviousSibling(extendedNode);
                    extendedNode.setNextSibling(extendedNode2);
                    extendedNode.setPreviousSibling(extendedNode4);
                    ++this.children;
                    return extendedNode;
                }
                extendedNode3 = (ExtendedNode)extendedNode3.getNextSibling();
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(extendedNode2.getNodeType()), extendedNode2.getNodeName()});
        }

        public ExtendedNode replace(ExtendedNode extendedNode, ExtendedNode extendedNode2) {
            if (extendedNode2 == this.firstChild) {
                ExtendedNode extendedNode3 = (ExtendedNode)this.firstChild.getNextSibling();
                extendedNode.setNextSibling(extendedNode3);
                if (extendedNode2 == this.lastChild) {
                    this.lastChild = extendedNode;
                } else {
                    extendedNode3.setPreviousSibling(extendedNode);
                }
                this.firstChild.setNextSibling(null);
                this.firstChild = extendedNode;
                return extendedNode2;
            }
            if (extendedNode2 == this.lastChild) {
                ExtendedNode extendedNode4 = (ExtendedNode)this.lastChild.getPreviousSibling();
                extendedNode.setPreviousSibling(extendedNode4);
                extendedNode4.setNextSibling(extendedNode);
                this.lastChild.setPreviousSibling(null);
                this.lastChild = extendedNode;
                return extendedNode2;
            }
            ExtendedNode extendedNode5 = this.firstChild;
            while (extendedNode5 != null) {
                if (extendedNode5 == extendedNode2) {
                    ExtendedNode extendedNode6 = (ExtendedNode)extendedNode2.getPreviousSibling();
                    extendedNode.setPreviousSibling(extendedNode6);
                    extendedNode6.setNextSibling(extendedNode);
                    extendedNode6 = (ExtendedNode)extendedNode2.getNextSibling();
                    extendedNode.setNextSibling(extendedNode6);
                    extendedNode6.setPreviousSibling(extendedNode);
                    extendedNode2.setPreviousSibling(null);
                    extendedNode2.setNextSibling(null);
                    return extendedNode2;
                }
                extendedNode5 = (ExtendedNode)extendedNode5.getNextSibling();
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(extendedNode2.getNodeType()), extendedNode2.getNodeName()});
        }

        public ExtendedNode remove(ExtendedNode extendedNode) {
            if (extendedNode == this.firstChild) {
                if (extendedNode == this.lastChild) {
                    this.firstChild = null;
                    this.lastChild = null;
                    --this.children;
                    return extendedNode;
                }
                this.firstChild = (ExtendedNode)this.firstChild.getNextSibling();
                this.firstChild.setPreviousSibling(null);
                extendedNode.setNextSibling(null);
                --this.children;
                return extendedNode;
            }
            if (extendedNode == this.lastChild) {
                this.lastChild = (ExtendedNode)this.lastChild.getPreviousSibling();
                this.lastChild.setNextSibling(null);
                extendedNode.setPreviousSibling(null);
                --this.children;
                return extendedNode;
            }
            ExtendedNode extendedNode2 = this.firstChild;
            while (extendedNode2 != null) {
                if (extendedNode2 == extendedNode) {
                    ExtendedNode extendedNode3 = (ExtendedNode)extendedNode.getPreviousSibling();
                    ExtendedNode extendedNode4 = (ExtendedNode)extendedNode.getNextSibling();
                    extendedNode3.setNextSibling(extendedNode4);
                    extendedNode4.setPreviousSibling(extendedNode3);
                    extendedNode.setPreviousSibling(null);
                    extendedNode.setNextSibling(null);
                    --this.children;
                    return extendedNode;
                }
                extendedNode2 = (ExtendedNode)extendedNode2.getNextSibling();
            }
            throw AbstractParentNode.this.createDOMException((short)8, "child.missing", new Object[]{new Integer(extendedNode.getNodeType()), extendedNode.getNodeName()});
        }
    }

    protected class ElementsByTagName
    implements NodeList {
        protected Node[] table;
        protected int size = -1;
        protected String namespaceURI;
        protected String localName;

        public ElementsByTagName(String string, String string2) {
            this.namespaceURI = string;
            this.localName = string2;
        }

        public Node item(int n) {
            if (this.size == -1) {
                this.initialize();
            }
            if (this.table == null || n < 0 || n > this.size) {
                return null;
            }
            return this.table[n];
        }

        public int getLength() {
            if (this.size == -1) {
                this.initialize();
            }
            return this.size;
        }

        public void invalidate() {
            this.size = -1;
        }

        protected void append(Node node) {
            if (this.table == null) {
                this.table = new Node[11];
            } else if (this.size == this.table.length - 1) {
                Node[] nodeArray = new Node[this.table.length * 2 + 1];
                int n = 0;
                while (n < this.size) {
                    nodeArray[n] = this.table[n];
                    ++n;
                }
                this.table = nodeArray;
            }
            this.table[this.size++] = node;
        }

        protected void initialize() {
            this.size = 0;
            Node node = AbstractParentNode.this.getFirstChild();
            while (node != null) {
                this.initialize(node);
                node = node.getNextSibling();
            }
        }

        private void initialize(Node node) {
            Object object;
            if (node.getNodeType() == 1) {
                String string;
                object = node.getNamespaceURI();
                String string2 = string = object == null ? node.getNodeName() : node.getLocalName();
                if (this.nsMatch(this.namespaceURI, node.getNamespaceURI()) && (this.localName.equals("*") || this.localName.equals(string))) {
                    this.append(node);
                }
            }
            object = node.getFirstChild();
            while (object != null) {
                this.initialize((Node)object);
                object = object.getNextSibling();
            }
        }

        private boolean nsMatch(String string, String string2) {
            if (string == null && string2 == null) {
                return true;
            }
            if (string == null || string2 == null) {
                return false;
            }
            if (string.equals("*")) {
                return true;
            }
            return string.equals(string2);
        }
    }
}

