/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.css.value.CommonCSSContext;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.RelativeValueResolver;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.ViewCSS;

public class FontWeightResolver
implements RelativeValueResolver {
    protected CommonCSSContext context;

    public FontWeightResolver(CommonCSSContext commonCSSContext) {
        this.context = commonCSSContext;
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-weight";
    }

    public CSSOMReadOnlyValue getDefaultValue() {
        return new CSSOMReadOnlyValue(ValueConstants.NORMAL_VALUE);
    }

    public void resolveValue(Element element, String string, ViewCSS viewCSS, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration, CSSOMReadOnlyValue cSSOMReadOnlyValue, String string2, int n) {
        boolean bl;
        ImmutableValue immutableValue = cSSOMReadOnlyValue.getImmutableValue();
        boolean bl2 = bl = immutableValue == ValueConstants.BOLDER_VALUE;
        if (bl || immutableValue == ValueConstants.LIGHTER_VALUE) {
            CSSOMReadOnlyValue cSSOMReadOnlyValue2;
            Element element2 = HiddenChildElementSupport.getParentElement(element);
            if (element2 == null) {
                cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? this.createFontWeight(this.context.getBolderFontWeight(400.0f)) : this.createFontWeight(this.context.getLighterFontWeight(400.0f)));
            } else {
                CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration2 = (CSSOMReadOnlyStyleDeclaration)viewCSS.getComputedStyle(element2, null);
                CSSOMReadOnlyValue cSSOMReadOnlyValue3 = (CSSOMReadOnlyValue)cSSOMReadOnlyStyleDeclaration2.getPropertyCSSValue(this.getPropertyName());
                immutableValue = cSSOMReadOnlyValue3.getImmutableValue();
                if (immutableValue.getPrimitiveType() == 21) {
                    cSSOMReadOnlyValue2 = immutableValue == ValueConstants.NORMAL_VALUE ? new CSSOMReadOnlyValue(bl ? this.createFontWeight(this.context.getBolderFontWeight(400.0f)) : this.createFontWeight(this.context.getLighterFontWeight(400.0f))) : new CSSOMReadOnlyValue(bl ? this.createFontWeight(this.context.getBolderFontWeight(700.0f)) : this.createFontWeight(this.context.getLighterFontWeight(700.0f)));
                } else {
                    float f = immutableValue.getFloatValue((short)1);
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? this.createFontWeight(this.context.getBolderFontWeight(f)) : this.createFontWeight(this.context.getLighterFontWeight(f)));
                }
            }
            cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(this.getPropertyName(), cSSOMReadOnlyValue2, string2, n);
        }
    }

    protected ImmutableValue createFontWeight(float f) {
        switch ((int)f) {
            case 100: {
                return ValueConstants.NUMBER_100;
            }
            case 200: {
                return ValueConstants.NUMBER_200;
            }
            case 300: {
                return ValueConstants.NUMBER_300;
            }
            case 400: {
                return ValueConstants.NUMBER_400;
            }
            case 500: {
                return ValueConstants.NUMBER_500;
            }
            case 600: {
                return ValueConstants.NUMBER_600;
            }
            case 700: {
                return ValueConstants.NUMBER_700;
            }
            case 800: {
                return ValueConstants.NUMBER_800;
            }
            case 900: {
                return ValueConstants.NUMBER_900;
            }
        }
        throw new InternalError();
    }
}

