/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public abstract class AbstractIdentifierFactory
extends AbstractValueFactory {
    protected AbstractIdentifierFactory(Parser parser) {
        super(parser);
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase().intern();
                Object object = this.getIdentifiers().get(string);
                if (object == null) {
                    throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{lexicalUnit.getStringValue(), this.getPropertyName()});
                }
                return (ImmutableValue)object;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
    }

    public ImmutableValue createStringValue(short s, String string) throws DOMException {
        if (s != 21) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string, this.getPropertyName()});
        }
        Object object = this.getIdentifiers().get(string.toLowerCase().intern());
        if (object == null) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string, this.getPropertyName()});
        }
        return (ImmutableValue)object;
    }

    protected abstract PropertyMap getIdentifiers();
}

