/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.HiddenChildElement;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGUseElementBridge
extends AbstractSVGBridge
implements GraphicsNodeBridge,
ErrorConstants {
    public String getLocalName() {
        return "use";
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        String string = XLinkSupport.getXLinkHref(element);
        if (string.length() == 0) {
            throw new BridgeException(element, "uri.malformed", new Object[]{string});
        }
        Element element2 = bridgeContext.getReferencedElement(element, string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
        SVGOMDocument sVGOMDocument2 = (SVGOMDocument)element2.getOwnerDocument();
        boolean bl = sVGOMDocument2 == sVGOMDocument;
        Object object5 = object4 = bl ? (Element)element2.cloneNode(true) : (Element)sVGOMDocument.importNode(element2, true);
        if ("symbol".equals(object4.getLocalName())) {
            object3 = sVGOMDocument.createElementNS("http://www.w3.org/2000/svg", "svg");
            object2 = object4.getAttributes();
            int n = object2.getLength();
            int n2 = 0;
            while (n2 < n) {
                object = (Attr)object2.item(n2);
                object3.setAttributeNS(object.getNamespaceURI(), object.getName(), object.getValue());
                ++n2;
            }
            object = object4.getFirstChild();
            while (object != null) {
                object3.appendChild((Node)object);
                object = object4.getFirstChild();
            }
            object4 = object3;
        }
        if ("svg".equals(object4.getLocalName())) {
            object3 = element.getAttributeNS(null, "width");
            if (((String)object3).length() != 0) {
                object4.setAttributeNS(null, "width", (String)object3);
            }
            if (((String)(object2 = element.getAttributeNS(null, "height"))).length() != 0) {
                object4.setAttributeNS(null, "height", (String)object2);
            }
        }
        ((HiddenChildElement)object4).setParentElement(element);
        object3 = object4;
        if (!bl) {
            CSSUtilities.computeStyleAndURIs(element2, (Element)object4, string);
        }
        object2 = bridgeContext.getGVTBuilder();
        GraphicsNode graphicsNode = ((GVTBuilder)object2).build(bridgeContext, (Element)object3);
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        compositeGraphicsNode.getChildren().add(graphicsNode);
        object = UnitProcessor.createContext(bridgeContext, element);
        float f = 0.0f;
        String string2 = element.getAttributeNS(null, "x");
        if (string2.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string2, "x", (UnitProcessor.Context)object);
        }
        float f2 = 0.0f;
        string2 = element.getAttributeNS(null, "y");
        if (string2.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string2, "y", (UnitProcessor.Context)object);
        }
        string2 = element.getAttributeNS(null, "transform");
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        if (string2.length() != 0) {
            affineTransform.concatenate(SVGUtilities.convertTransform(element, "transform", string2));
        }
        compositeGraphicsNode.setTransform(affineTransform);
        compositeGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        Rectangle2D rectangle2D = CSSUtilities.convertEnableBackground(element, (UnitProcessor.Context)object);
        if (rectangle2D != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        return compositeGraphicsNode;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        graphicsNode.setComposite(CSSUtilities.convertOpacity(element));
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        if (bridgeContext.isDynamic()) {
            bridgeContext.bind(element, graphicsNode);
        }
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
        throw new Error("Not implemented");
    }

    public boolean isComposite() {
        return false;
    }
}

