/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGFontFace;
import org.apache.batik.bridge.SVGGlyphElementBridge;
import org.apache.batik.bridge.SVGHKernElementBridge;
import org.apache.batik.bridge.SVGVKernElementBridge;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.Glyph;
import org.apache.batik.gvt.font.Kern;
import org.apache.batik.gvt.font.KerningTable;
import org.apache.batik.gvt.font.SVGGVTGlyphVector;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public final class SVGGVTFont
implements GVTFont,
SVGConstants {
    private float fontSize;
    private SVGFontFace fontFace;
    private String[] glyphUnicodes;
    private String[] glyphNames;
    private String[] glyphLangs;
    private String[] glyphOrientations;
    private String[] glyphForms;
    private Element[] glyphElements;
    private Element[] hkernElements;
    private Element[] vkernElements;
    private BridgeContext ctx;
    private Element textElement;
    private Element missingGlyphElement;
    private KerningTable hKerningTable;
    private KerningTable vKerningTable;
    private String language;
    private String orientation;

    public SVGGVTFont(float f, SVGFontFace sVGFontFace, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, BridgeContext bridgeContext, Element[] elementArray, Element element, Element[] elementArray2, Element[] elementArray3, Element element2) {
        this.fontFace = sVGFontFace;
        this.fontSize = f;
        this.glyphUnicodes = stringArray;
        this.glyphNames = stringArray2;
        this.glyphLangs = stringArray3;
        this.glyphOrientations = stringArray4;
        this.glyphForms = stringArray5;
        this.ctx = bridgeContext;
        this.glyphElements = elementArray;
        this.missingGlyphElement = element;
        this.hkernElements = elementArray2;
        this.vkernElements = elementArray3;
        this.textElement = element2;
        this.language = XMLSupport.getXMLLang(element2);
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element2);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("writing-mode");
        this.orientation = cSSOMReadOnlyValue.getStringValue().startsWith("tb") ? "v" : "h";
        this.createKerningTables();
    }

    private void createKerningTables() {
        Object object;
        Kern[] kernArray;
        Kern[] kernArray2 = new Kern[this.hkernElements.length];
        int n = 0;
        while (n < this.hkernElements.length) {
            kernArray = this.hkernElements[n];
            SVGHKernElementBridge sVGHKernElementBridge = (SVGHKernElementBridge)this.ctx.getBridge((Element)kernArray);
            object = sVGHKernElementBridge.createKern(this.ctx, (Element)kernArray, this);
            kernArray2[n] = object;
            ++n;
        }
        this.hKerningTable = new KerningTable(kernArray2);
        kernArray = new Kern[this.vkernElements.length];
        int n2 = 0;
        while (n2 < this.vkernElements.length) {
            Kern kern;
            object = this.vkernElements[n2];
            SVGVKernElementBridge sVGVKernElementBridge = (SVGVKernElementBridge)this.ctx.getBridge((Element)object);
            kernArray[n2] = kern = sVGVKernElementBridge.createKern(this.ctx, (Element)object, this);
            ++n2;
        }
        this.vKerningTable = new KerningTable(kernArray);
    }

    public float getHKern(int n, int n2) {
        if (n < 0 || n >= this.glyphUnicodes.length || n2 < 0 || n2 >= this.glyphUnicodes.length) {
            return 0.0f;
        }
        return this.hKerningTable.getKerningValue(n, n2, this.glyphUnicodes[n], this.glyphUnicodes[n2]);
    }

    public float getVKern(int n, int n2) {
        if (n < 0 || n >= this.glyphUnicodes.length || n2 < 0 || n2 >= this.glyphUnicodes.length) {
            return 0.0f;
        }
        return this.vKerningTable.getKerningValue(n, n2, this.glyphUnicodes[n], this.glyphUnicodes[n2]);
    }

    public int[] getGlyphCodesForName(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < this.glyphNames.length) {
            if (this.glyphNames[n] != null && this.glyphNames[n].equals(string)) {
                vector.add(new Integer(n));
            }
            ++n;
        }
        int[] nArray = new int[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            nArray[n2] = (Integer)vector.elementAt(n2);
            ++n2;
        }
        return nArray;
    }

    public int[] getGlyphCodesForUnicode(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < this.glyphUnicodes.length) {
            if (this.glyphUnicodes[n] != null && this.glyphUnicodes[n].equals(string)) {
                vector.add(new Integer(n));
            }
            ++n;
        }
        int[] nArray = new int[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            nArray[n2] = (Integer)vector.elementAt(n2);
            ++n2;
        }
        return nArray;
    }

    private boolean languageMatches(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals(this.language) && (!string2.startsWith(this.language) || string2.length() <= this.language.length() || string2.charAt(this.language.length()) != '-')) continue;
            return true;
        }
        return false;
    }

    private boolean orientationMatches(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.equals(this.orientation);
    }

    private boolean formMatches(String string, String string2, AttributedCharacterIterator attributedCharacterIterator, int n) {
        if (attributedCharacterIterator == null || string2 == null || string2.length() == 0) {
            return true;
        }
        char c = attributedCharacterIterator.setIndex(n);
        Integer n2 = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
        if (n2 == null || n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_NONE)) {
            return false;
        }
        if (string.length() > 1) {
            boolean bl = true;
            int n3 = 1;
            while (n3 < string.length()) {
                c = attributedCharacterIterator.next();
                if (string.charAt(n3) != c) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            attributedCharacterIterator.setIndex(n);
            if (bl) {
                char c2 = attributedCharacterIterator.setIndex(n + string.length() - 1);
                Integer n4 = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
                attributedCharacterIterator.setIndex(n);
                if (n2 != null && n4 != null) {
                    if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL) && n4.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL)) {
                        return string2.equals("isolated");
                    }
                    if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL)) {
                        return string2.equals("terminal");
                    }
                    if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL) && n4.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL)) {
                        return string2.equals("medial");
                    }
                }
            }
        }
        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED)) {
            return string2.equals("isolated");
        }
        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL)) {
            return string2.equals("terminal");
        }
        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL)) {
            return string2.equals("initial");
        }
        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL)) {
            return string2.equals("medial");
        }
        return false;
    }

    public boolean canDisplayGivenName(String string) {
        int n = 0;
        while (n < this.glyphNames.length) {
            if (this.glyphNames[n] != null && this.glyphNames[n].equals(string) && this.languageMatches(this.glyphLangs[n]) && this.orientationMatches(this.glyphOrientations[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean canDisplay(char c) {
        int n = 0;
        while (n < this.glyphUnicodes.length) {
            if (this.glyphUnicodes[n].indexOf(c) != -1 && this.languageMatches(this.glyphLangs[n]) && this.orientationMatches(this.glyphOrientations[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        return this.canDisplayUpTo(stringCharacterIterator, n, n2);
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (characterIterator instanceof AttributedCharacterIterator) {
            attributedCharacterIterator = (AttributedCharacterIterator)characterIterator;
        }
        char c = characterIterator.setIndex(n);
        int n3 = n;
        while (c != '\uffff' && n3 < n2) {
            boolean bl = false;
            int n4 = 0;
            while (n4 < this.glyphUnicodes.length) {
                if (this.glyphUnicodes[n4].indexOf(c) == 0 && this.languageMatches(this.glyphLangs[n4]) && this.orientationMatches(this.glyphOrientations[n4]) && this.formMatches(this.glyphUnicodes[n4], this.glyphForms[n4], attributedCharacterIterator, n3)) {
                    if (this.glyphUnicodes[n4].length() == 1) {
                        bl = true;
                        break;
                    }
                    boolean bl2 = true;
                    int n5 = 1;
                    while (n5 < this.glyphUnicodes[n4].length()) {
                        c = characterIterator.next();
                        if (this.glyphUnicodes[n4].charAt(n5) != c) {
                            bl2 = false;
                            break;
                        }
                        ++n5;
                    }
                    if (bl2) {
                        bl = true;
                        break;
                    }
                    c = characterIterator.setIndex(n3);
                }
                ++n4;
            }
            if (!bl) {
                return n3;
            }
            c = characterIterator.next();
            n3 = characterIterator.getIndex();
        }
        return -1;
    }

    public int canDisplayUpTo(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.canDisplayUpTo(stringCharacterIterator, 0, string.length());
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        return this.createGlyphVector(fontRenderContext, stringCharacterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        int n;
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (characterIterator instanceof AttributedCharacterIterator) {
            attributedCharacterIterator = (AttributedCharacterIterator)characterIterator;
        }
        Vector<Object> vector = new Vector<Object>();
        char c = characterIterator.first();
        while (c != '\uffff') {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            n = 0;
            int n2 = 0;
            while (n2 < this.glyphUnicodes.length) {
                if (this.glyphUnicodes[n2].indexOf(c) == 0 && this.languageMatches(this.glyphLangs[n2]) && this.orientationMatches(this.glyphOrientations[n2]) && this.formMatches(this.glyphUnicodes[n2], this.glyphForms[n2], attributedCharacterIterator, characterIterator.getIndex())) {
                    Object object5;
                    if (this.glyphUnicodes[n2].length() == 1) {
                        Glyph glyph;
                        object4 = this.glyphElements[n2];
                        object3 = (SVGGlyphElementBridge)this.ctx.getBridge((Element)object4);
                        if (attributedCharacterIterator != null) {
                            attributedCharacterIterator.setIndex(characterIterator.getIndex());
                            object2 = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
                            object = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
                            object5 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
                            glyph = ((SVGGlyphElementBridge)object3).createGlyph(this.ctx, (Element)object4, this.textElement, n2, this.fontSize, this.fontFace, (Paint)object2, (Paint)object, (Stroke)object5);
                        } else {
                            glyph = ((SVGGlyphElementBridge)object3).createGlyph(this.ctx, (Element)object4, this.textElement, n2, this.fontSize, this.fontFace, null, null, null);
                        }
                        vector.add(glyph);
                        n = 1;
                        break;
                    }
                    int n3 = characterIterator.getIndex();
                    boolean bl = true;
                    int n4 = 1;
                    while (n4 < this.glyphUnicodes[n2].length()) {
                        c = characterIterator.next();
                        if (this.glyphUnicodes[n2].charAt(n4) != c) {
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                    if (bl) {
                        object2 = this.glyphElements[n2];
                        object = (SVGGlyphElementBridge)this.ctx.getBridge((Element)object2);
                        if (attributedCharacterIterator != null) {
                            attributedCharacterIterator.setIndex(characterIterator.getIndex());
                            Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
                            Paint paint2 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
                            Stroke stroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
                            object5 = ((SVGGlyphElementBridge)object).createGlyph(this.ctx, (Element)object2, this.textElement, n2, this.fontSize, this.fontFace, paint, paint2, stroke);
                        } else {
                            object5 = ((SVGGlyphElementBridge)object).createGlyph(this.ctx, (Element)object2, this.textElement, n2, this.fontSize, this.fontFace, null, null, null);
                        }
                        vector.add(object5);
                        n = 1;
                        break;
                    }
                    c = characterIterator.setIndex(n3);
                }
                ++n2;
            }
            if (n == 0) {
                object4 = (SVGGlyphElementBridge)this.ctx.getBridge(this.missingGlyphElement);
                if (attributedCharacterIterator != null) {
                    attributedCharacterIterator.setIndex(characterIterator.getIndex());
                    Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
                    object2 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
                    object = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
                    object3 = ((SVGGlyphElementBridge)object4).createGlyph(this.ctx, this.missingGlyphElement, this.textElement, -1, this.fontSize, this.fontFace, paint, (Paint)object2, (Stroke)object);
                } else {
                    object3 = ((SVGGlyphElementBridge)object4).createGlyph(this.ctx, this.missingGlyphElement, this.textElement, -1, this.fontSize, this.fontFace, null, null, null);
                }
                vector.add(object3);
            }
            c = characterIterator.next();
        }
        n = vector.size();
        Glyph[] glyphArray = new Glyph[n];
        int n5 = 0;
        while (n5 < n) {
            glyphArray[n5] = (Glyph)vector.get(n5);
            ++n5;
        }
        return new SVGGVTGlyphVector(this, glyphArray, fontRenderContext);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray, CharacterIterator characterIterator) {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = string + this.glyphUnicodes[nArray[n]];
            ++n;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.createGlyphVector(fontRenderContext, stringCharacterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.createGlyphVector(fontRenderContext, stringCharacterIterator);
    }

    public GVTFont deriveFont(float f) {
        return new SVGGVTFont(f, this.fontFace, this.glyphUnicodes, this.glyphNames, this.glyphLangs, this.glyphOrientations, this.glyphForms, this.ctx, this.glyphElements, this.missingGlyphElement, this.hkernElements, this.vkernElements, this.textElement);
    }

    public GVTLineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        return this.getLineMetrics(stringCharacterIterator, n, n2, fontRenderContext);
    }

    public GVTLineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        String string = "";
        char c = characterIterator.setIndex(n);
        int n3 = n;
        while (c != '\uffff' && n3 < n2) {
            string = string + c;
            ++n3;
            c = characterIterator.next();
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        GVTGlyphVector gVTGlyphVector = this.createGlyphVector(fontRenderContext, stringCharacterIterator);
        float f = this.fontFace.getUnitsPerEm();
        float f2 = this.fontSize / f;
        float f3 = this.fontFace.getAscent() * f2;
        float f4 = this.fontFace.getDescent() * f2;
        int n4 = gVTGlyphVector.getNumGlyphs();
        float[] fArray = new float[n4];
        int n5 = 0;
        while (n5 < n4) {
            fArray[n5] = (float)(gVTGlyphVector.getGlyphMetrics(n5).getBounds2D().getMaxY() - gVTGlyphVector.getGlyphPosition(n5).getY());
            ++n5;
        }
        float f5 = this.fontFace.getStrikethroughPosition() * -f2;
        float f6 = this.fontFace.getStrikethroughThickness() * f2;
        float f7 = this.fontFace.getUnderlinePosition() * f2;
        float f8 = this.fontFace.getUnderlineThickness() * f2;
        float f9 = this.fontFace.getOverlinePosition() * -f2;
        float f10 = this.fontFace.getOverlineThickness() * f2;
        return new GVTLineMetrics(f3, 0, fArray, f4, f, f, n4, f5, f6, f7, f8, f9, f10);
    }

    public GVTLineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.getLineMetrics(stringCharacterIterator, 0, string.length(), fontRenderContext);
    }

    public GVTLineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.getLineMetrics(stringCharacterIterator, n, n2, fontRenderContext);
    }

    public float getSize() {
        return this.fontSize;
    }

    public String toString() {
        return this.fontFace.getFamilyName() + " " + this.fontFace.getFontWeight() + " " + this.fontFace.getFontStyle();
    }
}

