/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FilterBridge;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterChainRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.GraphicsNodeRable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFilterElementBridge
extends AbstractSVGBridge
implements FilterBridge,
ErrorConstants {
    public String getLocalName() {
        return "filter";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode) {
        Rectangle2D rectangle2D = SVGUtilities.convertFilterChainRegion(element, element2, graphicsNode, bridgeContext);
        GraphicsNodeRable graphicsNodeRable = graphicsNode.getGraphicsNodeRable();
        FilterChainRable8Bit filterChainRable8Bit = new FilterChainRable8Bit((Filter)graphicsNodeRable, rectangle2D);
        float[] fArray = SVGUtilities.convertFilterRes(element, bridgeContext);
        filterChainRable8Bit.setFilterResolutionX((int)fArray[0]);
        filterChainRable8Bit.setFilterResolutionY((int)fArray[1]);
        HashMap<String, GraphicsNodeRable> hashMap = new HashMap<String, GraphicsNodeRable>(11);
        hashMap.put("SourceGraphic", graphicsNodeRable);
        Filter filter = SVGFilterElementBridge.buildFilterPrimitives(element, rectangle2D, element2, graphicsNode, graphicsNodeRable, hashMap, bridgeContext);
        if (filter == graphicsNodeRable) {
            return null;
        }
        filterChainRable8Bit.setSource(filter);
        return filterChainRable8Bit;
    }

    protected static Filter buildFilterPrimitives(Element element, Rectangle2D rectangle2D, Element element2, GraphicsNode graphicsNode, Filter filter, Map map, BridgeContext bridgeContext) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        Filter filter2;
        while ((filter2 = SVGFilterElementBridge.buildLocalFilterPrimitives(element, rectangle2D, element2, graphicsNode, filter, map, bridgeContext)) == filter) {
            URL uRL;
            String string = XLinkSupport.getXLinkHref(element);
            if (string.length() == 0) {
                return filter;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            try {
                uRL = new URL(sVGOMDocument.getURLObject(), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new BridgeException(element, "uri.malformed", new Object[]{string});
            }
            if (SVGFilterElementBridge.contains(linkedList, uRL)) {
                throw new BridgeException(element, "xlink:href.circularDependencies", new Object[]{string});
            }
            linkedList.add(uRL);
            element = bridgeContext.getReferencedElement(element, string);
        }
        return filter2;
    }

    protected static Filter buildLocalFilterPrimitives(Element element, Rectangle2D rectangle2D, Element element2, GraphicsNode graphicsNode, Filter filter, Map map, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            Element element3;
            Bridge bridge;
            if (node.getNodeType() == 1 && (bridge = bridgeContext.getBridge(element3 = (Element)node)) != null && bridge instanceof FilterPrimitiveBridge) {
                FilterPrimitiveBridge filterPrimitiveBridge = (FilterPrimitiveBridge)bridge;
                Filter filter2 = filterPrimitiveBridge.createFilter(bridgeContext, element3, element2, graphicsNode, filter, rectangle2D, map);
                if (filter2 == null) {
                    return null;
                }
                filter = filter2;
            }
            node = node.getNextSibling();
        }
        return filter;
    }

    private static boolean contains(List list, URL uRL) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            URL uRL2 = (URL)iterator.next();
            if (!uRL2.sameFile(uRL) || !uRL2.getRef().equals(uRL.getRef())) continue;
            return true;
        }
        return false;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
        throw new Error("Not implemented");
    }
}

