/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ClipBridge;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGClipPathElementBridge
extends AbstractSVGBridge
implements ClipBridge {
    public String getLocalName() {
        return "clipPath";
    }

    public ClipRable createClip(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode) {
        Filter filter;
        Object object;
        Object object2;
        String string = element.getAttributeNS(null, "transform");
        AffineTransform affineTransform = string.length() != 0 ? SVGUtilities.convertTransform(element, "transform", string) : new AffineTransform();
        string = element.getAttributeNS(null, "clipPathUnits");
        short s = string.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element, "clipPathUnits", string);
        if (s == 2) {
            affineTransform = SVGUtilities.toObjectBBox(affineTransform, graphicsNode);
        }
        Area area = new Area();
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && (object2 = gVTBuilder.build(bridgeContext, (Element)(object = (Element)node))) != null) {
                bl = true;
                int n = CSSUtilities.convertClipRule((Element)object);
                GeneralPath generalPath = new GeneralPath(object2.getTransformedOutline());
                generalPath.setWindingRule(n);
                Shape shape = affineTransform.createTransformedShape(generalPath);
                ShapeNode shapeNode = new ShapeNode();
                shapeNode.setShape(shape);
                ClipRable clipRable = CSSUtilities.convertClipPath((Element)object, shapeNode, bridgeContext);
                if (clipRable != null) {
                    Area area2 = new Area(shape);
                    area2.subtract(new Area(clipRable.getClipPath()));
                    shape = area2;
                }
                area.add(new Area(shape));
            }
            node = node.getNextSibling();
        }
        if (!bl) {
            return null;
        }
        object = new ShapeNode();
        ((ShapeNode)object).setShape(area);
        object2 = CSSUtilities.convertClipPath(element, (GraphicsNode)object, bridgeContext);
        if (object2 != null) {
            area.subtract(new Area(object2.getClipPath()));
        }
        if ((filter = graphicsNode.getFilter()) == null) {
            filter = graphicsNode.getGraphicsNodeRable();
        }
        return new ClipRable8Bit(filter, area);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
        throw new Error("Not implemented");
    }
}

