/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.Messages;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterController;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.transcoder.Transcoder;

public class Main
implements SVGConverterController {
    public static String USAGE = Messages.formatMessage("Main.usage", null);
    public static String CL_OPTION_OUTPUT = Messages.get("Main.cl.option.output", "-d");
    public static String CL_OPTION_OUTPUT_DESCRIPTION = Messages.get("Main.cl.option.output.description", "No description");
    public static String CL_OPTION_MIME_TYPE = Messages.get("Main.cl.option.mime.type", "-m");
    public static String CL_OPTION_MIME_TYPE_DESCRIPTION = Messages.get("Main.cl.option.mime.type.description", "No description");
    public static String CL_OPTION_WIDTH = Messages.get("Main.cl.option.width", "-w");
    public static String CL_OPTION_WIDTH_DESCRIPTION = Messages.get("Main.cl.option.width.description", "No description");
    public static String CL_OPTION_HEIGHT = Messages.get("Main.cl.option.height", "-h");
    public static String CL_OPTION_HEIGHT_DESCRIPTION = Messages.get("Main.cl.option.height.description", "No description");
    public static String CL_OPTION_AOI = Messages.get("Main.cl.option.aoi", "-a");
    public static String CL_OPTION_AOI_DESCRIPTION = Messages.get("Main.cl.option.aoi.description", "No description");
    public static String CL_OPTION_BACKGROUND_COLOR = Messages.get("Main.cl.option.background.color", "-bg");
    public static String CL_OPTION_BACKGROUND_COLOR_DESCRIPTION = Messages.get("Main.cl.option.background.color.description", "No description");
    public static String CL_OPTION_MEDIA_TYPE = Messages.get("Main.cl.option.media.type", "-cssMedia");
    public static String CL_OPTION_MEDIA_TYPE_DESCRIPTION = Messages.get("Main.cl.option.media.type.description", "No description");
    public static String CL_OPTION_ALTERNATE_STYLESHEET = Messages.get("Main.cl.option.alternate.stylesheet", "-cssAlternate");
    public static String CL_OPTION_ALTERNATE_STYLESHEET_DESCRIPTION = Messages.get("Main.cl.option.alternate.stylesheet.description", "No description");
    public static String CL_OPTION_VALIDATE = Messages.get("Main.cl.option.validate", "-validate");
    public static String CL_OPTION_VALIDATE_DESCRIPTION = Messages.get("Main.cl.option.validate.description", "No description");
    public static String CL_OPTION_LANGUAGE = Messages.get("Main.cl.option.language", "-lang");
    public static String CL_OPTION_LANGUAGE_DESCRIPTION = Messages.get("Main.cl.option.language.description", "No description");
    public static String CL_OPTION_USER_STYLESHEET = Messages.get("Main.cl.option.user.stylesheet", "-cssUser");
    public static String CL_OPTION_USER_STYLESHEET_DESCRIPTION = Messages.get("Main.cl.option.user.stylesheet.description", "No description");
    public static String CL_OPTION_DPI = Messages.get("Main.cl.option.dpi", "-dpi");
    public static String CL_OPTION_DPI_DESCRIPTION = Messages.get("Main.cl.option.dpi.description", "No description");
    public static String CL_OPTION_QUALITY = Messages.get("Main.cl.option.quality", "-q");
    public static String CL_OPTION_QUALITY_DESCRIPTION = Messages.get("Main.cl.option.quality.description", "No description");
    protected static Map optionMap = new Hashtable();
    protected static Map mimeTypeMap = new Hashtable();
    protected Vector args = new Vector();
    public static final String ERROR_NOT_ENOUGH_OPTION_VALUES = "Main.error.not.enough.option.values";
    public static final String ERROR_ILLEGAL_ARGUMENT = "Main.error.illegal.argument";
    public static final String ERROR_WHILE_CONVERTING_FILES = "Main.error.while.converting.files";
    public static final String MESSAGE_ABOUT_TO_TRANSCODE = "Main.message.about.to.transcode";
    public static final String MESSAGE_ABOUT_TO_TRANSCODE_SOURCE = "Main.message.about.to.transcode.source";
    public static final String MESSAGE_CONVERSION_FAILED = "Main.message.conversion.failed";
    public static final String MESSAGE_CONVERSION_SUCCESS = "Main.message.conversion.success";

    public Main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.args.addElement(stringArray[n]);
            ++n;
        }
    }

    protected void error(String string, Object[] objectArray) {
        System.err.println(Messages.formatMessage(string, objectArray));
    }

    public void execute() {
        Object object;
        SVGConverter sVGConverter = new SVGConverter(this);
        Vector<String[]> vector = new Vector<String[]>();
        int n = this.args.size();
        int n2 = 0;
        while (n2 < n) {
            object = (String)this.args.elementAt(n2);
            OptionHandler optionHandler = (OptionHandler)optionMap.get(object);
            if (optionHandler == null) {
                vector.addElement((String[])object);
            } else {
                int n3 = optionHandler.getOptionValuesLength();
                if (n2 + n3 >= n) {
                    this.error(ERROR_NOT_ENOUGH_OPTION_VALUES, new Object[]{object, optionHandler.getOptionDescription()});
                    return;
                }
                String[] stringArray = new String[n3];
                int n4 = 0;
                while (n4 < n3) {
                    stringArray[n4] = (String)this.args.elementAt(1 + n2 + n4);
                    ++n4;
                }
                n2 += n3;
                try {
                    optionHandler.handleOption(stringArray, sVGConverter);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                    this.error(ERROR_ILLEGAL_ARGUMENT, new Object[]{object, optionHandler.getOptionDescription(), this.toString(stringArray)});
                    return;
                }
            }
            ++n2;
        }
        object = this.expandSources(vector);
        sVGConverter.setSources((String[])object);
        this.validateConverterConfig(sVGConverter);
        if (object == null || ((String[])object).length < 1) {
            System.out.println("sources.length : " + vector.size());
            System.out.println(USAGE);
            return;
        }
        try {
            sVGConverter.execute();
        }
        catch (SVGConverterException sVGConverterException) {
            this.error(ERROR_WHILE_CONVERTING_FILES, new Object[]{sVGConverterException.getMessage()});
        }
    }

    protected String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(stringArray[n2] + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void validateConverterConfig(SVGConverter sVGConverter) {
    }

    protected String[] expandSources(Vector vector) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            File file = new File((String)object);
            if (file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles(new SVGConverter.SVGFileFilter());
                int n = 0;
                while (n < fileArray.length) {
                    vector2.addElement(fileArray[n].getPath());
                    ++n;
                }
                continue;
            }
            vector2.addElement(object);
        }
        object = new String[vector2.size()];
        vector2.copyInto((Object[])object);
        return object;
    }

    public static void main(String[] stringArray) {
        new Main(stringArray).execute();
        System.exit(0);
    }

    public boolean proceedWithComputedTask(Transcoder transcoder, Map map, Vector vector, Vector vector2) {
        System.out.println(Messages.formatMessage(MESSAGE_ABOUT_TO_TRANSCODE, new Object[]{"" + vector.size()}));
        return true;
    }

    public boolean proceedWithSourceTranscoding(SVGConverterSource sVGConverterSource, File file) {
        System.out.print(Messages.formatMessage(MESSAGE_ABOUT_TO_TRANSCODE_SOURCE, new Object[]{sVGConverterSource.toString(), file.toString()}));
        return true;
    }

    public boolean proceedOnSourceTranscodingFailure(SVGConverterSource sVGConverterSource, File file, String string) {
        System.out.println(Messages.formatMessage(MESSAGE_CONVERSION_FAILED, new Object[]{string}));
        return true;
    }

    public void onSourceTranscodingSuccess(SVGConverterSource sVGConverterSource, File file) {
        System.out.println(Messages.formatMessage(MESSAGE_CONVERSION_SUCCESS, null));
    }

    static {
        mimeTypeMap.put("image/jpg", DestinationType.JPEG);
        mimeTypeMap.put("image/jpeg", DestinationType.JPEG);
        mimeTypeMap.put("image/jpe", DestinationType.JPEG);
        mimeTypeMap.put("image/png", DestinationType.PNG);
        mimeTypeMap.put("application/pdf", DestinationType.PDF);
        mimeTypeMap.put("image/tiff", DestinationType.TIFF);
        optionMap.put(CL_OPTION_OUTPUT, new SingleValueOptionHandler(){

            public void handleOption(String string, SVGConverter sVGConverter) {
                sVGConverter.setDst(new File(string));
            }

            public String getOptionDescription() {
                return CL_OPTION_OUTPUT_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_MIME_TYPE, new SingleValueOptionHandler(){

            public void handleOption(String string, SVGConverter sVGConverter) {
                DestinationType destinationType = (DestinationType)mimeTypeMap.get(string);
                if (destinationType == null) {
                    throw new IllegalArgumentException();
                }
                sVGConverter.setDestinationType(destinationType);
            }

            public String getOptionDescription() {
                return CL_OPTION_MIME_TYPE_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_WIDTH, new FloatOptionHandler(){

            public void handleOption(float f, SVGConverter sVGConverter) {
                if (f <= 0.0f) {
                    throw new IllegalArgumentException();
                }
                sVGConverter.setWidth(f);
            }

            public String getOptionDescription() {
                return CL_OPTION_WIDTH_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_HEIGHT, new FloatOptionHandler(){

            public void handleOption(float f, SVGConverter sVGConverter) {
                if (f <= 0.0f) {
                    throw new IllegalArgumentException();
                }
                sVGConverter.setHeight(f);
            }

            public String getOptionDescription() {
                return CL_OPTION_HEIGHT_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_AOI, new RectangleOptionHandler(){

            public void handleOption(Rectangle2D rectangle2D, SVGConverter sVGConverter) {
                sVGConverter.setArea(rectangle2D);
            }

            public String getOptionDescription() {
                return CL_OPTION_AOI_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_BACKGROUND_COLOR, new ColorOptionHandler(){

            public void handleOption(Color color, SVGConverter sVGConverter) {
                sVGConverter.setBackgroundColor(color);
            }

            public String getOptionDescription() {
                return CL_OPTION_BACKGROUND_COLOR_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_MEDIA_TYPE, new SingleValueOptionHandler(){

            public void handleOption(String string, SVGConverter sVGConverter) {
                sVGConverter.setMediaType(string);
            }

            public String getOptionDescription() {
                return CL_OPTION_MEDIA_TYPE_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_ALTERNATE_STYLESHEET, new SingleValueOptionHandler(){

            public void handleOption(String string, SVGConverter sVGConverter) {
                sVGConverter.setAlternateStylesheet(string);
            }

            public String getOptionDescription() {
                return CL_OPTION_ALTERNATE_STYLESHEET_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_USER_STYLESHEET, new SingleValueOptionHandler(){

            public void handleOption(String string, SVGConverter sVGConverter) {
                sVGConverter.setUserStylesheet(string);
            }

            public String getOptionDescription() {
                return CL_OPTION_USER_STYLESHEET_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_LANGUAGE, new SingleValueOptionHandler(){

            public void handleOption(String string, SVGConverter sVGConverter) {
                sVGConverter.setLanguage(string);
            }

            public String getOptionDescription() {
                return CL_OPTION_LANGUAGE_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_DPI, new FloatOptionHandler(){

            public void handleOption(float f, SVGConverter sVGConverter) {
                if (f <= 0.0f) {
                    throw new IllegalArgumentException();
                }
                sVGConverter.setPixelToMillimeter(2.54f / f * 10.0f);
            }

            public String getOptionDescription() {
                return CL_OPTION_DPI_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_QUALITY, new FloatOptionHandler(){

            public void handleOption(float f, SVGConverter sVGConverter) {
                if (f <= 0.0f || f >= 1.0f) {
                    throw new IllegalArgumentException();
                }
                sVGConverter.setQuality(f);
            }

            public String getOptionDescription() {
                return CL_OPTION_QUALITY_DESCRIPTION;
            }
        });
        optionMap.put(CL_OPTION_VALIDATE, new NoValueOptionHandler(){

            public void handleOption(SVGConverter sVGConverter) {
                sVGConverter.setValidate(true);
            }

            public String getOptionDescription() {
                return CL_OPTION_VALIDATE_DESCRIPTION;
            }
        });
    }

    public static abstract class ColorOptionHandler
    extends SingleValueOptionHandler {
        public void handleOption(String string, SVGConverter sVGConverter) {
            Color color = this.parseARGB(string);
            if (color == null) {
                throw new IllegalArgumentException();
            }
            this.handleOption(color, sVGConverter);
        }

        public abstract void handleOption(Color var1, SVGConverter var2);

        public Color parseARGB(String string) {
            StringTokenizer stringTokenizer;
            Color color = null;
            if (string != null && (stringTokenizer = new StringTokenizer(string, ".")).countTokens() == 4) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                int n = -1;
                int n2 = -1;
                int n3 = -1;
                int n4 = -1;
                try {
                    n = Integer.parseInt(string2);
                    n2 = Integer.parseInt(string3);
                    n3 = Integer.parseInt(string4);
                    n4 = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n >= 0 && n <= 255 && n2 >= 0 && n2 <= 255 && n3 >= 0 && n3 <= 255 && n4 >= 0 && n4 <= 255) {
                    color = new Color(n2, n3, n4, n);
                }
            }
            return color;
        }
    }

    public static abstract class RectangleOptionHandler
    extends SingleValueOptionHandler {
        public void handleOption(String string, SVGConverter sVGConverter) {
            Rectangle2D.Float float_ = this.parseRect(string);
            if (float_ == null) {
                throw new IllegalArgumentException();
            }
            this.handleOption(float_, sVGConverter);
        }

        public abstract void handleOption(Rectangle2D var1, SVGConverter var2);

        public Rectangle2D.Float parseRect(String string) {
            Rectangle2D.Float float_ = null;
            if (string != null) {
                StringTokenizer stringTokenizer;
                if (!string.toLowerCase().endsWith("f")) {
                    string = string + "f";
                }
                if ((stringTokenizer = new StringTokenizer(string, ",")).countTokens() == 4) {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    float f = Float.NaN;
                    float f2 = Float.NaN;
                    float f3 = Float.NaN;
                    float f4 = Float.NaN;
                    try {
                        f = Float.parseFloat(string2);
                        f2 = Float.parseFloat(string3);
                        f3 = Float.parseFloat(string4);
                        f4 = Float.parseFloat(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (!Float.isNaN(f) && !Float.isNaN(f2) && !Float.isNaN(f3) && f3 > 0.0f && !Float.isNaN(f4) && f4 > 0.0f) {
                        float_ = new Rectangle2D.Float(f, f2, f3, f4);
                    }
                }
            }
            return float_;
        }
    }

    public static abstract class FloatOptionHandler
    extends SingleValueOptionHandler {
        public void handleOption(String string, SVGConverter sVGConverter) {
            try {
                this.handleOption(Float.parseFloat(string), sVGConverter);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException();
            }
        }

        public abstract void handleOption(float var1, SVGConverter var2);
    }

    public static abstract class SingleValueOptionHandler
    extends AbstractOptionHandler {
        public void safeHandleOption(String[] stringArray, SVGConverter sVGConverter) {
            this.handleOption(stringArray[0], sVGConverter);
        }

        public int getOptionValuesLength() {
            return 1;
        }

        public abstract void handleOption(String var1, SVGConverter var2);
    }

    public static abstract class NoValueOptionHandler
    extends AbstractOptionHandler {
        public void safeHandleOption(String[] stringArray, SVGConverter sVGConverter) {
            this.handleOption(sVGConverter);
        }

        public int getOptionValuesLength() {
            return 0;
        }

        public abstract void handleOption(SVGConverter var1);
    }

    public static abstract class AbstractOptionHandler
    implements OptionHandler {
        public void handleOption(String[] stringArray, SVGConverter sVGConverter) {
            int n;
            int n2 = n = stringArray != null ? stringArray.length : 0;
            if (n != this.getOptionValuesLength()) {
                throw new IllegalArgumentException();
            }
            this.safeHandleOption(stringArray, sVGConverter);
        }

        public abstract void safeHandleOption(String[] var1, SVGConverter var2);

        public abstract String getOptionDescription();

        public abstract int getOptionValuesLength();
    }

    public static interface OptionHandler {
        public void handleOption(String[] var1, SVGConverter var2);

        public int getOptionValuesLength();

        public String getOptionDescription();
    }
}

