/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCertificateRequest;
import COM.claymoresystems.ptls.SSLCertificateVerify;
import COM.claymoresystems.ptls.SSLCipherSuite;
import COM.claymoresystems.ptls.SSLClientHello;
import COM.claymoresystems.ptls.SSLClientKeyExchange;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLHandshakeHdr;
import COM.claymoresystems.ptls.SSLHelloRequest;
import COM.claymoresystems.ptls.SSLServerHello;
import COM.claymoresystems.ptls.SSLServerHelloDone;
import COM.claymoresystems.ptls.SSLServerKeyExchange;
import COM.claymoresystems.ptls.SSLSessionData;
import COM.claymoresystems.ptls.SSLuint16;
import COM.claymoresystems.ptls.SSLuint24;
import COM.claymoresystems.ptls.SSLuintX;
import COM.claymoresystems.ptls.SSLv2ClientHello;
import COM.claymoresystems.sslg.SSLPolicyInt;
import COM.claymoresystems.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.Hashtable;
import java.util.Vector;

class SSLHandshakeServer
extends SSLHandshake {
    public final int SSL_HS_WAIT_FOR_CLIENT_HELLO = 1;
    public final int SSL_HS_WAIT_FOR_CERTIFICATE = 2;
    public final int SSL_HS_WAIT_FOR_CLIENT_KEY_EXCHANGE = 3;
    public final int SSL_HS_WAIT_FOR_CERTIFICATE_VERIFY = 4;
    public final int SSL_HS_SEND_HELLO_REQUEST = 5;
    private static final int SSL2_CK_RC4_128_WITH_MD5 = 65664;
    private static final int SSL2_CK_RC4_128_EXPORT40_WITH_MD5 = 131200;
    private static final int SSL2_CK_RC2_128_CBC_WITH_MD5 = 65664;
    private static final int SSL2_CK_RC2_128_CBC_EXPORT40_WITH_MD5 = 131200;
    private static final int SSL2_CK_IDEA_128_CBC_WITH_MD5 = 327808;
    private static final int SSL2_CK_DES_64_CBC_WITH_MD5 = 393344;
    private static final int SSL2_CK_DES_192_EDE3_CBC_WITH_MD5 = 393344;
    boolean resume = false;
    boolean clientAuth = false;
    SSLSessionData possibleResume = null;
    Vector offered_cipher_suites;
    Vector offered_compression_methods;
    private static Hashtable _v2_v3_cipher_suite_map = new Hashtable();

    public SSLHandshakeServer(SSLConn sSLConn) {
        super(sSLConn);
        this.stateChange(this._conn.write_cipher_state == null ? 1 : 5);
        SSLDebug.debug(64, "Starting server handshake (connection " + sSLConn + ") in state " + this.state + " write cipher state " + this._conn.write_cipher_state);
        this.client = false;
    }

    protected void filterCipherSuites(PrivateKey privateKey, SSLPolicyInt sSLPolicyInt) {
        String string = privateKey.getAlgorithm();
        this.cipher_suites = new Vector();
        short[] sArray = this._conn.getPolicy().getCipherSuites();
        int n = 0;
        while (n < sArray.length) {
            SSLCipherSuite sSLCipherSuite = SSLCipherSuite.findCipherSuite(sArray[n]);
            if (sSLCipherSuite == null) {
                SSLDebug.debug(16, "Rejecting unrecognized cipher suite" + sArray[n]);
            } else if (!sSLCipherSuite.getSignatureAlgBase().equals(string)) {
                SSLDebug.debug(16, "Rejecting cipher suite: " + sSLCipherSuite.getName() + " -- incompatible with signature algorithm " + string);
            } else {
                SSLDebug.debug(16, "Accepting cipher suite: " + sSLCipherSuite.getName());
                this.cipher_suites.addElement(sSLCipherSuite);
            }
            ++n;
        }
    }

    public void handshakeContinue() throws IOException {
        int n;
        InputStream inputStream = null;
        int n2 = -1;
        boolean bl = false;
        SSLHandshakeHdr sSLHandshakeHdr = new SSLHandshakeHdr();
        long l = 0L;
        if (this.state == 5) {
            l = System.currentTimeMillis();
            SSLDebug.debug(4, "Send hello request");
            this.sendHelloRequest();
            long l2 = System.currentTimeMillis() - l;
            SSLDebug.debug(4, "  Request sent in " + l2 + " ms\n");
            this.stateChange(1);
        }
        if (this._conn.read_cipher_state == null && this.state == 1) {
            int n3 = this._conn.sock_in.read();
            SSLDebug.debug(64, "Testing for SSLv2 handshake. First byte off wire is: " + n3);
            this._conn.sock_in.unread(n3);
            if (n3 != 22) {
                if (this._conn.read_cipher_state != null) {
                    this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
                }
                bl = true;
                n2 = 255;
            }
        }
        if (!bl) {
            inputStream = this.recvHandshakeMsg(this._conn, sSLHandshakeHdr);
            n2 = sSLHandshakeHdr.ct.value;
            SSLConn.debug(4, "Processing handshake message of type " + n2);
        }
        switch (n2) {
            case 255: {
                this.stateAssert(1);
                this.recvSSLv2ClientHello(this._conn.sock_in);
                this.resume = false;
                this.sendServerPhase1();
                this._conn.sock_out.flush();
                break;
            }
            case 1: {
                this.stateAssert(1);
                this.recvSSLv3ClientHello(inputStream);
                this.resume = false;
                if (this.possibleResume != null) {
                    if (this._conn.getPolicy().requireClientAuthP() && this.possibleResume.getPeerCertificateChain() == null) {
                        this.resume = false;
                    } else {
                        this.restoreSession(this.possibleResume);
                        this.resume = true;
                    }
                }
                this.sendServerPhase1();
                this._conn.sock_out.flush();
                break;
            }
            case 11: {
                this.stateAssert(2);
                this.recvCertificate(inputStream);
                this.stateChange(3);
                break;
            }
            case 16: {
                this.stateAssert(3);
                this.recvClientKeyExchange(inputStream);
                this.stateChange(this.clientAuth ? 4 : 20);
                break;
            }
            case 15: {
                this.stateAssert(4);
                this.recvCertificateVerify(inputStream);
                this.stateChange(20);
                break;
            }
            case 20: {
                this.stateAssert(21);
                this.recvFinished(inputStream);
                if (!this.resume) {
                    this.sendChangeCipherSpec();
                    this.sendFinished();
                }
                if (this.session_id.length != 0) {
                    this.storeSession(Util.toHex(this.session_id));
                }
                this.stateChange(255);
                break;
            }
            default: {
                this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
            }
        }
        if (n2 != 1 && n2 != 255 && (n = inputStream.read()) != -1) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
    }

    public void sendServerPhase1() throws IOException {
        if (!this.resume) {
            this.session_id = new byte[32];
            this.rng.nextBytes(this.session_id);
            SSLDebug.debug(64, "Session ID", this.session_id);
            this.selectCipherSuite();
        }
        long l = System.currentTimeMillis();
        this.sendServerHello();
        long l2 = System.currentTimeMillis() - l;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        if (this.resume) {
            l = System.currentTimeMillis();
            this.computeNextCipherStates();
            this.sendChangeCipherSpec();
            this.sendFinished();
            this.stateChange(20);
            l3 = System.currentTimeMillis() - l;
        } else {
            l = System.currentTimeMillis();
            this.sendCertificate();
            l4 = System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            this.sendServerKeyExchange();
            l5 = System.currentTimeMillis() - l;
            if (this._conn.getPolicy().requireClientAuthP()) {
                l = System.currentTimeMillis();
                this.clientAuth = true;
                this.sendCertificateRequest();
                l6 = System.currentTimeMillis() - l;
                this.stateChange(2);
            } else {
                this.stateChange(3);
            }
            this.sendServerHelloDone();
        }
        SSLDebug.debug(4, "sendServerPhase():\n hello time = " + l2 + " ms\n" + " resume time = " + l3 + " ms\n" + " keyx time = " + l5 + " ms\n" + " cert req time = " + l6 + " ms\n");
    }

    public void recvSSLv2ClientHello(InputStream inputStream) throws IOException {
        SSLv2ClientHello sSLv2ClientHello = new SSLv2ClientHello();
        sSLv2ClientHello.decode(this._conn, inputStream);
        if (sSLv2ClientHello.client_version.value < 768) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
        this._conn.ssl_version = Util.min(sSLv2ClientHello.client_version.value, this._conn.ssl_version);
        this.client_offered_version = sSLv2ClientHello.client_version.value;
        if (sSLv2ClientHello.session_id.length != 0) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
        Vector<SSLuint16> vector = new Vector<SSLuint16>();
        int n = 0;
        while (n < sSLv2ClientHello.cipher_specs.value.size()) {
            SSLuint24 sSLuint24 = (SSLuint24)sSLv2ClientHello.cipher_specs.value.elementAt(n);
            if ((sSLuint24.value & 0xFF0000) == 0) {
                vector.addElement(new SSLuint16(sSLuint24.value));
            } else {
                Integer n2 = new Integer(sSLuint24.value);
                Integer n3 = (Integer)_v2_v3_cipher_suite_map.get(n2);
                if (n3 != null) {
                    vector.addElement(new SSLuint16(n3));
                }
            }
            ++n;
        }
        this.offered_cipher_suites = vector;
        this.offered_compression_methods = new Vector();
        this.offered_compression_methods.addElement(new SSLuint16(0));
        this.client_random = new byte[32];
        if (sSLv2ClientHello.challenge.length > 32) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
        if (sSLv2ClientHello.challenge.length < 16) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
        int n4 = 32 - sSLv2ClientHello.challenge.length;
        System.arraycopy(sSLv2ClientHello.challenge.value, 0, this.client_random, n4, sSLv2ClientHello.challenge.length);
        this.hashes.update(sSLv2ClientHello.message_value);
    }

    public void recvSSLv3ClientHello(InputStream inputStream) throws IOException {
        SSLClientHello sSLClientHello = new SSLClientHello();
        sSLClientHello.decode(this._conn, inputStream);
        if (sSLClientHello.client_version.value < 768) {
            this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
        }
        this._conn.ssl_version = Util.min(sSLClientHello.client_version.value, this._conn.ssl_version);
        this.client_offered_version = sSLClientHello.client_version.value;
        this.client_random = sSLClientHello.random.value;
        if (sSLClientHello.session_id.value.length != 0) {
            this.possibleResume = this.findSession(Util.toHex(sSLClientHello.session_id.value));
        }
        this.offered_cipher_suites = sSLClientHello.cipher_suites.value;
        this.offered_compression_methods = sSLClientHello.compression_methods.value;
    }

    public void selectCipherSuite() throws IOException {
        SSLDebug.debug(64, "Client offered " + this.offered_cipher_suites.size() + "ciphersuites");
        int n = 0;
        while (n < this.cipher_suites.size()) {
            SSLCipherSuite sSLCipherSuite = (SSLCipherSuite)this.cipher_suites.elementAt(n);
            SSLDebug.debug(64, "Seeing if client supports our ciphersuite " + sSLCipherSuite.getValue());
            int n2 = 0;
            while (n2 < this.offered_cipher_suites.size()) {
                if (sSLCipherSuite.getValue() == ((SSLuintX)this.offered_cipher_suites.elementAt((int)n2)).value) {
                    this.cipher_suite = sSLCipherSuite;
                    SSLDebug.debug(64, "Choosing cipher" + this.cipher_suite.getName());
                    return;
                }
                ++n2;
            }
            ++n;
        }
        this._conn.alert(SSLAlertX.TLS_ALERT_HANDSHAKE_FAILURE);
    }

    public void sendServerHello() throws IOException {
        SSLServerHello sSLServerHello = new SSLServerHello();
        sSLServerHello.server_version.value = this._conn.ssl_version;
        this.makeRandomValue(this.server_random);
        sSLServerHello.random.value = this.server_random;
        sSLServerHello.session_id.value = this.session_id;
        sSLServerHello.cipher_suite.value = this.cipher_suite.getValue();
        sSLServerHello.compression_method.value = 0;
        this.sendHandshakeMsg(this._conn, 2, sSLServerHello);
    }

    public void recvClientKeyExchange(InputStream inputStream) throws IOException {
        SSLClientKeyExchange sSLClientKeyExchange = new SSLClientKeyExchange();
        sSLClientKeyExchange.decode(this._conn, inputStream);
        this.computeMasterSecret();
        this.computeNextCipherStates();
    }

    public void recvCertificateVerify(InputStream inputStream) throws IOException {
        SSLCertificateVerify sSLCertificateVerify = new SSLCertificateVerify(this._conn, this, false);
        sSLCertificateVerify.decode(this._conn, inputStream);
    }

    public void sendServerKeyExchange() throws IOException {
        if (this.cipher_suite.requireServerKeyExchangeP(this._conn.ctx.getPrivateKey())) {
            SSLServerKeyExchange sSLServerKeyExchange = new SSLServerKeyExchange();
            this.sendHandshakeMsg(this._conn, 12, sSLServerKeyExchange);
        }
    }

    public void sendCertificateRequest() throws IOException {
        SSLCertificateRequest sSLCertificateRequest = new SSLCertificateRequest();
        this.sendHandshakeMsg(this._conn, 13, sSLCertificateRequest);
    }

    public void sendServerHelloDone() throws IOException {
        this.sendHandshakeMsg(this._conn, 14, new SSLServerHelloDone());
    }

    public void sendHelloRequest() throws IOException {
        this.sendHandshakeMsg(this._conn, 0, new SSLHelloRequest(), false);
        this._conn.sock_out.flush();
    }

    static {
        _v2_v3_cipher_suite_map.put(new Integer(65664), new Integer(4));
        _v2_v3_cipher_suite_map.put(new Integer(131200), new Integer(3));
        _v2_v3_cipher_suite_map.put(new Integer(131200), new Integer(6));
    }
}

