/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xslt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.reptile.cache.sequence.SequenceCache;
import org.openprivacy.reptile.cache.sequence.SequenceCacheHandle;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.openprivacy.reptile.xml.ReptileTransformerFactory;
import org.openprivacy.reptile.xslt.BaseStylesheetEngine;
import org.openprivacy.reptile.xslt.SequenceDispatchEntry;
import org.openprivacy.reptile.xslt.StageDumpUtil;
import org.openprivacy.reptile.xslt.StylesheetEngine;
import org.openprivacy.reptile.xslt.StylesheetStack;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import talon.Assert;
import talon.util.Log;
import talon.util.net.URI;

public class StreamStylesheetEngine
extends BaseStylesheetEngine
implements StylesheetEngine {
    static /* synthetic */ Class class$org$openprivacy$reptile$util$ParameterPasser;

    public String transform(SequenceDispatchEntry sde) throws Exception {
        return this.transform(sde, new ParameterPasser());
    }

    public String transform(SequenceDispatchEntry sde, ParameterPasser params) throws Exception {
        SequenceCacheHandle cacheHandle = new SequenceCacheHandle(sde, params);
        SequenceCache cache = SequenceCache.getInstance();
        try {
            if (sde.cacheable() && cache.contains(cacheHandle)) {
                Log.debug((String)("Found content in the sequence cache: " + cacheHandle.toString()));
                String content = cache.fetch(cacheHandle).getContent();
                cache.incrementCacheHits();
                return content;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String result = this.runTransform(sde, params);
        if (sde.cacheable()) {
            cache.store(cacheHandle, result);
            cache.incrementCacheMisses();
        }
        return result;
    }

    private String runTransform(SequenceDispatchEntry sde, ParameterPasser params) throws Exception {
        Proxy proxy = ReptileResources.getInstance().getProxy();
        Assert.assert((Object)sde.getSkeleton(), (String)"No XML identifier given.");
        XMLReader xmlReader = ReptileParserFactory.getXMLReader();
        InputSource is = new InputSource(proxy.get(sde.getSkeleton()).getInputStream());
        SAXSource xml_source = new SAXSource(xmlReader, is);
        int step = 1;
        StylesheetStack ss = sde.getStylesheetStack();
        StageDumpUtil dumputil = new StageDumpUtil();
        Iterator iterator = ss.getIterator();
        while (iterator.hasNext()) {
            URI stylesheetURI = (URI)iterator.next();
            Transformer transformer = ReptileTransformerFactory.getInstance().getTransformer(stylesheetURI);
            transformer.setParameter((class$org$openprivacy$reptile$util$ParameterPasser == null ? StreamStylesheetEngine.class$("org.openprivacy.reptile.util.ParameterPasser") : class$org$openprivacy$reptile$util$ParameterPasser).getName(), (Object)params);
            this.setParameters(transformer, params);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            try {
                transformer.transform(xml_source, result);
            }
            catch (TransformerException te) {
                this.error(te, sde, step, stylesheetURI.toString(), params);
            }
            catch (Throwable t) {
                throw new ReptileException(t);
            }
            xml_source = new SAXSource(xmlReader, new InputSource(new ByteArrayInputStream(bos.toByteArray())));
            dumputil.dump(sde, bos.toString(), step);
            if (!iterator.hasNext()) {
                return bos.toString();
            }
            ++step;
        }
        throw new Exception("No content was generated due to lack of stylesheets.");
    }

    private void setParameters(Transformer t, ParameterPasser params) {
        Enumeration enumeration = params.keys();
        String name = null;
        String value = null;
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            value = (String)params.get(name);
            t.setParameter(name, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

