/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xslt;

import java.io.File;
import java.io.FileOutputStream;
import org.openprivacy.reptile.util.SystemProperties;
import org.openprivacy.reptile.xslt.SequenceDispatchEntry;
import talon.util.Log;
import talon.util.StringUtils;
import talon.util.TalonResources;

public class StageDumpUtil {
    public static final String DUMP_ROOT = System.getProperty("java.io.tmpdir") + "/reptile-sequence-debug/";
    boolean debug = TalonResources.getInstance().getTalonPropertyManager().getBoolean("talon.log.debug");
    private long currentTimeMillis = System.currentTimeMillis();

    public void dump(SequenceDispatchEntry sde, String content, int step) {
        block2: {
            String key = "reptile.sequence.debug.enabled";
            if (!this.debug || !SystemProperties.getBoolean(key)) break block2;
            try {
                String filename = DUMP_ROOT + StringUtils.replaceAll((String)sde.getName(), (String)"urn:", (String)"urn/") + "/" + this.currentTimeMillis + "/";
                new File(filename).mkdirs();
                filename = filename + "/step-" + step + ".xml";
                Log.debug((String)("StylesheetEngine: " + filename), (Object)this);
                FileOutputStream fos = new FileOutputStream(filename);
                fos.write(content.getBytes());
                fos.close();
            }
            catch (Throwable t) {
                Log.error((Throwable)t);
            }
        }
    }
}

