/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xslt;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.serialize.DOMSerializer;
import org.apache.xalan.serialize.SerializerToXML;
import org.apache.xerces.dom.DocumentImpl;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.reptile.cache.sequence.SequenceCache;
import org.openprivacy.reptile.cache.sequence.SequenceCacheHandle;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.openprivacy.reptile.xml.ReptileTransformerFactory;
import org.openprivacy.reptile.xslt.SequenceDispatchEntry;
import org.openprivacy.reptile.xslt.StageDumpUtil;
import org.openprivacy.reptile.xslt.StylesheetEngine;
import org.openprivacy.reptile.xslt.StylesheetStack;
import org.w3c.dom.Node;
import org.xml.sax.XMLReader;
import talon.Assert;
import talon.util.Log;
import talon.util.net.URI;

public class DOMStylesheetEngine
implements StylesheetEngine {
    private static DOMStylesheetEngine instance = null;
    static /* synthetic */ Class class$org$openprivacy$reptile$util$ParameterPasser;

    public static DOMStylesheetEngine getInstance() {
        if (instance == null) {
            instance = new DOMStylesheetEngine();
        }
        return instance;
    }

    public String transform(SequenceDispatchEntry sde) throws Exception {
        return this.transform(sde, new ParameterPasser());
    }

    public String transform(SequenceDispatchEntry sde, ParameterPasser params) throws Exception {
        SequenceCacheHandle cacheHandle = new SequenceCacheHandle(sde, params);
        SequenceCache cache = SequenceCache.getInstance();
        try {
            if (sde.cacheable() && cache.contains(cacheHandle)) {
                Log.debug((String)("Found content in the sequence cache: " + cacheHandle.toString()));
                String content = cache.fetch(cacheHandle).getContent();
                cache.incrementCacheHits();
                return content;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String result = this.runTransform(sde, params);
        if (sde.cacheable()) {
            cache.store(cacheHandle, result);
            cache.incrementCacheMisses();
        }
        return result;
    }

    private String runTransform(SequenceDispatchEntry sde, ParameterPasser params) throws Exception {
        Proxy proxy = ReptileResources.getInstance().getProxy();
        Assert.assert((Object)sde.getSkeleton(), (String)"No skeleton given in SequenceDispatchEntry");
        XMLReader xmlReader = ReptileParserFactory.getXMLReader();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        DOMSource xsource = new DOMSource(builder.parse(proxy.get(sde.getSkeleton()).getInputStream()));
        int step = 1;
        StylesheetStack ss = sde.getStylesheetStack();
        StageDumpUtil dumputil = new StageDumpUtil();
        Iterator iterator = ss.getIterator();
        while (iterator.hasNext()) {
            Result result;
            URI stylesheetURI = (URI)iterator.next();
            System.out.println(" FIXME: (debug): using stylesheetURI: " + stylesheetURI.toString());
            Transformer transformer = ReptileTransformerFactory.getInstance().getTransformer(stylesheetURI);
            transformer.setParameter((class$org$openprivacy$reptile$util$ParameterPasser == null ? DOMStylesheetEngine.class$("org.openprivacy.reptile.util.ParameterPasser") : class$org$openprivacy$reptile$util$ParameterPasser).getName(), (Object)params);
            this.setParametersInTransformer(transformer, params);
            if (!iterator.hasNext()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                result = new StreamResult(bos);
                transformer.transform(xsource, result);
                String sresult = bos.toString();
                dumputil.dump(sde, sresult, step);
                return sresult;
            }
            DocumentImpl nResult = new DocumentImpl();
            result = new DOMResult((Node)nResult);
            ((DOMResult)result).setNode((Node)nResult);
            System.out.println(" FIXME: ( debug ): within step number... " + step);
            transformer.transform(xsource, result);
            xsource = new DOMSource((Node)nResult, stylesheetURI.toString());
            dumputil.dump(sde, this.serialize((DOMResult)result), step);
            ++step;
        }
        throw new Exception("No content was generated due to lack of stylesheets.");
    }

    private String serialize(DOMResult dom_result) throws Exception {
        SerializerToXML stx = new SerializerToXML();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        stx.setOutputStream((OutputStream)bos);
        DOMSerializer ds = stx.asDOMSerializer();
        ds.serialize(dom_result.getNode());
        String result = bos.toString();
        return result;
    }

    private void setParametersInTransformer(Transformer t, ParameterPasser params) {
        Enumeration enumeration = params.keys();
        String name = null;
        String value = null;
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            value = (String)params.get(name);
            t.setParameter(name, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

