/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml.serializers;

import org.jdom.CDATA;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Node;
import talon.util.Log;
import talon.util.XMLEncoder;

public class ErrorXMLSerializer {
    private String message = null;
    private Throwable throwable;

    public ErrorXMLSerializer(Throwable throwable) {
        this.throwable = throwable;
    }

    public ErrorXMLSerializer(String message) {
        this.message = message;
    }

    public Element serialize() {
        Namespace namespace = Namespace.getNamespace((String)"error", (String)"http://schemas.openprivacy.org/reptile/error");
        Element error = new Element("error", namespace);
        error.setAttribute("type", "exception");
        String message = this.throwable.getMessage();
        if (message == null) {
            message = this.message;
        }
        if (message == null) {
            message = "No message provided.";
        }
        error.addContent(new CDATA(XMLEncoder.encode((String)message)));
        return error;
    }

    public String serializeAsString() {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setEncoding("ISO-8859-1");
        String result = outputter.outputString(this.serialize());
        Log.error((String)result);
        return result;
    }

    public Node serializeAsNode() {
        try {
            return new DOMOutputter().output(this.serialize());
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return null;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

