/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml;

import java.util.Hashtable;
import java.util.Vector;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import talon.util.net.URI;

public class SubscriptionsLocationHandler
extends DefaultHandler {
    private Vector locations = new Vector(100);
    private Hashtable contentTypes = new Hashtable();
    private Proxy proxy = null;

    public SubscriptionsLocationHandler(URI subscriptions) throws ReptileException {
        try {
            this.proxy = ReptileResources.getInstance().getProxy();
            XMLReader xmlr = ReptileParserFactory.getXMLReader();
            xmlr.setContentHandler(this);
            xmlr.parse(new InputSource(this.proxy.get(subscriptions).getInputStream()));
        }
        catch (Exception e) {
            throw new ReptileException(e);
        }
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) {
        if (uri.equals("http://schemas.openprivacy.org/reptile/layout") && local.equals("content")) {
            String location = attrs.getValue("location");
            String contentType = attrs.getValue("contentType");
            this.contentTypes.put(location, contentType);
            URI location_uri = new URI(location);
            if (this.proxy.supports(new URI(location))) {
                this.locations.addElement(location);
            }
        }
    }

    public String[] getLocations() {
        Object[] found = new String[this.locations.size()];
        this.locations.copyInto(found);
        return found;
    }

    public String getContentType(String location) {
        return (String)this.contentTypes.get(location);
    }
}

