/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml;

import java.util.Hashtable;
import java.util.Iterator;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.openprivacy.reptile.xslt.SequenceDispatchEntry;
import org.openprivacy.reptile.xslt.StylesheetEngineFactory;
import org.openprivacy.reptile.xslt.StylesheetStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import talon.util.Log;
import talon.util.net.URI;

public class SequenceDispatchHandler
extends DefaultHandler {
    public static final URI RESOURCE = new URI("resource:/xml/sequence-dispatch.xml");
    private String requestedSequenceName = null;
    private Hashtable sequenceDispatchEntries = new Hashtable();
    private ParameterPasser params = null;
    private String currentSequenceName = "";

    public SequenceDispatchHandler(String requestedSequenceName, ParameterPasser params) throws ReptileException {
        this.requestedSequenceName = requestedSequenceName;
        this.params = params;
        try {
            Proxy proxy = ReptileResources.getInstance().getProxy();
            XMLReader xmlr = ReptileParserFactory.getXMLReader();
            xmlr.setContentHandler(this);
            InputSource is = new InputSource(proxy.get(RESOURCE).getInputStream());
            xmlr.parse(is);
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            throw new ReptileException(t);
        }
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) {
        if (uri.equals("http://schemas.openprivacy.org/reptile/sequence-dispatch")) {
            if (local.equals("sequence")) {
                String name = attrs.getValue("name");
                String parent = attrs.getValue("parent");
                String cacheable = attrs.getValue("cacheable");
                this.currentSequenceName = name;
                SequenceDispatchEntry sde = new SequenceDispatchEntry(name);
                sde.setParent(parent);
                if (cacheable != null) {
                    sde.setCacheable(Boolean.getBoolean(cacheable));
                }
                this.setSequenceDispatchEntry(this.currentSequenceName, sde);
            }
            if (local.equals("skeleton")) {
                this.getSequenceDispatchEntry(this.currentSequenceName).setSkeleton(attrs.getValue("location"));
            }
            if (local.equals("stylesheet")) {
                String stylesheet = attrs.getValue("location");
                this.getSequenceDispatchEntry(this.currentSequenceName).getStylesheetStack().addStylesheet(stylesheet);
            }
            if (local.equals("parameter") && this.requestedSequenceName.equals(this.currentSequenceName)) {
                String pname = attrs.getValue("name");
                String pvalue = attrs.getValue("value");
                if (pname != null && pvalue != null) {
                    this.params.put(pname, pvalue);
                }
            }
        }
    }

    public String dispatch() throws Exception {
        SequenceDispatchEntry root = this.getSequenceDispatchEntry(this.requestedSequenceName);
        if (root == null) {
            throw new Exception("The necessary sequence is not available: " + this.requestedSequenceName);
        }
        SequenceDispatchEntry real = this.normalize(root);
        return StylesheetEngineFactory.getStylesheetEngine().transform(real, this.params);
    }

    private SequenceDispatchEntry normalize(SequenceDispatchEntry sde) throws Exception {
        SequenceDispatchEntry result;
        block2: {
            Log.debug((String)"normaling SequenceDispatchEntry");
            result = new SequenceDispatchEntry(sde.getName());
            this.normalize(sde, result);
            SequenceDispatchEntry current = sde;
            Log.debug((String)"BEGIN normalizing...");
            String parent = null;
            do {
                if (current.getSkeleton() != null) {
                    result.setSkeleton(current.getSkeleton());
                }
                this.normalize(current, result);
                parent = current.getParent();
                Log.debug((String)("Normalizing parent: " + parent));
                if (parent == null) break block2;
            } while ((current = this.getSequenceDispatchEntry(parent)) != null);
            throw new Exception("The necessary sequence is not available: " + parent);
        }
        Log.debug((String)"END normalizing...");
        return result;
    }

    private SequenceDispatchEntry normalize(SequenceDispatchEntry original, SequenceDispatchEntry result) {
        StylesheetStack ss = original.getStylesheetStack();
        Iterator si = ss.getIterator();
        while (si.hasNext()) {
            result.getStylesheetStack().addStylesheet((URI)si.next());
        }
        return result;
    }

    public SequenceDispatchEntry getSequenceDispatchEntry(String name) {
        SequenceDispatchEntry entry = (SequenceDispatchEntry)this.sequenceDispatchEntries.get(name);
        if (entry == null) {
            Log.warn((String)("Could not find sequence: " + name));
        }
        return entry;
    }

    public void setSequenceDispatchEntry(String name, SequenceDispatchEntry entry) {
        this.sequenceDispatchEntries.put(name, entry);
    }
}

