/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jaxen.jdom.XPath;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openprivacy.reptile.util.ReptileResources;

public class ReptileXPath {
    private Document document = null;
    private XPath xpath = null;

    public ReptileXPath(String content, String xpath_expression) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        this.document = builder.build((Reader)new StringReader(content));
        this.xpath = new XPath(xpath_expression);
    }

    public List selectNodes() throws Exception {
        return this.xpath.selectNodes((Object)this.document);
    }

    public Object selectSingleNode() throws Exception {
        return this.xpath.selectSingleNode((Object)this.document);
    }

    public void addNamespace(String prefix, String uri) throws Exception {
        this.xpath.addNamespace(prefix, uri);
    }

    public static void assertXPathNodes(String content, String expression) throws Exception {
        System.out.println(content);
        ReptileXPath xpath = ReptileXPath.getReptileXPath(content, expression);
        List result = xpath.selectNodes();
        if (result.size() == 0) {
            System.out.println(content);
            throw new Exception("Didn't find any results for query: " + expression);
        }
    }

    public static void assertXPath(String content, String expression, String value) throws Exception {
        ReptileXPath xpath = ReptileXPath.getReptileXPath(content, expression);
        Object result = xpath.selectSingleNode();
        if (result instanceof Attribute) {
            Attribute attr = (Attribute)result;
            if (!attr.getValue().equals(value)) {
                throw new Exception("XPath expression not equal: " + attr.getValue() + " != " + value);
            }
        } else if (result instanceof Element) {
            Element elem = (Element)result;
            if (!elem.getText().equals(value)) {
                throw new Exception("XPath expression not equal: " + elem.getText() + " != " + value);
            }
        } else {
            throw new Exception("Invalid result: " + result);
        }
    }

    public static void assertXPathNotEqual(String content, String expression, String value) throws Exception {
        ReptileXPath xpath = ReptileXPath.getReptileXPath(content, expression);
        Object result = xpath.selectSingleNode();
        if (result instanceof Attribute) {
            Attribute attr = (Attribute)result;
            String avalue = attr.getValue();
            if (avalue.equals(value) || avalue == null) {
                throw new Exception("XPath expression equal: " + attr.getValue() + " != " + value);
            }
        } else if (result instanceof Element) {
            Element elem = (Element)result;
            String text = elem.getText();
            if (text.equals(value) || text == null) {
                throw new Exception("XPath expression equal: " + elem.getText() + " != " + value);
            }
        } else {
            throw new Exception("Invalid result: " + result);
        }
    }

    private static ReptileXPath getReptileXPath(String content, String expression) throws Exception {
        ReptileXPath xpath = new ReptileXPath(content, expression);
        xpath.addNamespace("search", "http://schemas.openprivacy.org/reptile/search");
        xpath.addNamespace("rss", "http://purl.org/rss/1.0/");
        xpath.addNamespace("rdf", ReptileResources.RDF_NAMESPACE);
        return xpath;
    }
}

