/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml;

import java.util.Hashtable;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import talon.util.Log;
import talon.util.net.URI;

public class ReptileTransformerFactory {
    private Hashtable proxyEntryCache = new Hashtable();
    private Hashtable templatesCache = new Hashtable();
    private Proxy proxy = ReptileResources.getInstance().getProxy();
    private static ReptileTransformerFactory instance = null;
    private TransformerFactory transformerFactory = null;

    public Transformer getTransformer(URI stylesheet) throws ReptileException {
        try {
            Transformer transformer = this.getTemplates(stylesheet.toString()).newTransformer();
            transformer.setURIResolver(this.proxy.getURIResolver());
            return transformer;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new ReptileException(e);
        }
    }

    public TransformerHandler getTransformerHandler(String stylesheet) throws Exception {
        SAXTransformerFactory stf = (SAXTransformerFactory)this.transformerFactory;
        TransformerHandler th = stf.newTransformerHandler(this.getTemplates(stylesheet));
        th.getTransformer().setURIResolver(this.proxy.getURIResolver());
        return th;
    }

    private Templates getTemplates(String stylesheet) throws Exception {
        Log.debug((String)("Getting template for: " + stylesheet), (Object)this);
        ProxyEntry pe = (ProxyEntry)this.proxyEntryCache.get(stylesheet);
        if (pe == null) {
            pe = this.proxy.get(stylesheet);
            this.proxyEntryCache.put(stylesheet, pe);
        }
        if (pe.hasChanged()) {
            Log.message((String)("Template changed, updating cache: " + stylesheet), (Object)this);
            this.proxyEntryCache.put(stylesheet, this.proxy.get(stylesheet));
            return this.newTemplates(stylesheet);
        }
        Templates templates = (Templates)this.templatesCache.get(stylesheet);
        if (templates == null) {
            return this.newTemplates(stylesheet);
        }
        Log.debug((String)("Found templates in cache: " + stylesheet), (Object)this);
        return templates;
    }

    private Templates newTemplates(String stylesheet) throws Exception {
        XMLReader xmlReader = ReptileParserFactory.getXMLReader();
        InputSource is = new InputSource(this.proxy.get(stylesheet).getInputStream());
        SAXSource source = new SAXSource(xmlReader, is);
        Templates templates = this.getTransformerFactory().newTemplates(source);
        this.templatesCache.put(stylesheet, templates);
        return templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            ReptileTransformerFactory reptileTransformerFactory = this;
            synchronized (reptileTransformerFactory) {
                this.transformerFactory = TransformerFactory.newInstance();
                this.transformerFactory.setURIResolver(this.proxy.getURIResolver());
            }
        }
        return this.transformerFactory;
    }

    public String getTransformerFactoryImplementation() {
        return this.getTransformerFactory().getClass().getName();
    }

    public void flushTemplatesCache() {
        this.templatesCache = new Hashtable();
    }

    public int getTemplatesCacheSize() {
        return this.templatesCache.size();
    }

    public static ReptileTransformerFactory getInstance() {
        if (instance == null) {
            instance = new ReptileTransformerFactory();
        }
        return instance;
    }
}

