/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tests;

import junit.framework.TestCase;
import org.jdom.Attribute;
import org.jdom.Element;
import org.openprivacy.reptile.xml.ReptileXPath;

public class JUnitXPathTest
extends TestCase {
    public JUnitXPathTest(String name) {
        super(name);
    }

    public void testSelectSingleNodeWithElement() throws Exception {
        ReptileXPath xpath = new ReptileXPath("<hello>world</hello>", "/hello");
        Element element = (Element)xpath.selectSingleNode();
        JUnitXPathTest.assert((boolean)element.getText().equals("world"));
    }

    public void testSelectSingleNodeWithAttribute() throws Exception {
        ReptileXPath xpath = new ReptileXPath("<hello foo=\"bar\"></hello>", "/hello/@foo");
        Attribute attr = (Attribute)xpath.selectSingleNode();
        JUnitXPathTest.assert((boolean)attr.getValue().equals("bar"));
    }

    public void testSelectSingleNodeWithNamespaces() throws Exception {
        ReptileXPath xpath = new ReptileXPath("<hello:hello xmlns:hello=\"hello\" foo=\"bar\"></hello:hello>", "/hello:hello/@foo");
        xpath.addNamespace("hello", "hello");
        Attribute attr = (Attribute)xpath.selectSingleNode();
        JUnitXPathTest.assert((boolean)attr.getValue().equals("bar"));
    }
}

