/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.openprivacy.reptile.RelativizeContentParser;

public class JUnitRelativizeTests
extends TestCase {
    public JUnitRelativizeTests(String name) {
        super(name);
    }

    public void testRelativize() throws Exception {
        RelativizeContentParser test = new RelativizeContentParser();
        test.setResource("http://www.cnn.com/foo/bar/");
        Assert.assertEquals((Object)"<a href=\"http://www.cnn.com/foo/bar/foo.html\">foo</a>", (Object)test.relativize("<a href=\"foo.html\">foo</a>"));
        Assert.assertEquals((Object)"<img src=\"http://www.cnn.com/foo/bar/bar.jpg\"></a>", (Object)test.relativize("<img src=\"bar.jpg\"></a>"));
        Assert.assertEquals((Object)"<img SRC=\"http://www.cnn.com/foo/bar/bar.jpg\" BORDER=\"0\"></a>", (Object)test.relativize("<img SRC=\"bar.jpg\" BORDER=\"0\"></a>"));
        Assert.assertEquals((Object)"<a href=\"http://www.cnn.com/foo/bar/foo.html\"><img src=\"http://www.cnn.com/foo/bar/bar.jpg\"></a>", (Object)test.relativize("<a href=\"foo.html\"><img src=\"bar.jpg\"></a>"));
        Assert.assertEquals((Object)"foo bar", (Object)test.relativize("foo bar"));
    }

    public void testExpand() throws Exception {
        RelativizeContentParser test = new RelativizeContentParser();
        test.setResource("http://www.cnn.com/foo/bar/index.html");
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/foo.html", (Object)test.expand("foo.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/index.html#name", (Object)test.expand("#name"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html", (Object)test.expand("/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/cat/index.html", (Object)test.expand("cat/index.html"));
        test = new RelativizeContentParser();
        test.setResource("http://www.cnn.com/");
        Assert.assertEquals((Object)"http://www.cnn.com/foo.html", (Object)test.expand("foo.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/#name", (Object)test.expand("#name"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html", (Object)test.expand("/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/cat/index.html", (Object)test.expand("cat/index.html"));
        test = new RelativizeContentParser();
        test.setResource("http://www.cnn.com/index.html");
        Assert.assertEquals((Object)"http://www.cnn.com/foo.html", (Object)test.expand("foo.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html#name", (Object)test.expand("#name"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html", (Object)test.expand("/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/cat/index.html", (Object)test.expand("cat/index.html"));
        test = new RelativizeContentParser();
        test.setResource("http://www.cnn.com/foo/bar/");
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/foo.html", (Object)test.expand("foo.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/#name", (Object)test.expand("#name"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html", (Object)test.expand("/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/cat/index.html", (Object)test.expand("cat/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/", (Object)test.expand("../"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/SRDF/index.html", (Object)test.expand("../SRDF/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/", (Object)test.expand(".."));
        Assert.assertEquals((Object)"http://www.cnn.com/", (Object)test.expand("../.."));
        Assert.assertEquals((Object)"http://www.cnn.com/", (Object)test.expand("../../"));
        test = new RelativizeContentParser();
        test.setResource("http://www.theregister.co.uk/content/54/26810.html");
        Assert.assertEquals((Object)"http://www.theregister.co.uk", (Object)test.getSite());
        Assert.assertEquals((Object)"http://www.theregister.co.uk/images/reg_bullet.gif", (Object)test.expand("/images/reg_bullet.gif"));
        test = new RelativizeContentParser();
        test.setResource("http://www.politechbot.com");
        Assert.assertEquals((Object)"http://www.politechbot.com/p-03950.html", (Object)test.expand("p-03950.html"));
        test = new RelativizeContentParser();
        test.setResource("http://www.barebones.com/support/bbedit/bbedit-notes.html");
        System.out.println("barebones test");
        Assert.assertEquals((Object)"http://www.barebones.com/images/bbsw_banner/support.gif", (Object)test.expand("../../images/bbsw_banner/support.gif"));
    }
}

