/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.openprivacy.reptile.RSSContentSerializer;

public class JUnitRSSParseInternalTests
extends TestCase {
    public JUnitRSSParseInternalTests(String name) {
        super(name);
    }

    public void testStrip() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        Assert.assertEquals((Object)"foo bar", (Object)test.strip("    foo     bar   "));
    }

    public void testIsJunkContent() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        Assert.assertTrue((boolean)test.isJunkContent("<a href=\"asdf\">foo</a>"));
        Assert.assertTrue((!test.isJunkContent("<p>Hello World</p>") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.isJunkContent("<li><a href=\"http://linuxcentral.com/catalog/index.php3?prod_code=B000-297\">Cutomizing and Upgrading Linux</a>"));
        Assert.assertTrue((!test.isJunkContent("<a href=\"asdf\">foo</a> This is a real paragraph.") ? 1 : 0) != 0);
        Assert.assertTrue((!test.isJunkContent("<a href=\"http://www.tuxedo.org/~esr/\" target=\"_top\">Eric Raymond</a> has released version 1.0.0 of <a href=\"http://www.tuxedo.org/~esr/doclifter/\" target=\"_top\">doclifter</a>, a Python 2.2 utility that converts man pages and other troff/nroff/groff documents to <a href=\"http://docbook.org/wiki/moin.cgi/DocBook\" target=\"_top\">DocBook</a> XML and SGML.") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.isJunkContent("<span><a href=\"asdf\">foo</a></span>"));
        String content = "<span class=\"secondary\"> <a href=\"http://www.xml.com/cs/user/login\">Manage Your Account</a><br /> <a href=\"http://www.xml.com/cs/user/lostpw\">Forgot Your Password?</a></span>";
        Assert.assertTrue((boolean)test.isJunkContent(content));
        Assert.assertTrue((boolean)test.isJunkContent("<img src=\"/images/blue-arrow.gif\" alt=\" \" width=\"10\" height=\"12\" border=\"0\" align=\"top\"> <img src=\"/universal/images/find.gif\" width=\"36\" height=\"11\" alt=\"Find\" border=\"0\"><br /> <a href=\"http://www.xml.com/search/\">Search</a><br /> <a href=\"/ArticlesbyTopic/\">Article Archive</a><br /> <a href=\"http://www.oreillynet.com/faqs/list.csp?id_subject=23\">FAQs</a><br /><br />"));
        Assert.assertTrue((boolean)test.isJunkContent("<b class=\"a2\">\n<a href=\"/2020-1069-0.html\">News.context:</a>\n<a href=\"/2018-1070-0.html\">Special Reports</a>\n | \n<a href=\"/2005-1082-0.html\">Newsmakers</a>\n | \n<span class=\"g3\">Perspectives</span>\n </b>"));
        Assert.assertTrue((boolean)test.isJunkContent("<A HREF=\"http://www.washingtonpost.com/ac2/wp-dyn?node=admin/registration/manage&destination=emailPreferences&nextstep=gather\">E-MAIL NEWSLETTERS</A> |<A HREF=\"http://www.washingtonpost.com/wp-adv/archives/front.htm\">ARCHIVES</A>"));
    }

    public void testExpand() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        test.setResource("http://www.cnn.com/foo/bar/index.html");
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/foo.html", (Object)test.expand("foo.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/index.html#name", (Object)test.expand("#name"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html", (Object)test.expand("/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/cat/index.html", (Object)test.expand("cat/index.html"));
        test = new RSSContentSerializer();
        test.setResource("http://www.cnn.com/");
        Assert.assertEquals((Object)"http://www.cnn.com/foo.html", (Object)test.expand("foo.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/#name", (Object)test.expand("#name"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html", (Object)test.expand("/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/cat/index.html", (Object)test.expand("cat/index.html"));
        test = new RSSContentSerializer();
        test.setResource("http://www.cnn.com/index.html");
        Assert.assertEquals((Object)"http://www.cnn.com/foo.html", (Object)test.expand("foo.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html#name", (Object)test.expand("#name"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html", (Object)test.expand("/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/cat/index.html", (Object)test.expand("cat/index.html"));
        test = new RSSContentSerializer();
        test.setResource("http://www.cnn.com/foo/bar/");
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/foo.html", (Object)test.expand("foo.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/#name", (Object)test.expand("#name"));
        Assert.assertEquals((Object)"http://www.cnn.com/index.html", (Object)test.expand("/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/bar/cat/index.html", (Object)test.expand("cat/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/", (Object)test.expand("../"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/SRDF/index.html", (Object)test.expand("../SRDF/index.html"));
        Assert.assertEquals((Object)"http://www.cnn.com/foo/", (Object)test.expand(".."));
        Assert.assertEquals((Object)"http://www.cnn.com/", (Object)test.expand("../.."));
        Assert.assertEquals((Object)"http://www.cnn.com/", (Object)test.expand("../../"));
        test = new RSSContentSerializer();
        test.setResource("http://www.theregister.co.uk/content/54/26810.html");
        Assert.assertEquals((Object)"http://www.theregister.co.uk", (Object)test.getSite());
        Assert.assertEquals((Object)"http://www.theregister.co.uk/images/reg_bullet.gif", (Object)test.expand("/images/reg_bullet.gif"));
        test = new RSSContentSerializer();
        test.setResource("http://www.politechbot.com");
        Assert.assertEquals((Object)"http://www.politechbot.com/p-03950.html", (Object)test.expand("p-03950.html"));
    }

    public void testCleanseHTML() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        Assert.assertEquals((Object)"<p></p>", (Object)test.cleanseHTML("<p></p>"));
        Assert.assertEquals((Object)"<p></p>", (Object)test.cleanseHTML("<p><!-- hello world --></p>"));
        Assert.assertEquals((Object)"<p></p>", (Object)test.cleanseHTML("<p><!-- <p>hello world</p> --></p>"));
        test = new RSSContentSerializer();
        test.setResource("http://projects.localhost/tests/test2.html");
        test.init();
        Assert.assertTrue((test.getHTML().indexOf("<script") == -1 ? 1 : 0) != 0);
    }

    public void testCleansePCDATA() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        Assert.assertEquals((Object)"Hello World", (Object)test.cleansePCDATA("<font FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=2 COLOR=\"#333333\">Hello World</font>"));
    }

    public void testCleanseTitle() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        Assert.assertEquals((Object)"Wifi commons and Wifi castles I got to thinking about the", (Object)test.cleanseTitle("10-september-2002 Wifi commons and Wifi castles I got to thinking about the"));
    }

    public void testRelativize() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        test.setResource("http://www.cnn.com/foo/bar/");
        Assert.assertEquals((Object)"<a href=\"http://www.cnn.com/foo/bar/foo.html\">foo</a>", (Object)test.relativize("<a href=\"foo.html\">foo</a>"));
        Assert.assertEquals((Object)"<img src=\"http://www.cnn.com/foo/bar/bar.jpg\"></a>", (Object)test.relativize("<img src=\"bar.jpg\"></a>"));
        Assert.assertEquals((Object)"<img SRC=\"http://www.cnn.com/foo/bar/bar.jpg\" BORDER=\"0\"></a>", (Object)test.relativize("<img SRC=\"bar.jpg\" BORDER=\"0\"></a>"));
        Assert.assertEquals((Object)"<a href=\"http://www.cnn.com/foo/bar/foo.html\"><img src=\"http://www.cnn.com/foo/bar/bar.jpg\"></a>", (Object)test.relativize("<a href=\"foo.html\"><img src=\"bar.jpg\"></a>"));
        Assert.assertEquals((Object)"foo bar", (Object)test.relativize("foo bar"));
    }

    public void testGetMinRepassContentLength() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        test.setResource("http://projects.localhost/tests/test2.html");
        test.init();
        test.getMinRepassContentLength();
    }

    public void testTitleFromDescription() throws Exception {
        RSSContentSerializer test = new RSSContentSerializer();
        test.setResource("http://www.foxnews.com/story/0,2933,63426,00.html");
        test.parse();
        String string = test.getDescription();
    }
}

