/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tests;

import org.apache.cactus.ServletTestCase;
import org.jdom.Element;
import org.openprivacy.reptile.search.SearchProvider;
import org.openprivacy.reptile.search.SearchProviderManager;
import org.openprivacy.reptile.search.SearchRecord;
import org.openprivacy.reptile.search.SearchRequest;
import org.openprivacy.reptile.search.SearchSerializer;
import org.openprivacy.reptile.tests.FakeSearchProvider;
import org.openprivacy.reptile.xml.ReptileXPath;

public class CactusTestSearch
extends ServletTestCase {
    static /* synthetic */ Class class$org$openprivacy$reptile$search$impl$ArticleSearchProvider;

    public CactusTestSearch(String name) {
        super(name);
    }

    public void testSearchRecord() throws Exception {
        SearchRecord record = new SearchRecord();
        record.setTitle("title");
        record.setDescription("description");
        record.setLink("link");
        record.setIndex(0);
        Element elem = record.serialize();
        CactusTestSearch.assertNotNull((Object)elem);
    }

    public void testSearchProviderManager() throws Exception {
        Class c_asp = class$org$openprivacy$reptile$search$impl$ArticleSearchProvider == null ? (class$org$openprivacy$reptile$search$impl$ArticleSearchProvider = CactusTestSearch.class$("org.openprivacy.reptile.search.impl.ArticleSearchProvider")) : class$org$openprivacy$reptile$search$impl$ArticleSearchProvider;
        SearchProvider sp = SearchProviderManager.getInstance().newProvider(c_asp);
        CactusTestSearch.assertTrue((c_asp == sp.getClass() ? 1 : 0) != 0);
    }

    public void testArticleSearchBasicCriteria() throws Exception {
        this.execSearch("Linux", class$org$openprivacy$reptile$search$impl$ArticleSearchProvider == null ? (class$org$openprivacy$reptile$search$impl$ArticleSearchProvider = CactusTestSearch.class$("org.openprivacy.reptile.search.impl.ArticleSearchProvider")) : class$org$openprivacy$reptile$search$impl$ArticleSearchProvider);
    }

    public void testSearchSerializerWithLinuxAsQuery() throws Exception {
        SearchProvider sp = this.execSearch("Linux", class$org$openprivacy$reptile$search$impl$ArticleSearchProvider == null ? (class$org$openprivacy$reptile$search$impl$ArticleSearchProvider = CactusTestSearch.class$("org.openprivacy.reptile.search.impl.ArticleSearchProvider")) : class$org$openprivacy$reptile$search$impl$ArticleSearchProvider);
        SearchSerializer serializer = new SearchSerializer(sp);
        String content = serializer.serializeAsString(0);
        ReptileXPath.assertXPath(content, "/search:search/search:results/@start", "0");
        ReptileXPath.assertXPath(content, "/search:search/search:results/@end", "9");
    }

    private SearchProvider execSearch(String criteria, Class provider_class) throws Exception {
        SearchProviderManager spm = SearchProviderManager.getInstance();
        SearchProvider sp = spm.newProvider(provider_class);
        SearchRequest request = new SearchRequest();
        request.addCriteria(criteria);
        CactusTestSearch.assertEquals((int)sp.getState(), (int)1);
        sp.search(request);
        CactusTestSearch.assertEquals((int)sp.getState(), (int)4);
        CactusTestSearch.assertTrue((sp.getResultCount() != 0 ? 1 : 0) != 0);
        CactusTestSearch.assertTrue((spm.getSearchProviderCount() != 0 ? 1 : 0) != 0);
        return sp;
    }

    public void testSerializerPageNavigation() throws Exception {
        FakeSearchProvider fsp = new FakeSearchProvider();
        SearchSerializer serializer = new SearchSerializer(fsp);
        String content = serializer.serializeAsString(0);
        ReptileXPath.assertXPath(content, "/search:search/search:results/@start", "0");
        ReptileXPath.assertXPath(content, "/search:search/search:results/@end", "0");
        try {
            serializer.serialize(1);
            throw new Exception("This should have failed!");
        }
        catch (Exception e) {
            System.out.println("testSerializerPageNavigation: Exception caught successfully. " + e.getMessage());
            fsp.addRecord(new SearchRecord());
            content = serializer.serializeAsString(0);
            ReptileXPath.assertXPath(content, "/search:search/search:results/@start", "0");
            ReptileXPath.assertXPath(content, "/search:search/search:results/@end", "1");
            fsp.addRecord(new SearchRecord());
            fsp.addRecord(new SearchRecord());
            fsp.addRecord(new SearchRecord());
            fsp.addRecord(new SearchRecord());
            fsp.addRecord(new SearchRecord());
            fsp.addRecord(new SearchRecord());
            fsp.addRecord(new SearchRecord());
            fsp.addRecord(new SearchRecord());
            fsp.addRecord(new SearchRecord());
            content = serializer.serializeAsString(0);
            CactusTestSearch.assertEquals((int)fsp.getResultCount(), (int)10);
            ReptileXPath.assertXPath(content, "/search:search/search:results/@start", "0");
            ReptileXPath.assertXPath(content, "/search:search/search:results/@end", "9");
            ReptileXPath.assertXPath(content, "/search:search/search:results/@found", "10");
            ReptileXPath.assertXPath(content, "/search:search/search:results/@page", "0");
            ReptileXPath.assertXPath(content, "/search:search/search:results/@total-pages", "1");
            fsp.addRecord(new SearchRecord());
            CactusTestSearch.assertEquals((int)2, (int)serializer.getPageCount());
            content = serializer.serializeAsString(0);
            ReptileXPath.assertXPath(content, "/search:search/search:results/@total-pages", "2");
            content = serializer.serializeAsString(1);
            ReptileXPath.assertXPath(content, "/search:search/search:results/@start", "10");
            ReptileXPath.assertXPath(content, "/search:search/search:results/@end", "11");
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

