/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tests;

import org.apache.cactus.ServletTestCase;
import org.openprivacy.reptile.extensions.ContentTransformer;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.xml.ReptileXPath;

public class CactusTestContentTransformer
extends ServletTestCase {
    public CactusTestContentTransformer(String name) {
        super(name);
    }

    public void testRSS_0_9() throws Exception {
        this.testResource("resource:/xml/tests/test-rss-0.9.xml");
    }

    public void testRSS_0_9_1_dtd() throws Exception {
        this.testResource("resource:/xml/tests/test-rss-0.91-dtd.xml");
        this.testResource("resource:/xml/tests/newscat.xml");
    }

    private void testResource(String resource) throws Exception {
        this.transformAndAssert(resource, "http://my.netscape.com/rdf/simple/0.9/");
        this.transformAndAssert(resource, "http://my.netscape.com/publish/formats/rss-0.91.dtd");
        this.transformAndAssert(resource, "http://my.netscape.com/publish/formats/rss-0.9.dtd");
    }

    private void transformAndAssert(String resource, String contentType) throws Exception {
        ContentTransformer transformer = new ContentTransformer(new ParameterPasser());
        String output = transformer.transform(resource, contentType, "http://purl.org/rss/1.0/");
        ReptileXPath.assertXPathNodes(output, "/rdf:RDF/rss:item");
    }
}

