/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tasks;

import java.util.Enumeration;
import org.openprivacy.reptile.tasks.Task;
import org.openprivacy.reptile.tasks.TaskManager;
import talon.util.Log;

public class TaskThread
extends Thread {
    public static final long INITIAL_SLEEP = 10000L;
    public static final long SLEEP = 30000L;
    private static ThreadGroup group = new ThreadGroup("urn:reptile/threadgroup/tasks");

    public TaskThread() {
        super(group, "TaskThread");
        Log.message((String)"TaskThread created...", (Object)this);
        super.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.initialsleep();
            while (true) {
                if (TaskManager.checkTaskSystemDisabled()) {
                    return;
                }
                this.runTasks();
                TaskThread taskThread = this;
                synchronized (taskThread) {
                    this.wait(30000L);
                }
            }
        }
        catch (Throwable t) {
            Log.debug((String)t.getMessage(), (Object)this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        Enumeration tasks = TaskManager.getInstance().getTasks();
        while (tasks.hasMoreElements()) {
            Task task;
            if (TaskManager.checkTaskSystemDisabled()) {
                return;
            }
            Task task2 = task = (Task)tasks.nextElement();
            synchronized (task2) {
                TaskManager.runTask(task);
            }
        }
    }

    private void displaytasks() {
        TaskManager tm = TaskManager.getInstance();
        Log.message((String)("TaskThread: the following " + tm.getTaskCount() + " tasks are known within the TaskManager: "), (Object)this);
        Enumeration tasks = tm.getTasks();
        while (tasks.hasMoreElements()) {
            Task task = (Task)tasks.nextElement();
            Log.message((String)("TaskThread:    " + task.getIdentifier()), (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialsleep() {
        Log.message((String)"TaskThread: Sleeping ... 10000", (Object)this);
        try {
            TaskThread taskThread = this;
            synchronized (taskThread) {
                this.wait(10000L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

