/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tasks;

import java.util.Enumeration;
import java.util.Hashtable;
import org.openprivacy.reptile.om.TaskLogPeer;
import org.openprivacy.reptile.tasks.Task;
import org.openprivacy.reptile.util.SystemProperties;
import talon.util.Log;

public class TaskManager {
    private static TaskManager instance = null;
    private Hashtable tasks = new Hashtable();

    public static TaskManager getInstance() {
        if (instance == null) {
            instance = new TaskManager();
        }
        return instance;
    }

    public boolean contains(String identifier) {
        return this.tasks.containsKey(identifier);
    }

    public Enumeration getTasks() {
        return this.tasks.elements();
    }

    public void register(Class clazz) throws Exception {
        this.register((Task)clazz.newInstance());
    }

    public void register(Task task) throws Exception {
        this.tasks.put(task.getIdentifier(), task);
    }

    public void unregister(String identifier) throws Exception {
        this.tasks.remove(identifier);
    }

    public static boolean checkTaskSystemDisabled() {
        boolean restarted = SystemProperties.getBoolean("reptile.system.restarted");
        boolean tasksDisabled = SystemProperties.getBoolean("reptile.system.tasks.disabled");
        if (restarted || tasksDisabled) {
            Log.warn((String)"Reptile tasks restarted or disabled.");
            return true;
        }
        return false;
    }

    public Task getTask(String identifier) throws Exception {
        return (Task)this.tasks.get(identifier);
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public boolean anyTasksRunning() {
        Enumeration tasks = this.getTasks();
        while (tasks.hasMoreElements()) {
            Task task = (Task)tasks.nextElement();
            if (!task.isRunning()) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        System.out.print("Destroying tasks system...");
        System.setProperty("reptile.system.tasks.disabled", "true");
        long maxtime = 60000L;
        long started = System.currentTimeMillis();
        while (this.anyTasksRunning()) {
            try {
                Thread.sleep(300L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            System.out.print(".");
            if (System.currentTimeMillis() - started <= maxtime) continue;
            System.out.println("Maxtime for stopping tasks has exceeded: " + maxtime);
            break;
        }
        System.out.println("");
        System.out.println("Destroying tasks system...done");
    }

    public static void runTask(Task task) {
        try {
            if (task.getLastRan() + task.getInterval() < System.currentTimeMillis()) {
                task.setState("Running");
                Log.message((String)("TaskThread: running task - " + task.getIdentifier()), (Object)task);
                task.run();
                task.setState("Paused");
                task.setLastRan(System.currentTimeMillis());
                task.setLastMessage("");
                TaskLogPeer.success(task);
            }
        }
        catch (Throwable t) {
            task.setState("Failed");
            task.setLastMessage(t);
            task.setLastRan(System.currentTimeMillis());
            TaskLogPeer.failed(task, t);
            Log.error((Object)task, (Throwable)t);
        }
    }
}

