/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.services;

import java.util.Vector;
import org.jxta.bridge.ServiceDescriptor;
import org.openprivacy.reptile.search.SearchProvider;
import org.openprivacy.reptile.search.SearchProviderManager;
import org.openprivacy.reptile.search.SearchRecord;
import org.openprivacy.reptile.search.SearchRequest;
import org.openprivacy.reptile.search.SearchSerializer;
import org.openprivacy.reptile.search.requests.AdvancedSearchRequest;

public class ReptileSearchService {
    public static final ServiceDescriptor DESCRIPTOR = new ServiceDescriptor((class$org$openprivacy$reptile$services$ReptileSearchService == null ? (class$org$openprivacy$reptile$services$ReptileSearchService = ReptileSearchService.class$("org.openprivacy.reptile.services.ReptileSearchService")) : class$org$openprivacy$reptile$services$ReptileSearchService).getName(), "urn:reptile/jxta/service/ReptileSearchService", "1.0.0", "OpenPrivacy.org", "http://reptile.openprivacy.org", "A service this allow you to say hello.", System.getProperty("reptile.jxta.peergroup.id"), System.getProperty("reptile.jxta.peergroup.name"), System.getProperty("reptile.jxta.peergroup.description"), true);
    public static final String[] ADVANCED_SEARCH_REQUESTS = new String[]{"UnreadArticlesSearchRequest", "RSSWeblogSearchRequest", "RecentArticlesSearchRequest", "NewestArticlesSearchRequest", "ChannelHistorySearchRequest", "BrowseWeblogSearchRequest", "BrowseChannelsSearchRequest"};
    public static final String[] SEARCH_PROVIDERS = new String[]{"ArticleSearchProvider", "ChannelSearchProvider", "WeblogSearchProvider"};
    private Vector requests = new Vector();
    private Vector providers = new Vector();
    static /* synthetic */ Class class$org$openprivacy$reptile$services$ReptileSearchService;

    public ReptileSearchService() {
        this.include(ADVANCED_SEARCH_REQUESTS, this.requests);
        this.include(SEARCH_PROVIDERS, this.providers);
    }

    public String searchByAdvancedSearchRequest(String name) throws Exception {
        this.assertValidRequest(name);
        AdvancedSearchRequest req = (AdvancedSearchRequest)Class.forName("org.openprivacy.reptile.search.requests." + name).newInstance();
        Class cprovider = req.getRequiredSearchProvider();
        if (cprovider == null) {
            throw new Exception("No provider specified.");
        }
        SearchProvider provider = SearchProviderManager.getInstance().newProvider(cprovider);
        provider.search(req);
        return provider.getHandle();
    }

    public String search(String criteria, String provider) throws Exception {
        this.assertValidProvider(provider);
        Class<?> cprovider = Class.forName("org.openprivacy.reptile.search.impl." + provider);
        SearchProvider p = SearchProviderManager.getInstance().newProvider(cprovider);
        SearchRequest req = new SearchRequest();
        req.getCriteria().add(criteria);
        p.search(req);
        return p.getHandle();
    }

    public String[] getAdvancedSearchRequests() {
        return ADVANCED_SEARCH_REQUESTS;
    }

    public String[] getSearchProviders() {
        return SEARCH_PROVIDERS;
    }

    private void include(Object[] objs, Vector v) {
        int i = 0;
        while (i < objs.length) {
            v.addElement(objs[i]);
            ++i;
        }
    }

    private void assertValidRequest(String request) throws Exception {
        if (!this.requests.contains(request)) {
            throw new Exception("Invalid request: " + request);
        }
    }

    private void assertValidProvider(String provider) throws Exception {
        if (!this.providers.contains(provider)) {
            throw new Exception("Invalid provider: " + provider);
        }
    }

    public String serialize(String handle, int page) throws Exception {
        SearchProvider provider = SearchProviderManager.getInstance().getSearchProvider(handle);
        SearchSerializer serializer = new SearchSerializer(provider);
        return serializer.serializeAsString(page);
    }

    public SearchRecord[] records(String handle, int begin, int end) throws Exception {
        Vector<SearchRecord> v = new Vector<SearchRecord>();
        SearchProvider provider = SearchProviderManager.getInstance().getSearchProvider(handle);
        int i = begin;
        while (i <= end) {
            SearchRecord record = new SearchRecord();
            record.setIndex(i);
            provider.record(record);
            v.addElement(record);
            ++i;
        }
        Object[] records = new SearchRecord[v.size()];
        v.copyInto(records);
        return records;
    }

    public int getResultCount(String handle) throws Exception {
        SearchProvider provider = SearchProviderManager.getInstance().getSearchProvider(handle);
        return provider.getResultCount();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

